/*
 * File:     DataLocator.java
 * Project:  MPI Linguistic Application
 * Date:     25 August 2009
 *
 * Copyright (C) 2001-2009  Max Planck Institute for Psycholinguistics
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */

package mpi.eudico.server.corpora.location;

import java.io.Serializable;


/**
 * DataLocator specifies an access point to data for a specific Corpus. It
 * stores an access point to data such as a URL or a JDBC Connection. Each
 * specific Corpus is supposed to have it's own subclass of DataLocator. All
 * Corpus data objects have a (list of) DataLocator reference(s) associated
 * with them, one for each Identity using the object. This mapping is
 * administered by a LocatorManager.
 *
 * @author Hennie Brugman
 * @author Albert Russel
 * @version 11-Sep-1998
 */
public class DataLocator implements Serializable {
}
