/*
 * File:     DataLocatorList.java
 * Project:  MPI Linguistic Application
 * Date:     25 August 2009
 *
 * Copyright (C) 2001-2009  Max Planck Institute for Psycholinguistics
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */

package mpi.eudico.server.corpora.location;


/**
 * DataLocatorList is implemented by all Corpus data objects that can be shared
 * by multiple Identities. For each Identity there exists a DataLocator
 * reference in the object's DataLocatorList. If appropriate, a
 * DataLocatorList can create a DataLocator for an Identity in
 * 'getDataLocator'. For example, GestureCorpus creates DataLocators that are
 * used for all it's GestureTranscriptions.
 *
 * @author Hennie Brugman
 * @author Albert Russel
 * @version 25-May-1998
 * @version Aug 2005 Identity removed
 */
public interface DataLocatorList {
    /**
     * Adds a DataLocator to the implementing object's list
     *
     * @param theLocator the DataLocator to be added
     */
    public void attachDataLocator(DataLocator theLocator);

    /**
     * Removes a DataLocator from the implementing object's list
     *
     * @param theLocator theDataLocator to be removed
     */
    public void detachDataLocator(DataLocator theLocator);

    /**
     * Gives the DataLocator that is associated with a given Identity from the
     * implementing object's list, if such a DataLocator exists. Some
     * implementations may implement this method as a Factory method, meaning
     * that a DataLocator is created for an Identity, if it does not yet
     * exist.
     *
     * @return the DataLocator
     */
    public DataLocator getDataLocator();
}
