/*
 * File:     ProcessReport.java
 * Project:  MPI Linguistic Application
 * Date:     25 August 2009
 *
 * Copyright (C) 2001-2009  Max Planck Institute for Psycholinguistics
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */

package mpi.eudico.server.corpora.util;


/**
 * An interface for a process report. Will contain messages generated by the
 * process.
 *
 * @author Han Sloetjes
 * @version 1.0, Nov 2008
 */
public interface ProcessReport {
    /**
     * Returns the contents of the report (all messages) as a String.
     *
     * @return the report as a String
     */
    public String getReportAsString();

    /**
     * Appends a message to the report.
     *
     * @param message the message
     */
    public void append(String message);

    /**
     * Clears the messages that have been added.
     */
    public void clearReport();

    /**
     * Sets the name of the report.
     *
     * @param name the name
     */
    public void setName(String name);

    /**
     * Returns the name.
     *
     * @return the name
     */
    public String getName();
}
