/*
 * File:     ProcessReporter.java
 * Project:  MPI Linguistic Application
 * Date:     25 August 2009
 *
 * Copyright (C) 2001-2009  Max Planck Institute for Psycholinguistics
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */

package mpi.eudico.server.corpora.util;


/**
 * Interface for a process reporting. For the time being supports one report to
 * report to.
 *
 * @author Han Sloetjes
 * @version 1.0, Nov 2008
 */
public interface ProcessReporter {
    /**
     * Sets the report object to append report messages to.
     *
     * @param report the report object
     */
    public void setProcessReport(ProcessReport report);

    /**
     * Returns the report object, containing the report messages.
     *
     * @return the report, or null if no report was set
     */
    public ProcessReport getProcessReport();

    /**
     * Adds a message to the report.
     *
     * @param message the message
     */
    public void report(String message);
}
