/*
 * File:     SimpleReport.java
 * Project:  MPI Linguistic Application
 * Date:     25 August 2009
 *
 * Copyright (C) 2001-2009  Max Planck Institute for Psycholinguistics
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */

package mpi.eudico.server.corpora.util;


/**
 * A report that stores the messages in a StringBuffer, without performing any
 * formatting itself.
 *
 * @author Han Sloetjes
 * @version 1.0
 */
public class SimpleReport implements ProcessReport {
    private StringBuffer buffer;
    private String name;

    /**
     * Creates a new SimpleReport instance
     */
    public SimpleReport() {
        super();
        buffer = new StringBuffer();
    }

    /**
     * Creates a new SimpleReport instance
     *
     * @param name the name of the report
     */
    public SimpleReport(String name) {
        this();
        this.name = name;
    }

    /**
     * Appends the message followed by a newline character.
     *
     * @param message the report message
     */
    public void append(String message) {
        if (message != null) {
            buffer.append(message);
            buffer.append('\n');
        }
    }

    /**
     * Clears the messages from the buffer.
     */
    public void clearReport() {
        buffer.delete(0, buffer.length());
    }

    /**
     * Returns the name.
     *
     * @return the name
     */
    public String getName() {
        return ((name == null) ? "" : name);
    }

    /**
     * Returns the report as a single string.
     *
     * @return the report as a string
     */
    public String getReportAsString() {
        return buffer.toString();
    }

    /**
     * Sets the name.
     *
     * @param name the name
     */
    public void setName(String name) {
        this.name = name;
    }
}
