/*
 * File:     TimeComparator.java
 * Project:  MPI Linguistic Application
 * Date:     25 August 2009
 *
 * Copyright (C) 2001-2009  Max Planck Institute for Psycholinguistics
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */

package mpi.eudico.util;

import java.util.Comparator;

import javax.media.Time;


/**
 * Class to compare JMF Time objects. With the help of this Comparator it is
 * easy to build an ordered set of Times that belong to Tag/Tuple begin and
 * end times. This ordered set can be used to make the Time[] for the
 * TimeLineController.
 */
public class TimeComparator implements Comparator {
    /**
     * Two times are equal if they differ less than one millisecond
     *
     * @see java.util.Comparator#compare(Object, Object)
     */
    public int compare(Object obj1, Object obj2) {
        return (int) ((1000 * ((Time) obj1).getSeconds()) -
        (1000 * ((Time) obj2).getSeconds()));
    }

    /**
     * DOCUMENT ME!
     *
     * @param obj DOCUMENT ME!
     *
     * @return DOCUMENT ME!
     */
    public boolean equals(Object obj) {
        return false;
    }
}
