/*
 * File:     RestrictedAnchorConstraint.java
 * Project:  MPI Linguistic Application
 * Date:     25 August 2009
 *
 * Copyright (C) 2001-2009  Max Planck Institute for Psycholinguistics
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */

package mpi.search.content.query.model;

import mpi.search.content.result.model.ContentResult;


/**
 * Created on Oct 7, 2004
 * @author Alexander Klassmann
 * @version Oct 7, 2004
 */
public class RestrictedAnchorConstraint extends AnchorConstraint {
    /** Holds value of property DOCUMENT ME! */
    final private ContentResult result;

    /** Holds value of property DOCUMENT ME! */
    final private String comment;

    /**
     * Creates a new RestrictedAnchorConstraint instance
     *
     * @param result DOCUMENT ME!
     * @param comment DOCUMENT ME!
     */
    public RestrictedAnchorConstraint(ContentResult result, String comment) {
        super(result.getTierNames());
        this.result = result;
        this.comment = comment;
    }

    /**
     * DOCUMENT ME!
     *
     * @param o DOCUMENT ME!
     *
     * @return DOCUMENT ME!
     */
    public boolean equals(Object o) {
        return (o instanceof RestrictedAnchorConstraint) ? super.equals(o) : false;
    }

    /**
     * DOCUMENT ME!
     *
     * @return DOCUMENT ME!
     */
    public ContentResult getResult() {
        return result;
    }

    /**
     * DOCUMENT ME!
     *
     * @return DOCUMENT ME!
     */
    public boolean isEditable() {
        return false;
    }

    /**
     * DOCUMENT ME!
     *
     * @return DOCUMENT ME!
     */
    public String getComment() {
        return comment;
    }
}
