/*
 * File:     AnchorConstraintPanel.java
 * Project:  MPI Linguistic Application
 * Date:     25 August 2009
 *
 * Copyright (C) 2001-2009  Max Planck Institute for Psycholinguistics
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */

package mpi.search.content.query.viewer;

import mpi.search.SearchLocale;

import mpi.search.content.model.CorpusType;

import mpi.search.content.query.model.AnchorConstraint;
import mpi.search.content.query.model.Constraint;

import java.awt.Graphics;

import javax.swing.Action;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.border.EmptyBorder;
import javax.swing.tree.DefaultTreeModel;


/**
 * $Id: AnchorConstraintPanel.java 7355 2006-11-28 11:36:23Z klasal $
 *
 * $Author$
 */
public class AnchorConstraintPanel extends AbstractConstraintPanel {
    /** Holds value of property DOCUMENT ME! */
    final private JLabel lockedConstraintLabel = new JLabel();
    private String lockedTierName = null;
    private String lockedPattern = null;

    /**
     * Creates a new AnchorConstraintPanel instance
     *
     * @param constraint DOCUMENT ME!
     * @param treeModel DOCUMENT ME!
     * @param type DOCUMENT ME!
     * @param startAction DOCUMENT ME!
     */
    public AnchorConstraintPanel(AnchorConstraint constraint,
        DefaultTreeModel treeModel, CorpusType type, Action startAction) {
        super(constraint, treeModel, type, startAction);

        // 'head line' of constraint
        titleComponent.add(new JLabel(SearchLocale.getString(
                    "Search.Query.Find").toUpperCase()));
        titleComponent.setBorder(new EmptyBorder(0, 0, 5, 0));

        tierComboBox = new JComboBox(type.getTierNames()) {
                    public void paint(Graphics g) {
                        super.paint(g);
                        tierComboBoxWidth = this.getPreferredSize().width;
                    }
                };

        if (type.allowsSearchOverMultipleTiers() &&
                (type.getTierNames().length > 1)) {
            tierComboBox.insertItemAt(Constraint.ALL_TIERS, 0);
        }

        lockedConstraintLabel.setHorizontalAlignment(JLabel.CENTER);
        framedPanel.add(lockedConstraintLabel, "locked");

        makeLayout();
        setConstraint(constraint);
    }

    /**
     * DOCUMENT ME!
     *
     * @param tierName DOCUMENT ME!
     */
    protected void setTierName(String tierName) {
        for (int i = 0; i < type.getIndexTierNames().length; i++) {
            if (type.getIndexTierNames()[i].equals(tierName.toUpperCase())) {
                lockedTierName = tierName.toUpperCase();
                framedPanelLayout.show(framedPanel, "locked");

                return;
            }
        }

        //if lockedField was set, reset.
        if (lockedTierName != null) {
            lockedTierName = null;
            lockedPattern = null;
            framedPanelLayout.show(framedPanel, "");
        }

        super.setTierName(tierName);
    }

    /**
     * DOCUMENT ME!
     *
     * @param tierNames DOCUMENT ME!
     */
    protected void setTierNames(String[] tierNames) {
        if (tierNames.length > 0) {
            setTierName(tierNames[0]);
        } else {
            tierComboBox.setSelectedIndex(0);
        }
    }

    /**
     * DOCUMENT ME!
     *
     * @return DOCUMENT ME!
     */
    public String getTierName() {
        return (lockedTierName == null) ? super.getTierName() : lockedTierName;
    }

    /**
     * DOCUMENT ME!
     *
     * @param pattern DOCUMENT ME!
     */
    protected void setPattern(String pattern) {
        if (lockedTierName != null) {
            lockedPattern = pattern;
            lockedConstraintLabel.setText(type.getUnabbreviatedTierName(
                    lockedTierName) + " " + lockedPattern);
        } else {
            super.setPattern(pattern);
        }
    }

    /**
     * DOCUMENT ME!
     *
     * @return DOCUMENT ME!
     */
    protected String getPattern() {
        return (lockedPattern == null) ? super.getPattern() : lockedPattern;
    }

    /**
     * DOCUMENT ME!
     *
     * @param c DOCUMENT ME!
     */
    public void setConstraint(AnchorConstraint c) {
        setTierNames(c.getTierNames());
        super.setConstraint(c);
    }
}
