/*
 * File:     DependentTemporalDistancePanel.java
 * Project:  MPI Linguistic Application
 * Date:     25 August 2009
 *
 * Copyright (C) 2001-2009  Max Planck Institute for Psycholinguistics
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */

package mpi.search.content.query.viewer;

import mpi.search.SearchLocale;

import mpi.search.content.query.model.Constraint;

import java.awt.CardLayout;
import java.awt.Font;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;

import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;


/**
 * $Id: DependentTemporalDistancePanel.java 8004 2007-01-30 15:36:46Z klasal $
 *
 * $Author$ $Version$
 */
public class DependentTemporalDistancePanel extends TemporalDistancePanel
    implements ItemListener {
    /** Holds value of property DOCUMENT ME! */
    private final CardLayout distanceLayout = new CardLayout();

    /** Holds value of property DOCUMENT ME! */
    private final JPanel distancePanel = new JPanel(distanceLayout);

    /**
     * Creates a new DependentTemporalDistancePanel object.
     */
    public DependentTemporalDistancePanel() {
        timeRelationComboBox = new JComboBox(Constraint.DEPENDENT_CONSTRAINT_TIME_RELATIONS);
        timeRelationComboBox.setRenderer(new LocalizeListCellRenderer());

        distancePanel.add(toTimeField, "interval width");
        distancePanel.add(new JLabel(""), "nothing");

        JLabel label = new JLabel(SearchLocale.getString("Search.And") + " ");
        label.setFont(getFont().deriveFont(Font.PLAIN));
        add(label);
        add(timeRelationComboBox);
        add(new JLabel(" "));
        add(distancePanel);
        timeRelationComboBox.addItemListener(this);
        timeRelationComboBox.setSelectedIndex(0);
        updateDistancePanel();
    }

    /**
     *
     *
     * @param e DOCUMENT ME!
     */
    public void itemStateChanged(ItemEvent e) {
        if (e.getStateChange() == ItemEvent.SELECTED) {
            updateDistancePanel();
        }
    }

    /**
     * sets input field of seconds+milliseconds visible/invisible
     *
     */
    private void updateDistancePanel() {
        Object selectedItem = timeRelationComboBox.getSelectedItem();

        if (Constraint.WITHIN_OVERALL_DISTANCE.equals(selectedItem) ||
                Constraint.WITHIN_DISTANCE_TO_LEFT_BOUNDARY.equals(selectedItem) ||
                Constraint.WITHIN_DISTANCE_TO_RIGHT_BOUNDARY.equals(
                    selectedItem) ||
                Constraint.BEFORE_LEFT_DISTANCE.equals(selectedItem) ||
                Constraint.AFTER_RIGHT_DISTANCE.equals(selectedItem)) {
            distanceLayout.show(distancePanel, "interval width");
        } else {
            distanceLayout.show(distancePanel, "nothing");
        }
    }
}
