/*
 * File:     StructuralDistancePanel.java
 * Project:  MPI Linguistic Application
 * Date:     25 August 2009
 *
 * Copyright (C) 2001-2009  Max Planck Institute for Psycholinguistics
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */

package mpi.search.content.query.viewer;

import mpi.search.SearchLocale;

import mpi.util.gui.XNumericalJTextFieldFilter;

import java.awt.Dimension;
import java.awt.Font;

import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JTextField;
import javax.swing.ListCellRenderer;


/**
 * $Id: StructuralDistancePanel.java 8004 2007-01-30 15:36:46Z klasal $
 *
 * $Author$
 *
 */
public class StructuralDistancePanel extends AbstractDistancePanel {
    private static int unitComboBoxWidth = 160;

    /** Holds value of property DOCUMENT ME! */
    protected final JComboBox unitComboBox;

    /** Holds value of property DOCUMENT ME! */
    private final JTextField fromTextField = new JTextField(new XNumericalJTextFieldFilter(
                XNumericalJTextFieldFilter.INTEGER_WITH_NEG_INFINITY), "0", 3);

    /** Holds value of property DOCUMENT ME! */
    private final JTextField toTextField = new JTextField(new XNumericalJTextFieldFilter(
                XNumericalJTextFieldFilter.INTEGER_WITH_POS_INFINITY), "0", 3);

    /**
     * Creates a new StructuralDistancePanel object.
     */
    public StructuralDistancePanel() {
        fromTextField.setHorizontalAlignment(JTextField.CENTER);
        toTextField.setHorizontalAlignment(JTextField.CENTER);

        unitComboBox = new JComboBox() {
                    public Dimension getPreferredSize() {
                        return new Dimension(unitComboBoxWidth,
                            super.getPreferredSize().height);
                    }
                };

        JLabel label = new JLabel(SearchLocale.getString(
                    "Search.Constraint.Distance") + " ");
        label.setFont(getFont().deriveFont(Font.PLAIN));
        add(label);
        add(fromTextField);
        label = new JLabel(" " + SearchLocale.getString("Search.To") + " ");
        label.setFont(getFont().deriveFont(Font.PLAIN));
        add(label);
        add(toTextField);
        add(new JLabel(" "));
        add(unitComboBox);
    }

    /**
     * DOCUMENT ME!
     *
     * @param l DOCUMENT ME!
     */
    public void setLowerBoundary(long l) {
        fromTextField.setText(getString(l));
    }

    /**
     * DOCUMENT ME!
     *
     * @return DOCUMENT ME!
     */
    public long getLowerBoundary() {
        return fromTextField.getText().trim().equals("") ? Long.MIN_VALUE
                                                         : getLong(fromTextField.getText());
    }

    /**
     *
     *
     * @param s DOCUMENT ME!
     */
    public void setUnit(String s) {
        unitComboBox.setSelectedItem(s);
    }

    /**
     *
     *
     * @return DOCUMENT ME!
     */
    public String getUnit() {
        return (unitComboBox.getSelectedIndex() != -1)
        ? (String) unitComboBox.getSelectedItem() : "";
    }

    /**
     *
     *
     * @return DOCUMENT ME!
     */
    public JComboBox getUnitComboBox() {
        return unitComboBox;
    }

    /**
     *
     *
     * @param renderer DOCUMENT ME!
     */
    public void setUnitComboBoxRenderer(ListCellRenderer renderer) {
        unitComboBox.setRenderer(renderer);
    }

    /**
     * DOCUMENT ME!
     *
     * @param l DOCUMENT ME!
     */
    public void setUpperBoundary(long l) {
        toTextField.setText(getString(l));
    }

    /**
     * DOCUMENT ME!
     *
     * @return DOCUMENT ME!
     */
    public long getUpperBoundary() {
        return toTextField.getText().trim().equals("") ? Long.MAX_VALUE
                                                       : getLong(toTextField.getText());
    }
}
