/*
 * File:     Xml2Query.java
 * Project:  MPI Linguistic Application
 * Date:     25 August 2009
 *
 * Copyright (C) 2001-2009  Max Planck Institute for Psycholinguistics
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */

package mpi.search.content.query.xml;

import mpi.search.content.query.model.ContentQuery;

import mpi.util.OurURL;

import org.apache.xerces.parsers.SAXParser;

import org.xml.sax.InputSource;
import org.xml.sax.XMLReader;

import java.net.MalformedURLException;


/**
 * Evokes parser to read matches from xml-file
 * Created on Sep 30, 2004
 * @author Alexander Klassmann
 * @version Sep 30, 2004
 */
public class Xml2Query {
    private static XMLReader parser;

    /**
     * DOCUMENT ME!
     *
     * @param file DOCUMENT ME!
     * @param query DOCUMENT ME!
     *
     * @throws Exception DOCUMENT ME!
     */
    public static void translate(String file, ContentQuery query)
        throws Exception {
        OurURL url = null;

        try {
            url = new OurURL("file:\\" + file);
        } catch (MalformedURLException e1) {
        }

        if (url != null) {
            translate(url, query);
        }
    }

    /**
     * DOCUMENT ME!
     *
     * @param url DOCUMENT ME!
     * @param query DOCUMENT ME!
     *
     * @throws Exception DOCUMENT ME!
     */
    public static void translate(OurURL url, ContentQuery query)
        throws Exception {
        if (parser == null) {
            parser = new SAXParser();
        }

        parser.setContentHandler(new QueryContentHandler(query));
        parser.parse(new InputSource(url.openStream()));
    }
}
