/*
 * File:     AbstractSearchPanel.java
 * Project:  MPI Linguistic Application
 * Date:     25 August 2009
 *
 * Copyright (C) 2001-2009  Max Planck Institute for Psycholinguistics
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */

package mpi.search.query.viewer;

import mpi.search.model.SearchController;
import mpi.search.model.SearchListener;

import mpi.search.query.model.Query;

import mpi.search.result.viewer.MatchCounter;
import mpi.search.result.viewer.ResultViewer;

import mpi.search.viewer.ProgressViewer;

import javax.swing.JPanel;


/**
 * Created on Apr 14, 2005 $Id: AbstractSearchPanel.java,v 1.5 2005/11/01
 * 16:07:16 klasal Exp $ $Author$ $Version$
 */
public abstract class AbstractSearchPanel extends JPanel
    implements SearchListener {
    /** progress viewer */
    protected final ProgressViewer progressViewer;

    /** show current number of result and amount of matches */
    protected MatchCounter matchCounter;

    /** Holds value of property DOCUMENT ME! */
    protected ResultViewer resultViewer;

    /** search engine */
    protected SearchController searchEngine;

    /**
     * Creates a new AbstractSearchPanel object.
     */
    public AbstractSearchPanel() {
        progressViewer = new ProgressViewer();
        matchCounter = new MatchCounter();
    }

    /**
     *
     */
    public void executionStarted() {
        matchCounter.setVisible(true);
        progressViewer.setVisible(true);
    }

    /**
     *
     */
    public void stopSearch() {
        if (searchEngine != null) {
            searchEngine.stopExecution();
        }
    }

    /**
     * DOCUMENT ME!
     *
     * @return DOCUMENT ME!
     */
    protected abstract Query getQuery();

    /**
     * DOCUMENT ME!
     */
    protected void startSearch() {
        if (searchEngine.getResult() != null) {
            searchEngine.getResult().removeListeners();
        }

        Query query = getQuery();

        if (query != null) {
            query.getResult().reset();

            query.getResult().addResultChangeListener(matchCounter);
            query.getResult().addResultChangeListener(resultViewer);

            searchEngine.execute(query);
        }
    }
}
