/*
 * File:     MatchComparator.java
 * Project:  MPI Linguistic Application
 * Date:     25 August 2009
 *
 * Copyright (C) 2001-2009  Max Planck Institute for Psycholinguistics
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */

package mpi.search.result.model;

import java.util.Comparator;


/**
 * $Id: MatchComparator.java 10187 2007-09-18 10:59:37Z klasal $
 */
public class MatchComparator implements Comparator {
    /**
     *
     *
     * @param o1 first match
     * @param o2 second match
     *
     * @return comparison of values
     */
    public int compare(Object o1, Object o2) {
        if (!(o1 instanceof Match) || !(o2 instanceof Match)) {
            return 0;
        }

        return (((Match) o1).getValue().compareTo(((Match) o2).getValue()));
    }
}
