/*
 * File:     ProgressViewer.java
 * Project:  MPI Linguistic Application
 * Date:     25 August 2009
 *
 * Copyright (C) 2001-2009  Max Planck Institute for Psycholinguistics
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */

package mpi.search.viewer;

import mpi.search.SearchLocale;

import mpi.search.model.ProgressListener;

import mpi.search.result.model.Result;

import java.awt.Color;
import java.awt.Dimension;

import javax.swing.JProgressBar;
import javax.swing.border.LineBorder;


/**
 * Created on Sep 23, 2004
 *
 * @author Alexander Klassmann
 * @version December, 2004
 */
public class ProgressViewer extends JProgressBar implements ProgressListener {
    /** label for status interrupted */
    private static final String INTERRUPTED = "Search.Interrupted";

    /** label for status complete */
    private static final String COMPLETE = "Search.Complete";

    /** label for status modified */
    private static final String MODIFIED = "Search.Modified";

    /**
     * Creates a new ProgressViewer instance
     */
    public ProgressViewer() {
        setBorder(new LineBorder(Color.lightGray));
        setStringPainted(true);
        setProgress(0);
        setVisible(false);
    }

    /**
     * DOCUMENT ME!
     *
     * @param procent DOCUMENT ME!
     */
    public void setProgress(int procent) {
        setVisible(true);
        setValue(procent);

        if (procent == 0) {
            setString(" "); // empty string results in height change
        } else {
            setString((procent < 100) ? (procent + "%")
                                      : SearchLocale.getString(COMPLETE));
        }
    }

    /**
     * DOCUMENT ME!
     *
     * @param status DOCUMENT ME!
     */
    public void setStatus(int status) {
        setVisible(true);

        switch (status) {
        case Result.COMPLETE:
            setValue(100);
            setString(SearchLocale.getString(COMPLETE));

            break;

        case Result.INTERRUPTED:
            setValue(0);
            setString(SearchLocale.getString(INTERRUPTED));

            break;

        case Result.MODIFIED:
            setValue(0);
            setString(SearchLocale.getString(MODIFIED));
        }
    }

    // don't let shrink
    public Dimension getMinimumSize() {
        return getPreferredSize();
    }
}
