/*
 * File:     DefaultFileFilter.java
 * Project:  MPI Linguistic Application
 * Date:     25 August 2009
 *
 * Copyright (C) 2001-2009  Max Planck Institute for Psycholinguistics
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */

/* This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */
package mpi.util;

import java.io.File;

import javax.swing.filechooser.FileFilter;


/**
 * Default implementation of AbstractClass FileFilter It shows directories and files with specified
 * extension
 *
 * @author Alexander Klassmann
 * @version september 2003
 */
public class DefaultFileFilter extends FileFilter {
    /** Holds value of property DOCUMENT ME! */
    private final String description;

    /** Holds value of property DOCUMENT ME! */
    private final String[] extensions;

    /**
     * DOCUMENT ME!
     *
     * @param extension to be shown
     */
    public DefaultFileFilter(String extension) {
        this(extension, "*." + extension);
    }

    /**
     * DOCUMENT ME!
     *
     * @param extensions
     */
    public DefaultFileFilter(String[] extensions) {
        this.extensions = extensions;

        StringBuffer d = new StringBuffer("*." + extensions[0]);

        for (int i = 1; i < extensions.length; i++) {
            d.append(", *." + extensions[i]);
        }

        this.description = d.toString();
    }

    /**
     * DOCUMENT ME!
     *
     * @param extension
     * @param description
     */
    public DefaultFileFilter(String extension, String description) {
        this.extensions = new String[] { extension };
        this.description = description;
    }

    /**
     * DOCUMENT ME!
     *
     * @param extensions
     * @param description
     */
    public DefaultFileFilter(String[] extensions, String description) {
        this.extensions = extensions;
        this.description = description;
    }

    /**
     * DOCUMENT ME!
     *
     * @return DOCUMENT ME!
     */
    public String getDescription() {
        return description;
    }

    /**
     * DOCUMENT ME!
     *
     * @param f DOCUMENT ME!
     *
     * @return DOCUMENT ME!
     */
    public boolean accept(File f) {
        if (f.isDirectory()) {
            return true;
        }

        String name = f.getName().toLowerCase();

        for (int i = 0; i < extensions.length; i++) {
            if (name.endsWith(extensions[i])) {
                return true;
            }
        }

        return false;
    }
}
