/*
 * File:     FontTable.java
 * Project:  MPI Linguistic Application
 * Date:     25 August 2009
 *
 * Copyright (C) 2001-2009  Max Planck Institute for Psycholinguistics
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */

package mpi.util.FontBrowser;

import java.awt.Font;

import java.io.BufferedReader;
import java.io.InputStreamReader;

import java.util.StringTokenizer;
import java.util.Vector;

import javax.swing.JFrame;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableColumn;


/**
 * A table showing all characters of a certain unicode block in a certain font.
 *
 * $Id: FontTable.java 10194 2007-09-18 14:34:04Z hasloe $
 * @author $Author$
 * @version $Revision$
 */
class FontTable extends JFrame {
    /** Holds value of property DOCUMENT ME! */
    int _start;

    /** Holds value of property DOCUMENT ME! */
    int _end;

    /** Holds value of property DOCUMENT ME! */
    String _codepgname;

    /** Holds value of property DOCUMENT ME! */
    Font _font;

    /** Holds value of property DOCUMENT ME! */
    DefaultTableModel _dataModel = null;

    /** Holds value of property DOCUMENT ME! */
    JTable table = null;

    /**
     * Creates a new FontTable instance
     *
     * @param start DOCUMENT ME!
     * @param end DOCUMENT ME!
     * @param name DOCUMENT ME!
     * @param font DOCUMENT ME!
     */
    public FontTable(int start, int end, String name, Font font) {
        super("Font Browser for Codepage:" + name);
        reload(start, end, name, font);
        setSize(500, 700);
    }

    /**
     * DOCUMENT ME!
     *
     * @param start DOCUMENT ME!
     * @param end DOCUMENT ME!
     * @param name DOCUMENT ME!
     * @param font DOCUMENT ME!
     */
    public void reload(int start, int end, String name, Font font) {
        setTitle("Font Browser for Codepage:" + name);
        _start = start;
        _end = end;
        _codepgname = name;
        _font = font;

        getContentPane().removeAll();

        Object[][] data = {
            { " ", " ", " " }
        };
        String[] columnNames = { "Font", "Unicode Hex", "Display Name" };
        _dataModel = null;
        _dataModel = new DefaultTableModel(data, columnNames);
        table = new JTable(_dataModel);

        JScrollPane scrollpane = new JScrollPane(table);
        TableColumn column = null;
        table.setRowHeight(20);
        loadTable();
        column = table.getColumnModel().getColumn(0);
        column.setMaxWidth(50);
        column.sizeWidthToFit();
        column = table.getColumnModel().getColumn(1);
        column.setMaxWidth(65);
        column.sizeWidthToFit();
        column = table.getColumnModel().getColumn(2);

        //column.setMaxWidth(420);
        column.sizeWidthToFit();

        table.setFont(_font);
        getContentPane().add(scrollpane);
        getContentPane().validate();

        //setSize(500, 700);
    }

    private void loadTable() {
        int ct = 0;
        BufferedReader cdTable = null;

        try {
            cdTable = new BufferedReader(new InputStreamReader(
                        FontGui.class.getResourceAsStream(
                            "resources/UnicodeData.txt")));

            String s;

            while ((s = cdTable.readLine()) != null) {
                StringTokenizer st = new StringTokenizer(s, ";");
                String tmpe = st.nextToken();
                int uni = Integer.parseInt(tmpe, 16);
                String desc = st.nextToken();

                if ((uni >= _start) && (uni <= _end)) {
                    Vector v = new Vector();

                    Character c = new Character((char) uni);
                    v.add(c.toString());
                    v.add(Integer.toHexString(uni));
                    v.add(desc);
                    _dataModel.addRow(v);
                }
            }
        } catch (Exception ee) {
            ee.printStackTrace();

            return;
        }
    }

    /**
     * DOCUMENT ME!
     *
     * @param f DOCUMENT ME!
     */
    public void setFont(Font f) {
        table.setFont(f);
    }

    /**
     * DOCUMENT ME!
     *
     * @param args DOCUMENT ME!
     */
    public static void main(String[] args) {
        Font f = new Font("Aria", 0, 20);
        char a = 0x123;
        char b = 0xffd;
        FontTable fb = new FontTable(a, b, "Arial Unicode", f);
        fb.setVisible(true);
    }
}
