/*
 * File:     Xml2TreeHandler.java
 * Project:  MPI Linguistic Application
 * Date:     25 August 2009
 *
 * Copyright (C) 2001-2009  Max Planck Institute for Psycholinguistics
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */

package mpi.util;

import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;

import javax.swing.tree.DefaultMutableTreeNode;


/**
 * parses xml file and constructs tree of found xml elements  $Id: Xml2TreeHandler.java 8277 2007-02-28 10:26:41Z klasal $
 */
public class Xml2TreeHandler implements ContentHandler {
    private DefaultMutableTreeNode currentNode;
    private DefaultMutableTreeNode root;
    private String currentContent;

    /**
     * Creates a new Xml2TreeHandler object.
     *
     * @param root DOCUMENT ME!
     */
    public Xml2TreeHandler(DefaultMutableTreeNode root) {
        this.root = root;
    }

    /**
     * DOCUMENT ME!
     *
     * @param locator
     */
    public void setDocumentLocator(Locator locator) {
    }

    /**
     *
     *
     * @param ch DOCUMENT ME!
     * @param start DOCUMENT ME!
     * @param end DOCUMENT ME!
     *
     * @throws SAXException DOCUMENT ME!
     */
    public void characters(char[] ch, int start, int end)
        throws SAXException {
        currentContent += new String(ch, start, end);
    }

    /**
     * DOCUMENT ME!
     *
     * @exception SAXException
     */
    public void endDocument() throws SAXException {
        System.out.println("End parsing query file.");
    }

    /**
     * DOCUMENT ME!
     *
     * @param namespaceURI
     * @param elementName
     * @param rawName
     *
     * @exception SAXException
     */
    public void endElement(String namespaceURI, String elementName,
        String rawName) throws SAXException {
        currentNode = (DefaultMutableTreeNode) currentNode.getParent();
    }

    /**
     * DOCUMENT ME!
     *
     * @param param1
     *
     * @exception SAXException
     */
    public void endPrefixMapping(String param1) throws SAXException {
    }

    /**
     * DOCUMENT ME!
     *
     * @param param1
     * @param param2
     * @param param3
     *
     * @exception SAXException
     */
    public void ignorableWhitespace(char[] param1, int param2, int param3)
        throws SAXException {
    }

    /**
     * DOCUMENT ME!
     *
     * @param param1
     * @param param2
     *
     * @exception SAXException
     */
    public void processingInstruction(String param1, String param2)
        throws SAXException {
    }

    /**
     * DOCUMENT ME!
     *
     * @param param1
     *
     * @exception SAXException
     */
    public void skippedEntity(String param1) throws SAXException {
    }

    /**
     * DOCUMENT ME!
     *
     * @exception SAXException
     */
    public void startDocument() throws SAXException {
        System.out.println("Start parsing query file.");
        currentNode = root;
    }

    /**
     * DOCUMENT ME!
     *
     * @param namespaceURI
     * @param elementName
     * @param rawName
     * @param atts
     *
     * @exception SAXException
     */
    public void startElement(String namespaceURI, String elementName,
        String rawName, Attributes atts) throws SAXException {
        DefaultMutableTreeNode node = new DefaultMutableTreeNode(elementName);
        currentNode.add(node);
        currentNode = node;
    }

    /**
     * DOCUMENT ME!
     *
     * @param param1
     * @param param2
     *
     * @exception SAXException
     */
    public void startPrefixMapping(String param1, String param2)
        throws SAXException {
    }
}
