/*
 * File:     SimpleHtmlViewer.java
 * Project:  MPI Linguistic Application
 * Date:     25 August 2009
 *
 * Copyright (C) 2001-2009  Max Planck Institute for Psycholinguistics
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */

package mpi.util.gui;

import java.io.IOException;

import java.net.URL;

import javax.swing.JDialog;
import javax.swing.JEditorPane;
import javax.swing.JFrame;
import javax.swing.JScrollPane;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;


/**
 * Created on Apr 8, 2004
 * @author Alexander Klassmann
 * @version July, 2004
 */
public class SimpleHtmlViewer extends JDialog {
    /**
     * Creates a new SimpleHtmlViewer instance
     *
     * @param frame DOCUMENT ME!
     * @param title DOCUMENT ME!
     * @param modal DOCUMENT ME!
     * @param urlString DOCUMENT ME!
     */
    public SimpleHtmlViewer(JFrame frame, String title, boolean modal,
        String urlString) {
        super(frame, title, modal);

        try {
            final URL url = SimpleHtmlViewer.class.getResource(urlString);
            final JEditorPane htmlPane = new JEditorPane(url);
            htmlPane.setEditable(false);

            JScrollPane scrollPane = new JScrollPane(htmlPane);
            getContentPane().add(scrollPane);

            htmlPane.addHyperlinkListener(new HyperlinkListener() {
                    public void hyperlinkUpdate(HyperlinkEvent e) {
                        if (e.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
                            //only care if link is to same document
                            if (e.getURL().sameFile(url)) {
                                try {
                                    htmlPane.scrollToReference(e.getURL()
                                                                .getRef());
                                } catch (Throwable t) {
                                    t.printStackTrace();
                                }
                            }
                        }
                    }
                });
        } catch (IOException e) {
        }
    }
}
