/*
 * Decompiled with CFR 0.152.
 */
package com.jniwrapper.win32.shell.events;

import com.jniwrapper.win32.shell.ShellFolder;
import com.jniwrapper.win32.shell.events.MediaListener;
import com.jniwrapper.win32.shell.events.ShellEvent;
import com.jniwrapper.win32.shell.events.ShellEventsListener;
import com.jniwrapper.win32.shell.events.ShellEventsSubscriber;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

public class MediaEventsSubscriber
extends ShellEventsSubscriber
implements ShellEventsListener {
    private List _mediaListeners = Collections.synchronizedList(new LinkedList());

    public MediaEventsSubscriber() {
        this.addShellEventsListener(this);
    }

    public void addMediaListener(MediaListener listener) {
        this._mediaListeners.add(listener);
    }

    public void removeMediaListener(MediaListener listener) {
        this._mediaListeners.remove(listener);
    }

    public void processEvent(ShellEvent event) {
        int id = event.getId();
        switch (id) {
            case 32: 
            case 64: {
                String path = ShellFolder.getPathFromIDList(event.getItem1());
                Iterator iterator = this._mediaListeners.iterator();
                while (iterator.hasNext()) {
                    MediaListener mediaListener = (MediaListener)iterator.next();
                    if (id == 64) {
                        mediaListener.mediaRemoved(path);
                        continue;
                    }
                    mediaListener.mediaInserted(path);
                }
                break;
            }
        }
    }
}

