/*
 * Decompiled with CFR 0.152.
 */
package com.jniwrapper.win32.system.eventlog;

import com.jniwrapper.util.EnumItem;
import java.util.Date;

public class EventLogMessage {
    private int _recordNumber;
    private long _eventID = 0L;
    private Type _eventType;
    private int _category = 0;
    private Date _date;
    private byte[] _data;
    private String _source;
    private String _user;
    private String _computer;
    private String _message;

    EventLogMessage() {
    }

    public EventLogMessage(String sourceName) {
        if (sourceName == null) {
            throw new IllegalArgumentException("Illegal message source.");
        }
        this._source = sourceName;
    }

    public void setEventID(long eventID) {
        if (eventID < 0L) {
            throw new IllegalArgumentException("Event ID must be positive.");
        }
        this._eventID = eventID;
    }

    public void setEventType(Type eventType) {
        this._eventType = eventType;
    }

    public void setCategory(int category) {
        if (category < 0) {
            throw new IllegalArgumentException("Category argument must be positive.");
        }
        this._category = category;
    }

    void setDate(Date date) {
        this._date = date;
    }

    public void setData(byte[] data) {
        this._data = data;
    }

    public void setSource(String source) {
        this._source = source;
    }

    void setUser(String user) {
        this._user = user;
    }

    void setComputer(String computer) {
        this._computer = computer;
    }

    public void setMessage(String message) {
        this._message = message;
    }

    void setRecordNumber(int recordNumber) {
        this._recordNumber = recordNumber;
    }

    public long getEventID() {
        return this._eventID;
    }

    public Type getEventType() {
        return this._eventType;
    }

    public int getCategory() {
        return this._category;
    }

    public Date getDate() {
        return this._date;
    }

    public byte[] getData() {
        return this._data;
    }

    public String getSource() {
        return this._source;
    }

    public String getUser() {
        return this._user;
    }

    public String getComputer() {
        return this._computer;
    }

    public String getMessage() {
        return this._message;
    }

    public int getRecordNumber() {
        return this._recordNumber;
    }

    public static class Type
    extends EnumItem {
        private String _name;
        public static final Type SUCCESS = new Type(0);
        public static final Type ERROR = new Type(1);
        public static final Type WARNING = new Type(2);
        public static final Type INFORMATION = new Type(4);
        public static final Type AUDIT_SUCCESS = new Type(8);
        public static final Type AUDIT_FAILURE = new Type(16);

        Type(int value) {
            super(value);
            switch (value) {
                case 0: {
                    this._name = "Success";
                    break;
                }
                case 1: {
                    this._name = "Error";
                    break;
                }
                case 2: {
                    this._name = "Warning";
                    break;
                }
                case 4: {
                    this._name = "Information";
                    break;
                }
                case 8: {
                    this._name = "Success Audit";
                    break;
                }
                case 16: {
                    this._name = "Failure Audit";
                }
            }
        }

        public String toString() {
            return this._name;
        }
    }
}

