/*
 * Decompiled with CFR 0.152.
 */
package com.jniwrapper.win32.winhttp;

import com.jniwrapper.Function;
import com.jniwrapper.IntBool;
import com.jniwrapper.Parameter;
import com.jniwrapper.Pointer;
import com.jniwrapper.win32.winhttp.DefaultProxySettings;
import com.jniwrapper.win32.winhttp.IEProxyConfig;
import com.jniwrapper.win32.winhttp.ProxySettings;
import com.jniwrapper.win32.winhttp.WinHttpException;
import com.jniwrapper.win32.winhttp.WinHttpLibrary;

public class IEProxySettings
implements ProxySettings {
    private static final String FUNCTION_GET_IE_PROXY_CONFIGURATION = "WinHttpGetIEProxyConfigForCurrentUser";
    private boolean _isAutoDetect;
    private String _proxyURL;
    private int _proxyPort;
    private String _proxyBypass;
    private String _autoConfigURL;

    public IEProxySettings() throws WinHttpException {
        Function function = WinHttpLibrary.getInstance().getFunction(FUNCTION_GET_IE_PROXY_CONFIGURATION);
        IEProxyConfig ieProxyInfo = new IEProxyConfig();
        IntBool result = new IntBool();
        long errorCode = function.invoke((Parameter)result, (Parameter)new Pointer((Parameter)ieProxyInfo));
        if (result.getValue() == 0L) {
            throw new WinHttpException(errorCode);
        }
        this._isAutoDetect = ieProxyInfo.isAutoDetect();
        this._autoConfigURL = ieProxyInfo.getAutoConfigUrl();
        this._proxyBypass = ieProxyInfo.getProxyBypass();
        String proxy = ieProxyInfo.getProxy();
        int portOffset = proxy.lastIndexOf(58);
        String port = proxy.substring(portOffset + 1, proxy.length());
        try {
            this._proxyPort = new Integer(port);
            this._proxyURL = proxy.substring(0, portOffset);
        }
        catch (NumberFormatException e) {
            this._proxyPort = -1;
            this._proxyURL = proxy;
        }
    }

    public boolean isAutoDetect() {
        return this._isAutoDetect;
    }

    public String getAutoConfigURL() {
        return this._autoConfigURL;
    }

    public boolean isSet() {
        return this._proxyPort != -1;
    }

    public int getPort() {
        return this._proxyPort;
    }

    public String getURL() {
        return this._proxyURL;
    }

    public String[] getProxyBypass() {
        return DefaultProxySettings.parseBypasses(this._proxyBypass);
    }
}

