/*
 * Decompiled with CFR 0.152.
 */
package codecLib.mpa;

import codecLib.mpa.Constants;
import codecLib.mpa.Tables;

class PolySynthesis
implements Tables,
Constants {
    protected float[][][] delay_line = new float[12][2][272];
    protected int[] delay_mode = new int[12];
    static final float[] t_sectab;
    static final float[] t_polysyn_window;

    public int kernel32(float[] fArray, int n2, int n3) {
        float f2;
        float f3;
        float f4;
        float f5;
        int n4;
        float f6;
        int n5 = this.delay_mode[n3];
        this.delay_mode[n3] = n5 + 15 & 0xF;
        float[] fArray2 = this.delay_line[n3][n5 & 1];
        float[] fArray3 = this.delay_line[n3][1 ^ n5 & 1];
        int n6 = n5 - (n5 & 1) & 0xF;
        int n7 = n5 - (1 ^ n5 & 1) & 0xF;
        PolySynthesis.fft32(fArray3, n7, fArray2, n6, fArray, n2);
        int n8 = n6;
        int n9 = n6 + 14 & 0xF;
        int n10 = 1;
        while (n10 < 16) {
            f6 = 0.0f;
            float f7 = 0.0f;
            n4 = 0;
            while (n4 < 4) {
                f5 = fArray2[n10 * 16 + n8];
                f4 = fArray2[n10 * 16 + n8 + 1];
                float f8 = fArray2[n10 * 16 + n9];
                float f9 = fArray2[n10 * 16 + n9 + 1];
                f3 = t_polysyn_window[n4 * 2 + n10 * 16];
                f2 = t_polysyn_window[1 + n4 * 2 + n10 * 16];
                float f10 = t_polysyn_window[14 - n4 * 2 + n10 * 16];
                float f11 = t_polysyn_window[15 - n4 * 2 + n10 * 16];
                n8 += 2;
                n8 &= 0xF;
                n9 += 14;
                n9 &= 0xF;
                f6 += f5 * f3;
                f6 -= f4 * f2;
                f7 += f5 * f11;
                f7 += f4 * f10;
                f6 += f8 * f10;
                f6 -= f9 * f11;
                f7 += f8 * f2;
                f7 += f9 * f3;
                ++n4;
            }
            n8 ^= 8;
            n9 ^= 8;
            fArray[n2 + n10] = f6;
            fArray[n2 + 32 - n10] = f7;
            ++n10;
        }
        f6 = 0.0f;
        n4 = 0;
        while (n4 < 8) {
            f5 = fArray2[n8];
            f4 = fArray2[n8 + 1];
            f3 = t_polysyn_window[2 * n4];
            f2 = t_polysyn_window[2 * n4 + 1];
            n8 += 2;
            n8 &= 0xF;
            f6 += f5 * f3 - f4 * f2;
            ++n4;
        }
        fArray[n2] = f6;
        f6 = 0.0f;
        n4 = 0;
        while (n4 < 4) {
            f3 = t_polysyn_window[2 * n4 + 256];
            f2 = t_polysyn_window[2 * n4 + 1 + 256];
            f5 = fArray2[257 + n8];
            n8 += 2;
            f4 = fArray2[257 + (n8 &= 0xF)];
            n8 += 2;
            n8 &= 0xF;
            f6 -= f5 * f3;
            f6 -= f4 * f2;
            ++n4;
        }
        fArray[n2 + 16] = f6;
        return 0;
    }

    public int kernel16(float[] fArray, int n2, int n3) {
        float f2;
        float f3;
        float f4;
        float f5;
        int n4;
        float f6;
        int n5 = this.delay_mode[n3];
        this.delay_mode[n3] = n5 + 15 & 0xF;
        float[] fArray2 = this.delay_line[n3][n5 & 1];
        float[] fArray3 = this.delay_line[n3][1 ^ n5 & 1];
        int n6 = n5 - (n5 & 1) & 0xF;
        int n7 = n5 - (1 ^ n5 & 1) & 0xF;
        PolySynthesis.fft16(fArray3, n7, fArray2, n6, fArray, n2);
        int n8 = n6;
        int n9 = n6 + 14 & 0xF;
        int n10 = 1;
        while (n10 < 8) {
            f6 = 0.0f;
            float f7 = 0.0f;
            n4 = 0;
            while (n4 < 4) {
                f5 = fArray2[n10 * 32 + n8];
                f4 = fArray2[n10 * 32 + n8 + 1];
                float f8 = fArray2[n10 * 32 + n9];
                float f9 = fArray2[n10 * 32 + n9 + 1];
                f3 = t_polysyn_window[n4 * 2 + n10 * 32];
                f2 = t_polysyn_window[1 + n4 * 2 + n10 * 32];
                float f10 = t_polysyn_window[14 - n4 * 2 + n10 * 32];
                float f11 = t_polysyn_window[15 - n4 * 2 + n10 * 32];
                n8 += 2;
                n8 &= 0xF;
                n9 += 14;
                n9 &= 0xF;
                f6 += f5 * f3;
                f6 -= f4 * f2;
                f7 += f5 * f11;
                f7 += f4 * f10;
                f6 += f8 * f10;
                f6 -= f9 * f11;
                f7 += f8 * f2;
                f7 += f9 * f3;
                ++n4;
            }
            n8 ^= 8;
            n9 ^= 8;
            fArray[n2 + n10] = f6;
            fArray[n2 + 16 - n10] = f7;
            ++n10;
        }
        f6 = 0.0f;
        n4 = 0;
        while (n4 < 8) {
            f5 = fArray2[n8];
            f4 = fArray2[n8 + 1];
            f3 = t_polysyn_window[2 * n4];
            f2 = t_polysyn_window[2 * n4 + 1];
            n8 += 2;
            n8 &= 0xF;
            f6 += f5 * f3 - f4 * f2;
            ++n4;
        }
        fArray[n2] = f6;
        f6 = 0.0f;
        n4 = 0;
        while (n4 < 4) {
            f3 = t_polysyn_window[2 * n4 + 256];
            f2 = t_polysyn_window[2 * n4 + 1 + 256];
            f5 = fArray2[257 + n8];
            n8 += 2;
            f4 = fArray2[257 + (n8 &= 0xF)];
            n8 += 2;
            n8 &= 0xF;
            f6 -= f5 * f3;
            f6 -= f4 * f2;
            ++n4;
        }
        fArray[n2 + 8] = f6;
        return 0;
    }

    public int kernel8(float[] fArray, int n2, int n3) {
        float f2;
        float f3;
        float f4;
        float f5;
        int n4;
        float f6;
        int n5 = this.delay_mode[n3];
        this.delay_mode[n3] = n5 + 15 & 0xF;
        float[] fArray2 = this.delay_line[n3][n5 & 1];
        float[] fArray3 = this.delay_line[n3][1 ^ n5 & 1];
        int n6 = n5 - (n5 & 1) & 0xF;
        int n7 = n5 - (1 ^ n5 & 1) & 0xF;
        PolySynthesis.fft8(fArray3, n7, fArray2, n6, fArray, n2);
        int n8 = n6;
        int n9 = n6 + 14 & 0xF;
        int n10 = 1;
        while (n10 < 4) {
            f6 = 0.0f;
            float f7 = 0.0f;
            n4 = 0;
            while (n4 < 4) {
                f5 = fArray2[n10 * 64 + n8];
                f4 = fArray2[n10 * 64 + n8 + 1];
                float f8 = fArray2[n10 * 64 + n9];
                float f9 = fArray2[n10 * 64 + n9 + 1];
                f3 = t_polysyn_window[n4 * 2 + n10 * 64];
                f2 = t_polysyn_window[1 + n4 * 2 + n10 * 64];
                float f10 = t_polysyn_window[14 - n4 * 2 + n10 * 64];
                float f11 = t_polysyn_window[15 - n4 * 2 + n10 * 64];
                n8 += 2;
                n8 &= 0xF;
                n9 += 14;
                n9 &= 0xF;
                f6 += f5 * f3;
                f6 -= f4 * f2;
                f7 += f5 * f11;
                f7 += f4 * f10;
                f6 += f8 * f10;
                f6 -= f9 * f11;
                f7 += f8 * f2;
                f7 += f9 * f3;
                ++n4;
            }
            n8 ^= 8;
            n9 ^= 8;
            fArray[n2 + n10] = f6;
            fArray[n2 + 8 - n10] = f7;
            ++n10;
        }
        f6 = 0.0f;
        n4 = 0;
        while (n4 < 8) {
            f5 = fArray2[n8];
            f4 = fArray2[n8 + 1];
            f3 = t_polysyn_window[2 * n4];
            f2 = t_polysyn_window[2 * n4 + 1];
            n8 += 2;
            n8 &= 0xF;
            f6 += f5 * f3 - f4 * f2;
            ++n4;
        }
        fArray[n2] = f6;
        f6 = 0.0f;
        n4 = 0;
        while (n4 < 4) {
            f3 = t_polysyn_window[2 * n4 + 256];
            f2 = t_polysyn_window[2 * n4 + 1 + 256];
            f5 = fArray2[257 + n8];
            n8 += 2;
            f4 = fArray2[257 + (n8 &= 0xF)];
            n8 += 2;
            n8 &= 0xF;
            f6 -= f5 * f3;
            f6 -= f4 * f2;
            ++n4;
        }
        fArray[n2 + 4] = f6;
        return 0;
    }

    private static int fft32(float[] fArray, int n2, float[] fArray2, int n3, float[] fArray3, int n4) {
        float f2 = fArray3[n4] + fArray3[n4 + 31];
        float f3 = fArray3[n4 + 1] + fArray3[n4 + 30];
        float f4 = (fArray3[n4 + 30] - fArray3[n4 + 1]) * t_sectab[17];
        float f5 = (fArray3[n4 + 31] - fArray3[n4]) * t_sectab[16];
        float f6 = fArray3[n4 + 14] + fArray3[n4 + 17];
        float f7 = fArray3[n4 + 15] + fArray3[n4 + 16];
        float f8 = (fArray3[n4 + 16] - fArray3[n4 + 15]) * t_sectab[31];
        float f9 = (fArray3[n4 + 17] - fArray3[n4 + 14]) * t_sectab[30];
        float f10 = f2 - f7;
        float f11 = f3 - f6;
        f2 += f7;
        f7 = f10 * t_sectab[8];
        f3 += f6;
        f6 = f11 * t_sectab[9];
        float f12 = fArray3[n4 + 6] + fArray3[n4 + 25];
        float f13 = fArray3[n4 + 7] + fArray3[n4 + 24];
        float f14 = (fArray3[n4 + 24] - fArray3[n4 + 7]) * t_sectab[23];
        float f15 = (fArray3[n4 + 25] - fArray3[n4 + 6]) * t_sectab[22];
        float f16 = fArray3[n4 + 8] + fArray3[n4 + 23];
        float f17 = fArray3[n4 + 9] + fArray3[n4 + 22];
        float f18 = (fArray3[n4 + 22] - fArray3[n4 + 9]) * t_sectab[25];
        float f19 = (fArray3[n4 + 23] - fArray3[n4 + 8]) * t_sectab[24];
        f10 = f12 - f17;
        f11 = f13 - f16;
        f12 += f17;
        f17 = f10 * t_sectab[14];
        f13 += f16;
        f16 = f11 * t_sectab[15];
        f10 = f2 - f13;
        f11 = f3 - f12;
        f2 += f13;
        f13 = f10 * t_sectab[4];
        f3 += f12;
        f12 = f11 * t_sectab[5];
        float f20 = fArray3[n4 + 2] + fArray3[n4 + 29];
        float f21 = fArray3[n4 + 3] + fArray3[n4 + 28];
        float f22 = (fArray3[n4 + 28] - fArray3[n4 + 3]) * t_sectab[19];
        float f23 = (fArray3[n4 + 29] - fArray3[n4 + 2]) * t_sectab[18];
        float f24 = fArray3[n4 + 12] + fArray3[n4 + 19];
        float f25 = fArray3[n4 + 13] + fArray3[n4 + 18];
        float f26 = (fArray3[n4 + 18] - fArray3[n4 + 13]) * t_sectab[29];
        float f27 = (fArray3[n4 + 19] - fArray3[n4 + 12]) * t_sectab[28];
        f10 = f20 - f25;
        f11 = f21 - f24;
        f20 += f25;
        f25 = f10 * t_sectab[10];
        f21 += f24;
        f24 = f11 * t_sectab[11];
        float f28 = fArray3[n4 + 4] + fArray3[n4 + 27];
        float f29 = fArray3[n4 + 5] + fArray3[n4 + 26];
        float f30 = (fArray3[n4 + 26] - fArray3[n4 + 5]) * t_sectab[21];
        float f31 = (fArray3[n4 + 27] - fArray3[n4 + 4]) * t_sectab[20];
        float f32 = fArray3[n4 + 10] + fArray3[n4 + 21];
        float f33 = fArray3[n4 + 11] + fArray3[n4 + 20];
        float f34 = (fArray3[n4 + 20] - fArray3[n4 + 11]) * t_sectab[27];
        float f35 = (fArray3[n4 + 21] - fArray3[n4 + 10]) * t_sectab[26];
        f10 = f28 - f33;
        f11 = f29 - f32;
        f28 += f33;
        f33 = f10 * t_sectab[12];
        f29 += f32;
        f32 = f11 * t_sectab[13];
        f10 = f20 - f29;
        f11 = f21 - f28;
        f20 += f29;
        f29 = f10 * t_sectab[6];
        f21 += f28;
        f28 = f11 * t_sectab[7];
        f10 = f2 - f21;
        f11 = f3 - f20;
        f2 += f21;
        f21 = f10 * t_sectab[2];
        f3 += f20;
        f20 = f11 * t_sectab[3];
        f10 = f2 - f3;
        f11 = f21 - f20;
        f2 += f3;
        f3 = f10 * t_sectab[1];
        f20 += f21;
        f21 = f11 * t_sectab[1];
        fArray[n2] = f3;
        fArray[n2 + 256] = f2;
        fArray[n2 + 128] = f20 += f21;
        fArray2[n3] = f3;
        fArray2[n3 + 128] = f21;
        f10 = f13 - f28;
        f11 = f12 - f29;
        f28 += f13;
        f13 = f10 * t_sectab[2];
        f29 += f12;
        f12 = f11 * t_sectab[3];
        f10 = f28 - f29;
        f11 = f13 - f12;
        f28 += f29;
        f29 = f10 * t_sectab[1];
        f12 += f13;
        f13 = f11 * t_sectab[1];
        f12 += f29;
        fArray[n2 + 64] = f12;
        fArray[n2 + 192] = f28 += (f12 += f13);
        fArray2[n3 + 64] = f29 += f13;
        fArray2[n3 + 192] = f13;
        f10 = f7 - f16;
        f11 = f6 - f17;
        f16 += f7;
        f7 = f10 * t_sectab[4];
        f17 += f6;
        f6 = f11 * t_sectab[5];
        f10 = f25 - f32;
        f11 = f24 - f33;
        f32 += f25;
        f25 = f10 * t_sectab[6];
        f33 += f24;
        f24 = f11 * t_sectab[7];
        f10 = f16 - f33;
        f11 = f17 - f32;
        f16 += f33;
        f33 = f10 * t_sectab[2];
        f17 += f32;
        f32 = f11 * t_sectab[3];
        f10 = f16 - f17;
        f11 = f33 - f32;
        f16 += f17;
        f17 = f10 * t_sectab[1];
        f32 += f33;
        f33 = f11 * t_sectab[1];
        f32 += f33;
        f10 = f7 - f24;
        f11 = f6 - f25;
        f24 += f7;
        f7 = f10 * t_sectab[2];
        f25 += f6;
        f6 = f11 * t_sectab[3];
        f10 = f24 - f25;
        f11 = f7 - f6;
        f24 += f25;
        f25 = f10 * t_sectab[1];
        f6 += f7;
        f7 = f11 * t_sectab[1];
        f6 += f25;
        fArray[n2 + 32] = f6 + f17;
        fArray[n2 + 96] = f32 + f6;
        fArray[n2 + 160] = (f24 += (f6 += f7)) + f32;
        fArray[n2 + 224] = f16 + f24;
        fArray2[n3 + 32] = f17 + (f25 += f7);
        fArray2[n3 + 96] = f25 + f33;
        fArray2[n3 + 160] = f33 + f7;
        fArray2[n3 + 224] = f7;
        f2 = f8 + f5;
        f3 = f9 + f4;
        f6 = f4 - f9;
        f7 = f5 - f8;
        f6 *= t_sectab[9];
        f7 *= t_sectab[8];
        f12 = f18 + f15;
        f13 = f19 + f14;
        f16 = f14 - f19;
        f17 = f15 - f18;
        f16 *= t_sectab[15];
        f17 *= t_sectab[14];
        f10 = f2 - f13;
        f11 = f3 - f12;
        f2 += f13;
        f13 = f10 * t_sectab[4];
        f3 += f12;
        f12 = f11 * t_sectab[5];
        f20 = f26 + f23;
        f21 = f27 + f22;
        f24 = f22 - f27;
        f25 = f23 - f26;
        f24 *= t_sectab[11];
        f25 *= t_sectab[10];
        f28 = f34 + f31;
        f29 = f35 + f30;
        f32 = f30 - f35;
        f33 = f31 - f34;
        f32 *= t_sectab[13];
        f33 *= t_sectab[12];
        f10 = f20 - f29;
        f11 = f21 - f28;
        f20 += f29;
        f29 = f10 * t_sectab[6];
        f21 += f28;
        f28 = f11 * t_sectab[7];
        f10 = f2 - f21;
        f11 = f3 - f20;
        f2 += f21;
        f21 = f10 * t_sectab[2];
        f3 += f20;
        f20 = f11 * t_sectab[3];
        f10 = f2 - f3;
        f11 = f21 - f20;
        f2 += f3;
        f3 = f10 * t_sectab[1];
        f20 += f21;
        f21 = f11 * t_sectab[1];
        f20 += f21;
        f10 = f13 - f28;
        f11 = f12 - f29;
        f28 += f13;
        f13 = f10 * t_sectab[2];
        f29 += f12;
        f12 = f11 * t_sectab[3];
        f10 = f28 - f29;
        f11 = f13 - f12;
        f28 += f29;
        f29 = f10 * t_sectab[1];
        f12 += f13;
        f13 = f11 * t_sectab[1];
        f28 += (f12 += f13);
        f12 += f29;
        f29 += f13;
        f10 = f7 - f16;
        f11 = f6 - f17;
        f16 += f7;
        f7 = f10 * t_sectab[4];
        f17 += f6;
        f6 = f11 * t_sectab[5];
        f10 = f25 - f32;
        f11 = f24 - f33;
        f32 += f25;
        f25 = f10 * t_sectab[6];
        f33 += f24;
        f24 = f11 * t_sectab[7];
        f10 = f16 - f33;
        f11 = f17 - f32;
        f16 += f33;
        f33 = f10 * t_sectab[2];
        f17 += f32;
        f32 = f11 * t_sectab[3];
        f10 = f16 - f17;
        f11 = f33 - f32;
        f16 += f17;
        f17 = f10 * t_sectab[1];
        f32 += f33;
        f33 = f11 * t_sectab[1];
        f32 += f33;
        f10 = f7 - f24;
        f11 = f6 - f25;
        f24 += f7;
        f7 = f10 * t_sectab[2];
        f25 += f6;
        f6 = f11 * t_sectab[3];
        f10 = f24 - f25;
        f11 = f7 - f6;
        f24 += f25;
        f25 = f10 * t_sectab[1];
        f6 += f7;
        f7 = f11 * t_sectab[1];
        f24 += (f6 += f7);
        f6 += f25;
        f25 += f7;
        fArray[n2 + 16] = f3 + f6 + f17;
        fArray[n2 + 48] = f12 + f6 + f17;
        fArray[n2 + 80] = f12 + f32 + f6;
        fArray[n2 + 112] = f20 + f32 + f6;
        fArray[n2 + 144] = f20 + f24 + f32;
        fArray[n2 + 176] = f28 + f24 + f32;
        fArray[n2 + 208] = f28 + f16 + f24;
        fArray[n2 + 240] = f2 + f16 + f24;
        fArray2[n3 + 16] = f3 + f17 + f25;
        fArray2[n3 + 48] = f29 + f17 + f25;
        fArray2[n3 + 80] = f29 + f25 + f33;
        fArray2[n3 + 112] = f21 + f25 + f33;
        fArray2[n3 + 144] = f21 + f33 + f7;
        fArray2[n3 + 176] = f13 + f33 + f7;
        fArray2[n3 + 208] = f13 + f7;
        fArray2[n3 + 240] = f7;
        return 0;
    }

    private static int fft16(float[] fArray, int n2, float[] fArray2, int n3, float[] fArray3, int n4) {
        float f2 = fArray3[n4] + fArray3[n4 + 1 + 14];
        float f3 = fArray3[n4 + 1] + fArray3[n4 + 14];
        float f4 = (fArray3[n4 + 1] - fArray3[n4 + 14]) * t_sectab[9];
        float f5 = (fArray3[n4] - fArray3[n4 + 1 + 14]) * t_sectab[8];
        float f6 = fArray3[n4 + 2] + fArray3[n4 + 1 + 12];
        float f7 = fArray3[n4 + 1 + 2] + fArray3[n4 + 12];
        float f8 = (fArray3[n4 + 1 + 2] - fArray3[n4 + 12]) * t_sectab[11];
        float f9 = (fArray3[n4 + 2] - fArray3[n4 + 1 + 12]) * t_sectab[10];
        float f10 = fArray3[n4 + 4] + fArray3[n4 + 1 + 10];
        float f11 = fArray3[n4 + 1 + 4] + fArray3[n4 + 10];
        float f12 = (fArray3[n4 + 1 + 4] - fArray3[n4 + 10]) * t_sectab[13];
        float f13 = (fArray3[n4 + 4] - fArray3[n4 + 1 + 10]) * t_sectab[12];
        float f14 = fArray3[n4 + 6] + fArray3[n4 + 1 + 8];
        float f15 = fArray3[n4 + 1 + 6] + fArray3[n4 + 8];
        float f16 = (fArray3[n4 + 1 + 6] - fArray3[n4 + 8]) * t_sectab[15];
        float f17 = (fArray3[n4 + 6] - fArray3[n4 + 1 + 8]) * t_sectab[14];
        float f18 = f2 - f15;
        float f19 = f3 - f14;
        f2 += f15;
        f15 = f18 * t_sectab[4];
        f3 += f14;
        f14 = f19 * t_sectab[5];
        f18 = f6 - f11;
        f19 = f7 - f10;
        f6 += f11;
        f11 = f18 * t_sectab[6];
        f7 += f10;
        f10 = f19 * t_sectab[7];
        f18 = f2 - f7;
        f19 = f3 - f6;
        f2 += f7;
        f7 = f18 * t_sectab[2];
        f3 += f6;
        f6 = f19 * t_sectab[3];
        f18 = f15 - f10;
        f19 = f14 - f11;
        f10 += f15;
        f15 = f18 * t_sectab[2];
        f11 += f14;
        f14 = f19 * t_sectab[3];
        f18 = f2 - f3;
        f19 = f7 - f6;
        f2 += f3;
        f3 = f18 * t_sectab[1];
        f6 += f7;
        f7 = f19 * t_sectab[1];
        fArray[n2] = f3;
        fArray[n2 + 256] = f2;
        fArray[n2 + 128] = f6 += f7;
        fArray2[n3] = f3;
        fArray2[n3 + 128] = f7;
        f18 = f10 - f11;
        f19 = f15 - f14;
        f10 += f11;
        f11 = f18 * t_sectab[1];
        f14 += f15;
        f15 = f19 * t_sectab[1];
        f14 += f11;
        fArray[n2 + 64] = f14;
        fArray[n2 + 192] = f10 += (f14 += f15);
        fArray2[n3 + 64] = f11 += f15;
        fArray2[n3 + 192] = f15;
        f18 = f5 - f16;
        f19 = f4 - f17;
        f16 += f5;
        f5 = f18 * t_sectab[4];
        f17 += f4;
        f4 = f19 * t_sectab[5];
        f18 = f9 - f12;
        f19 = f8 - f13;
        f12 += f9;
        f9 = f18 * t_sectab[6];
        f13 += f8;
        f8 = f19 * t_sectab[7];
        f18 = f16 - f13;
        f19 = f17 - f12;
        f16 += f13;
        f13 = f18 * t_sectab[2];
        f17 += f12;
        f12 = f19 * t_sectab[3];
        f18 = f5 - f8;
        f19 = f4 - f9;
        f8 += f5;
        f5 = f18 * t_sectab[2];
        f9 += f4;
        f4 = f19 * t_sectab[3];
        f18 = f16 - f17;
        f19 = f13 - f12;
        f16 += f17;
        f17 = f18 * t_sectab[1];
        f12 += f13;
        f13 = f19 * t_sectab[1];
        f12 += f13;
        f18 = f8 - f9;
        f19 = f5 - f4;
        f8 += f9;
        f9 = f18 * t_sectab[1];
        f4 += f5;
        f5 = f19 * t_sectab[1];
        f4 += f9;
        fArray[n2 + 32] = f4 + f17;
        fArray[n2 + 96] = f12 + f4;
        fArray[n2 + 160] = (f8 += (f4 += f5)) + f12;
        fArray[n2 + 224] = f16 + f8;
        fArray2[n3 + 32] = f17 + (f9 += f5);
        fArray2[n3 + 96] = f9 + f13;
        fArray2[n3 + 160] = f13 + f5;
        fArray2[n3 + 224] = f5;
        return 0;
    }

    private static int fft8(float[] fArray, int n2, float[] fArray2, int n3, float[] fArray3, int n4) {
        float f2 = fArray3[n4] + fArray3[n4 + 1 + 6];
        float f3 = fArray3[n4 + 1] + fArray3[n4 + 6];
        float f4 = (fArray3[n4 + 1] - fArray3[n4 + 6]) * t_sectab[5];
        float f5 = (fArray3[n4] - fArray3[n4 + 1 + 6]) * t_sectab[4];
        float f6 = fArray3[n4 + 2] + fArray3[n4 + 1 + 4];
        float f7 = fArray3[n4 + 1 + 2] + fArray3[n4 + 4];
        float f8 = (fArray3[n4 + 1 + 2] - fArray3[n4 + 4]) * t_sectab[7];
        float f9 = (fArray3[n4 + 2] - fArray3[n4 + 1 + 4]) * t_sectab[6];
        float f10 = f2 - f7;
        float f11 = f3 - f6;
        f2 += f7;
        f7 = f10 * t_sectab[2];
        f3 += f6;
        f6 = f11 * t_sectab[3];
        f10 = f5 - f8;
        f11 = f4 - f9;
        f8 += f5;
        f5 = f10 * t_sectab[2];
        f9 += f4;
        f4 = f11 * t_sectab[3];
        f10 = f2 - f3;
        f11 = f7 - f6;
        f2 += f3;
        f3 = f10 * t_sectab[1];
        f6 += f7;
        f7 = f11 * t_sectab[1];
        fArray[n2] = f3;
        fArray[n2 + 256] = f2;
        fArray[n2 + 128] = f6 += f7;
        fArray2[n3] = f3;
        fArray2[n3 + 128] = f7;
        f10 = f8 - f9;
        f11 = f5 - f4;
        f8 += f9;
        f9 = f10 * t_sectab[1];
        f4 += f5;
        f5 = f11 * t_sectab[1];
        f4 += f9;
        fArray[n2 + 64] = f4;
        fArray[n2 + 192] = f8 += (f4 += f5);
        fArray2[n3 + 64] = f9 += f5;
        fArray2[n3 + 192] = f5;
        return 0;
    }

    static {
        float[] fArray = new float[32];
        fArray[1] = 0.7071068f;
        fArray[2] = 0.5411961f;
        fArray[3] = 1.306563f;
        fArray[4] = 0.5097956f;
        fArray[5] = 0.6013449f;
        fArray[6] = 0.8999762f;
        fArray[7] = 2.5629156f;
        fArray[8] = 0.5024193f;
        fArray[9] = 0.5224986f;
        fArray[10] = 0.5669441f;
        fArray[11] = 0.6468218f;
        fArray[12] = 0.7881546f;
        fArray[13] = 1.0606776f;
        fArray[14] = 1.7224472f;
        fArray[15] = 5.1011486f;
        fArray[16] = -0.500603f;
        fArray[17] = -0.5054709f;
        fArray[18] = -0.5154473f;
        fArray[19] = -0.5310426f;
        fArray[20] = -0.5531039f;
        fArray[21] = -0.582935f;
        fArray[22] = -0.6225041f;
        fArray[23] = -0.6748083f;
        fArray[24] = -0.7445363f;
        fArray[25] = -0.8393496f;
        fArray[26] = -0.9725682f;
        fArray[27] = -1.1694399f;
        fArray[28] = -1.4841646f;
        fArray[29] = -2.057781f;
        fArray[30] = -3.4076085f;
        fArray[31] = -10.190008f;
        t_sectab = fArray;
        float[] fArray2 = new float[264];
        fArray2[1] = -4.425E-4f;
        fArray2[2] = 0.00325012f;
        fArray2[3] = -0.00700378f;
        fArray2[4] = 0.03108215f;
        fArray2[5] = -0.07862854f;
        fArray2[6] = 0.10031128f;
        fArray2[7] = -0.57203674f;
        fArray2[8] = 1.144989f;
        fArray2[9] = 0.57203674f;
        fArray2[10] = 0.10031128f;
        fArray2[11] = 0.07862854f;
        fArray2[12] = 0.03108215f;
        fArray2[13] = 0.00700378f;
        fArray2[14] = 0.00325012f;
        fArray2[15] = 4.425E-4f;
        fArray2[16] = -1.526E-5f;
        fArray2[17] = -4.7302E-4f;
        fArray2[18] = 0.00332642f;
        fArray2[19] = -0.00791931f;
        fArray2[20] = 0.03051758f;
        fArray2[21] = -0.08418274f;
        fArray2[22] = 0.09092712f;
        fArray2[23] = -0.6002197f;
        fArray2[24] = 1.1442871f;
        fArray2[25] = 0.54382324f;
        fArray2[26] = 0.1088562f;
        fArray2[27] = 0.07305908f;
        fArray2[28] = 0.03147888f;
        fArray2[29] = 0.00611877f;
        fArray2[30] = 0.00317383f;
        fArray2[31] = 3.9673E-4f;
        fArray2[32] = -1.526E-5f;
        fArray2[33] = -5.3406E-4f;
        fArray2[34] = 0.00338745f;
        fArray2[35] = -0.00886536f;
        fArray2[36] = 0.02978516f;
        fArray2[37] = -0.08970642f;
        fArray2[38] = 0.08068848f;
        fArray2[39] = -0.6282959f;
        fArray2[40] = 1.1422119f;
        fArray2[41] = 0.51560974f;
        fArray2[42] = 0.11657715f;
        fArray2[43] = 0.06752014f;
        fArray2[44] = 0.03173828f;
        fArray2[45] = 0.0052948f;
        fArray2[46] = 0.00308228f;
        fArray2[47] = 3.6621E-4f;
        fArray2[48] = -1.526E-5f;
        fArray2[49] = -5.7983E-4f;
        fArray2[50] = 0.00343323f;
        fArray2[51] = -0.00984192f;
        fArray2[52] = 0.02888489f;
        fArray2[53] = -0.09516907f;
        fArray2[54] = 0.06959534f;
        fArray2[55] = -0.6562195f;
        fArray2[56] = 1.1387634f;
        fArray2[57] = 0.48747253f;
        fArray2[58] = 0.12347412f;
        fArray2[59] = 0.06199646f;
        fArray2[60] = 0.03184509f;
        fArray2[61] = 0.00448608f;
        fArray2[62] = 0.00299072f;
        fArray2[63] = 3.2043E-4f;
        fArray2[64] = -1.526E-5f;
        fArray2[65] = -6.2561E-4f;
        fArray2[66] = 0.00346374f;
        fArray2[67] = -0.010849f;
        fArray2[68] = 0.02780151f;
        fArray2[69] = -0.10054016f;
        fArray2[70] = 0.05761719f;
        fArray2[71] = -0.6839142f;
        fArray2[72] = 1.1339264f;
        fArray2[73] = 0.45947266f;
        fArray2[74] = 0.12957764f;
        fArray2[75] = 0.05653381f;
        fArray2[76] = 0.03181457f;
        fArray2[77] = 0.00372315f;
        fArray2[78] = 0.00289917f;
        fArray2[79] = 2.8992E-4f;
        fArray2[80] = -1.526E-5f;
        fArray2[81] = -6.8665E-4f;
        fArray2[82] = 0.003479f;
        fArray2[83] = -0.0118866f;
        fArray2[84] = 0.02653503f;
        fArray2[85] = -0.1058197f;
        fArray2[86] = 0.04478455f;
        fArray2[87] = -0.71131897f;
        fArray2[88] = 1.1277466f;
        fArray2[89] = 0.43165588f;
        fArray2[90] = 0.1348877f;
        fArray2[91] = 0.0511322f;
        fArray2[92] = 0.03166199f;
        fArray2[93] = 0.00300598f;
        fArray2[94] = 0.00279236f;
        fArray2[95] = 2.594E-4f;
        fArray2[96] = -1.526E-5f;
        fArray2[97] = -7.4768E-4f;
        fArray2[98] = 0.003479f;
        fArray2[99] = -0.01293945f;
        fArray2[100] = 0.02508545f;
        fArray2[101] = -0.11094666f;
        fArray2[102] = 0.03108215f;
        fArray2[103] = -0.7383728f;
        fArray2[104] = 1.120224f;
        fArray2[105] = 0.40408325f;
        fArray2[106] = 0.13945007f;
        fArray2[107] = 0.0458374f;
        fArray2[108] = 0.03138733f;
        fArray2[109] = 0.0023346f;
        fArray2[110] = 0.00268555f;
        fArray2[111] = 2.4414E-4f;
        fArray2[112] = -3.052E-5f;
        fArray2[113] = -8.0872E-4f;
        fArray2[114] = 0.00346374f;
        fArray2[115] = -0.01402283f;
        fArray2[116] = 0.02342224f;
        fArray2[117] = -0.11592102f;
        fArray2[118] = 0.01651001f;
        fArray2[119] = -0.7650299f;
        fArray2[120] = 1.1113739f;
        fArray2[121] = 0.37680054f;
        fArray2[122] = 0.14326477f;
        fArray2[123] = 0.04063415f;
        fArray2[124] = 0.03100586f;
        fArray2[125] = 0.00169373f;
        fArray2[126] = 0.00257873f;
        fArray2[127] = 2.1362E-4f;
        fArray2[128] = -3.052E-5f;
        fArray2[129] = -8.8501E-4f;
        fArray2[130] = 0.00341797f;
        fArray2[131] = -0.01512146f;
        fArray2[132] = 0.02157593f;
        fArray2[133] = -0.12069702f;
        fArray2[134] = 0.00106811f;
        fArray2[135] = -0.791214f;
        fArray2[136] = 1.1012115f;
        fArray2[137] = 0.34986877f;
        fArray2[138] = 0.1463623f;
        fArray2[139] = 0.03555298f;
        fArray2[140] = 0.03053284f;
        fArray2[141] = 0.00109863f;
        fArray2[142] = 0.00245666f;
        fArray2[143] = 1.9836E-4f;
        fArray2[144] = -3.052E-5f;
        fArray2[145] = -9.613E-4f;
        fArray2[146] = 0.00337219f;
        fArray2[147] = -0.01623535f;
        fArray2[148] = 0.01953125f;
        fArray2[149] = -0.1252594f;
        fArray2[150] = -0.01522827f;
        fArray2[151] = -0.816864f;
        fArray2[152] = 1.0897827f;
        fArray2[153] = 0.32331848f;
        fArray2[154] = 0.1487732f;
        fArray2[155] = 0.03060913f;
        fArray2[156] = 0.02993774f;
        fArray2[157] = 5.4932E-4f;
        fArray2[158] = 0.00234985f;
        fArray2[159] = 1.6785E-4f;
        fArray2[160] = -3.052E-5f;
        fArray2[161] = -0.0010376f;
        fArray2[162] = 0.00328064f;
        fArray2[163] = -0.01734924f;
        fArray2[164] = 0.01725769f;
        fArray2[165] = -0.12956238f;
        fArray2[166] = -0.03237915f;
        fArray2[167] = -0.84194946f;
        fArray2[168] = 1.0771179f;
        fArray2[169] = 0.2972107f;
        fArray2[170] = 0.15049744f;
        fArray2[171] = 0.02581787f;
        fArray2[172] = 0.02928162f;
        fArray2[173] = 3.052E-5f;
        fArray2[174] = 0.00224304f;
        fArray2[175] = 1.5259E-4f;
        fArray2[176] = -4.578E-5f;
        fArray2[177] = -0.00111389f;
        fArray2[178] = 0.00317383f;
        fArray2[179] = -0.01846313f;
        fArray2[180] = 0.01480103f;
        fArray2[181] = -0.1335907f;
        fArray2[182] = -0.050354f;
        fArray2[183] = -0.8663635f;
        fArray2[184] = 1.0632172f;
        fArray2[185] = 0.2715912f;
        fArray2[186] = 0.15159607f;
        fArray2[187] = 0.0211792f;
        fArray2[188] = 0.02853394f;
        fArray2[189] = -4.425E-4f;
        fArray2[190] = 0.00212097f;
        fArray2[191] = 1.3733E-4f;
        fArray2[192] = -4.578E-5f;
        fArray2[193] = -0.00120544f;
        fArray2[194] = 0.00305176f;
        fArray2[195] = -0.01957703f;
        fArray2[196] = 0.01211548f;
        fArray2[197] = -0.13729858f;
        fArray2[198] = -0.06916809f;
        fArray2[199] = -0.89009094f;
        fArray2[200] = 1.0481567f;
        fArray2[201] = 0.24650574f;
        fArray2[202] = 0.15206909f;
        fArray2[203] = 0.01670837f;
        fArray2[204] = 0.02772522f;
        fArray2[205] = -8.6975E-4f;
        fArray2[206] = 0.00201416f;
        fArray2[207] = 1.2207E-4f;
        fArray2[208] = -6.104E-5f;
        fArray2[209] = -0.001297f;
        fArray2[210] = 0.00288391f;
        fArray2[211] = -0.02069092f;
        fArray2[212] = 0.00923157f;
        fArray2[213] = -0.14067078f;
        fArray2[214] = -0.08877564f;
        fArray2[215] = -0.9130554f;
        fArray2[216] = 1.0319366f;
        fArray2[217] = 0.22198486f;
        fArray2[218] = 0.15196228f;
        fArray2[219] = 0.01242065f;
        fArray2[220] = 0.02684021f;
        fArray2[221] = -0.00126648f;
        fArray2[222] = 0.00190735f;
        fArray2[223] = 1.0681E-4f;
        fArray2[224] = -6.104E-5f;
        fArray2[225] = -0.00138855f;
        fArray2[226] = 0.00270081f;
        fArray2[227] = -0.02178955f;
        fArray2[228] = 0.00613403f;
        fArray2[229] = -0.14367676f;
        fArray2[230] = -0.10916138f;
        fArray2[231] = -0.9351959f;
        fArray2[232] = 1.0146179f;
        fArray2[233] = 0.19805908f;
        fArray2[234] = 0.15130615f;
        fArray2[235] = 0.00831604f;
        fArray2[236] = 0.02590942f;
        fArray2[237] = -0.00161743f;
        fArray2[238] = 0.00178528f;
        fArray2[239] = 1.0681E-4f;
        fArray2[240] = -7.629E-5f;
        fArray2[241] = -0.0014801f;
        fArray2[242] = 0.00248718f;
        fArray2[243] = -0.02285767f;
        fArray2[244] = 0.00282288f;
        fArray2[245] = -0.1462555f;
        fArray2[246] = -0.13031006f;
        fArray2[247] = -0.95648193f;
        fArray2[248] = 0.99624634f;
        fArray2[249] = 0.17478943f;
        fArray2[250] = 0.15011597f;
        fArray2[251] = 0.00439453f;
        fArray2[252] = 0.02493286f;
        fArray2[253] = -0.00193787f;
        fArray2[254] = 0.00169373f;
        fArray2[255] = 9.155E-5f;
        fArray2[256] = -0.00158691f;
        fArray2[257] = -0.02391052f;
        fArray2[258] = -0.14842224f;
        fArray2[259] = -0.9768524f;
        fArray2[260] = 0.15220642f;
        fArray2[261] = 6.8665E-4f;
        fArray2[262] = -0.00222778f;
        fArray2[263] = 7.629E-5f;
        t_polysyn_window = fArray2;
    }
}

