/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.media.codec.audio.gsm;

public class GsmDecoder {
    public static final String a_copyright_notice = "(c) Copyright IBM Corporation 1997,1999.";
    private static final int OutputSize = 160;
    private static final int InputSize = 33;
    private static final int LpcOrder = 8;
    private static final int SubFrameSize = 40;
    private static final int NumOfSubframes = 4;
    private static final int NumOfParameters = 76;
    private static final int NumOfPulses = 13;
    private static final int NumOfLarInterp = 4;
    private static final int QuantResBase = 120;
    private static final int SidFrame = 2;
    private static final int SpeechFrame = 1;
    private static final int NullFrame = 0;
    private static final float[] QLB;
    private static final int[] larInterpStart;
    private static final float[][] InterpLarCoef;
    private static float[] xmaxTable;
    private static float[][] larTable;
    private static final int Parameter_SubFramesBase = 8;
    private static final int Parameter_SubFramesLength = 17;
    private static final int Parameter_LtpLag = 0;
    private static final int Parameter_LtpGain = 1;
    private static final int Parameter_RpeGridPosition = 2;
    private static final int Parameter_BlockAmplitude = 3;
    private static final int Parameter_RpePulsesBase = 4;
    private short[] outsig = new short[160];
    private byte[] inByteStream = new byte[33];
    private float[] prevLARpp = new float[9];
    private float[] rp = new float[9];
    private float[] u = new float[9];
    private int[] lastSID = new int[76];
    private int prevNc;
    private float prevOut;
    private float[] quantRes = new float[280];
    private int seed;
    private int[] parameters = new int[76];
    private float[] LARpp = new float[9];
    private static final int GSM_MAGIC = 13;

    static {
        int n2;
        int n3;
        QLB = new float[]{0.1f, 0.35f, 0.65f, 1.0f};
        int[] nArray = new int[5];
        nArray[1] = 13;
        nArray[2] = 27;
        nArray[3] = 40;
        nArray[4] = 160;
        larInterpStart = nArray;
        float[][] fArrayArray = new float[4][];
        fArrayArray[0] = new float[]{0.75f, 0.25f};
        fArrayArray[1] = new float[]{0.5f, 0.5f};
        fArrayArray[2] = new float[]{0.25f, 0.75f};
        float[] fArray = new float[2];
        fArray[1] = 1.0f;
        fArrayArray[3] = fArray;
        InterpLarCoef = fArrayArray;
        short[] sArray = new short[8];
        sArray[2] = 2048;
        sArray[3] = -2560;
        sArray[4] = 94;
        sArray[5] = -1792;
        sArray[6] = -341;
        sArray[7] = -1144;
        short[] sArray2 = sArray;
        short[] sArray3 = new short[]{-32, -32, -16, -16, -8, -8, -4, -4};
        short[] sArray4 = new short[]{13107, 13107, 13107, 13107, 19223, 17476, 31454, 29708};
        xmaxTable = new float[64];
        int n4 = 0;
        while (n4 < 64) {
            if (n4 < 16) {
                n3 = 31 + (n4 << 5);
            } else {
                n2 = n4 - 16 >> 3;
                n3 = (576 << n2) - 1 + (n4 - 16 - 8 * n2) * (64 << n2);
            }
            GsmDecoder.xmaxTable[n4] = (float)n3 / 32768.0f;
            ++n4;
        }
        larTable = new float[8][];
        n2 = 0;
        while (n2 < 8) {
            GsmDecoder.larTable[n2] = new float[-sArray3[n2] * 2];
            n3 = 0;
            while (n3 < -sArray3[n2] * 2) {
                short s = (short)((n3 + sArray3[n2] << 10) - sArray2[n2] * 2);
                s = (short)((long)(s * sArray4[n2]) + 16384L >> 15);
                GsmDecoder.larTable[n2][n3] = (float)(s * 2) / 16384.0f;
                ++n3;
            }
            ++n2;
        }
    }

    private int GSMrand() {
        this.seed = this.seed * 1103515245 + 12345;
        return this.seed & Short.MAX_VALUE;
    }

    protected boolean UnpackBitStream(byte[] byArray, int n2, int[] nArray) {
        int n3 = 0;
        if ((byArray[n2] >> 4 & 0xF) != 13) {
            return false;
        }
        nArray[n3++] = (byArray[n2] & 0xF) << 2 | byArray[++n2] >> 6 & 3;
        nArray[n3++] = byArray[n2] & 0x3F;
        nArray[n3++] = byArray[++n2] >> 3 & 0x1F;
        nArray[n3++] = (byArray[n2] & 7) << 2 | byArray[++n2] >> 6 & 3;
        nArray[n3++] = byArray[n2] >> 2 & 0xF;
        nArray[n3++] = (byArray[n2] & 3) << 2 | byArray[++n2] >> 6 & 3;
        nArray[n3++] = byArray[n2] >> 3 & 7;
        nArray[n3++] = byArray[n2] & 7;
        ++n2;
        int n4 = 0;
        while (n4 < 4) {
            nArray[n3++] = byArray[n2] >> 1 & 0x7F;
            nArray[n3++] = (byArray[n2] & 1) << 1 | byArray[++n2] >> 7 & 1;
            nArray[n3++] = byArray[n2] >> 5 & 3;
            nArray[n3++] = (byArray[n2] & 0x1F) << 1 | byArray[++n2] >> 7 & 1;
            nArray[n3++] = byArray[n2] >> 4 & 7;
            nArray[n3++] = byArray[n2] >> 1 & 7;
            nArray[n3++] = (byArray[n2] & 1) << 2 | byArray[++n2] >> 6 & 3;
            nArray[n3++] = byArray[n2] >> 3 & 7;
            nArray[n3++] = byArray[n2] & 7;
            nArray[n3++] = byArray[++n2] >> 5 & 7;
            nArray[n3++] = byArray[n2] >> 2 & 7;
            nArray[n3++] = (byArray[n2] & 3) << 1 | byArray[++n2] >> 7 & 1;
            nArray[n3++] = byArray[n2] >> 4 & 7;
            nArray[n3++] = byArray[n2] >> 1 & 7;
            nArray[n3++] = (byArray[n2] & 1) << 2 | byArray[++n2] >> 6 & 3;
            nArray[n3++] = byArray[n2] >> 3 & 7;
            nArray[n3++] = byArray[n2] & 7;
            ++n2;
            ++n4;
        }
        return true;
    }

    public boolean decodeFrame(byte[] byArray, int n2, byte[] byArray2, int n3) {
        int n4;
        int n5;
        int n6;
        int n7;
        int n8;
        int[] nArray = this.parameters;
        int[] nArray2 = this.lastSID;
        float[] fArray = this.LARpp;
        float[] fArray2 = this.u;
        float[] fArray3 = this.rp;
        float[] fArray4 = this.prevLARpp;
        float[] fArray5 = this.quantRes;
        System.arraycopy(fArray5, 160, fArray5, 0, 120);
        if (!this.UnpackBitStream(byArray, n2, nArray)) {
            return false;
        }
        int n9 = 0;
        int n10 = 0;
        while (n10 < 76) {
            if (nArray[n10] != 0) {
                n9 = 2;
                break;
            }
            ++n10;
        }
        if (n9 == 0) {
            System.arraycopy(nArray2, 0, nArray, 0, 76);
            n9 = 2;
        } else {
            n8 = 0;
            while (n8 < 4) {
                int n11 = n8 * 17 + 8 + 4;
                n7 = 0;
                while (n7 < 13) {
                    if (nArray[n11 + n7] != 0) {
                        n9 = 1;
                        n8 = 4;
                        break;
                    }
                    ++n7;
                }
                ++n8;
            }
            if (n9 == 2) {
                System.arraycopy(nArray, 0, nArray2, 0, 76);
            }
        }
        if (n9 == 2) {
            n8 = 0;
            while (n8 < 4) {
                n6 = n8 * 17 + 8;
                n7 = 0;
                while (n7 < 13) {
                    nArray[n6 + 4 + n7] = this.GSMrand() / 5461 + 1;
                    ++n7;
                }
                nArray[n6 + 2] = this.GSMrand() / 10923;
                nArray[n6 + 1] = 0;
                nArray[n6] = n8 == 0 | n8 == 2 ? 40 : 120;
                ++n8;
            }
        }
        n8 = 0;
        while (n8 < 4) {
            n6 = n8 * 17 + 8;
            n5 = nArray[n6];
            if (n5 >= 40 && n5 <= 120) {
                this.prevNc = n5;
            }
            float f2 = QLB[nArray[n6 + 1]];
            n4 = nArray[n6 + 2];
            float f3 = xmaxTable[nArray[n6 + 3]];
            int n12 = n8 * 40 + 120;
            int n13 = 0;
            while (n13 < 40) {
                fArray5[n12 + n13] = f2 * fArray5[n12 + n13 - this.prevNc];
                ++n13;
            }
            int n14 = 0;
            while (n14 < 13) {
                int n15 = n12 + n4 + 3 * n14;
                fArray5[n15] = (float)((double)fArray5[n15] + (0.25 * (double)nArray[n6 + 4 + n14] - 0.875) * (double)f3);
                ++n14;
            }
            ++n8;
        }
        n6 = 0;
        while (n6 < 8) {
            fArray[n6 + 1] = larTable[n6][nArray[n6]];
            ++n6;
        }
        float f4 = this.prevOut;
        n5 = 0;
        while (n5 < 4) {
            int n16 = 1;
            while (n16 <= 8) {
                float f5 = fArray4[n16] * InterpLarCoef[n5][0] + fArray[n16] * InterpLarCoef[n5][1];
                fArray3[n16] = (double)Math.abs(f5) < 0.675 ? f5 : ((double)Math.abs(f5) < 1.225 ? (f5 > 0.0f ? 1.0f : -1.0f) * (0.5f * Math.abs(f5) + 0.3375f) : (f5 > 0.0f ? 1.0f : -1.0f) * (0.125f * Math.abs(f5) + 0.796875f));
                ++n16;
            }
            int n17 = larInterpStart[n5];
            while (n17 < larInterpStart[n5 + 1]) {
                float f6 = fArray5[120 + n17];
                fArray2[8] = fArray2[7] + fArray3[8] * (f6 -= fArray3[8] * fArray2[7]);
                fArray2[7] = fArray2[6] + fArray3[7] * (f6 -= fArray3[7] * fArray2[6]);
                fArray2[6] = fArray2[5] + fArray3[6] * (f6 -= fArray3[6] * fArray2[5]);
                fArray2[5] = fArray2[4] + fArray3[5] * (f6 -= fArray3[5] * fArray2[4]);
                fArray2[4] = fArray2[3] + fArray3[4] * (f6 -= fArray3[4] * fArray2[3]);
                fArray2[3] = fArray2[2] + fArray3[3] * (f6 -= fArray3[3] * fArray2[2]);
                fArray2[2] = fArray2[1] + fArray3[2] * (f6 -= fArray3[2] * fArray2[1]);
                fArray2[1] = fArray2[0] + fArray3[1] * (f6 -= fArray3[1] * fArray2[0]);
                f4 = f6 + f4 * 0.85998535f;
                fArray2[0] = f6;
                f6 = 65532.0f * f4;
                if (f6 > 32766.0f) {
                    f6 = 32766.0f;
                }
                if (f6 < -32766.0f) {
                    f6 = -32766.0f;
                }
                this.outsig[n17] = (short)f6;
                ++n17;
            }
            ++n5;
        }
        n4 = 1;
        while (n4 <= 8) {
            fArray4[n4] = fArray[n4];
            ++n4;
        }
        this.prevOut = f4;
        int n18 = 0;
        int n19 = 0;
        while (n19 < 160) {
            short s = this.outsig[n19];
            byArray2[n3 + n18++] = (byte)(s & 0xFF);
            byArray2[n3 + n18++] = (byte)(s >> 8);
            ++n19;
        }
        return true;
    }

    public void decoderInit() {
        this.prevNc = 40;
        this.prevOut = 0.0f;
        int n2 = 0;
        while (n2 < 9) {
            this.prevLARpp[n2] = 0.0f;
            this.rp[n2] = 0.0f;
            this.u[n2] = 0.0f;
            ++n2;
        }
        int n3 = 0;
        while (n3 < this.lastSID.length) {
            this.lastSID[n3] = 0;
            ++n3;
        }
        this.lastSID[0] = 2;
        this.lastSID[1] = 28;
        this.lastSID[2] = 18;
        this.lastSID[3] = 12;
        this.lastSID[4] = 7;
        this.lastSID[5] = 5;
        this.lastSID[6] = 3;
        this.lastSID[7] = 2;
        int n4 = 0;
        while (n4 < this.quantRes.length) {
            this.quantRes[n4] = 0.0f;
            ++n4;
        }
        this.seed = 1;
    }
}

