/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.media.codec.audio.rc;

import com.ibm.media.codec.audio.rc.RateConversionTables;

public final class RateConversion {
    public static final String a_copyright_notice = "(c) Copyright IBM Corporation 1997,1998.";
    public static final int RATE_CONVERSION_OK = -1;
    public static final int RATE_CONVERSION_NOT_SUPPORTED = -2;
    public static final int RATE_CONVERSION_NOT_INITIALIZED = -3;
    public static final int RATE_CONVERSION_ILLEGAL_PARAMETER = -4;
    public static final int RATE_CONVERSION_RECOMMENDED_INPUT_SIZE = 1056;
    public static final int RATE_CONVERSION_MAX_SUPPORTED_CHANNELS = 2;
    public static final int RATE_CONVERSION_MAX_OUTPUT_FACTOR = 5;
    public static final int RATE_CONVERSION_BIG_ENDIAN_FORMAT = 0;
    public static final int RATE_CONVERSION_LITTLE_ENDIAN_FORMAT = 1;
    public static final int RATE_CONVERSION_BYTE_FORMAT = 2;
    private static final boolean USE_REMOVE_DC = false;
    private boolean useMuLaw = false;
    private static final int MAX_RATE_IN = 11;
    private static final int UNROLLING_ORDER = 4;
    private static final int CORRECTION_FRAME_SIZE = 441;
    private static final int CONV_ERROR = -1;
    private static final int CONV_11to2 = 1;
    private static final int CONV_11to4 = 2;
    private static final int CONV_11to8 = 3;
    private static final int CONV_6to1 = 4;
    private static final int CONV_4to1 = 5;
    private static final int CONV_2to1 = 6;
    private static final int MAX_MEM_SIZE = 792;
    private static final float DCFACT = 0.9921875f;
    private static final float SHRT_MIN = -32767.0f;
    private static final float SHRT_MAX = 32767.0f;
    private static final float FRACTION_DELTA = 0.0022727272f;
    private static final float FRACTION_DELIMITER = 1.0011364f;
    private int bias;
    private int signMask;
    private int filterHistoryLength;
    private int decimFlag;
    private int numberOfInputChannels;
    private int numberOfOutputChannels;
    private boolean channels2To1 = false;
    private boolean channels1To2 = false;
    private boolean channels2To2 = false;
    private int rateIn;
    private int rateOut;
    private int[] index = new int[2];
    private int inputRemainedSamples;
    private int maxInputLength;
    private int paddingLength;
    private int maxDrainedSamples;
    private int pcmType;
    private int inputSampleSize;
    private float[] poly;
    private float[] x1;
    private float[] x2;
    private float[] y1;
    private float[] y2;
    private boolean needInputCorrection;
    private boolean isDrained;
    private boolean isRateConversionInited;
    private int delay;
    private float lastInputSample1;
    private float lastInputSample2;
    private float frac;
    private float prev_fsample1;
    private float prev_fsample2;
    private float fractionDelta = 0.0022727272f;
    private float fractionDelimiter;
    private int precisionCountDelimiter = 1;
    private int precisionCount;

    private final void Fl2Byte(float[] fArray, int n2, byte[] byArray, int n3) {
        int n4 = 0;
        int n5 = 0;
        while (n5 < n2) {
            float f2 = fArray[n5];
            if (f2 < -32767.0f) {
                f2 = -32767.0f;
            } else if (f2 > 32767.0f) {
                f2 = 32767.0f;
            }
            int n6 = (int)f2;
            byArray[n3 + n4] = (byte)(n6 & 0xFF);
            byArray[n3 + n4 + 1] = (byte)(n6 >> 8);
            n4 += 2;
            ++n5;
        }
    }

    private final void Fl2ByteStereo(float[] fArray, float[] fArray2, int n2, byte[] byArray, int n3) {
        int n4 = 0;
        int n5 = 0;
        while (n5 < n2) {
            float f2 = fArray[n5];
            if (f2 < -32767.0f) {
                f2 = -32767.0f;
            } else if (f2 > 32767.0f) {
                f2 = 32767.0f;
            }
            int n6 = (int)f2;
            byArray[n3 + n4] = (byte)(n6 & 0xFF);
            byArray[n3 + n4 + 1] = (byte)(n6 >> 8);
            f2 = fArray2[n5];
            if (f2 < -32767.0f) {
                f2 = -32767.0f;
            } else if (f2 > 32767.0f) {
                f2 = 32767.0f;
            }
            n6 = (int)f2;
            byArray[n3 + n4 + 2] = (byte)(n6 & 0xFF);
            byArray[n3 + n4 + 3] = (byte)(n6 >> 8);
            n4 += 4;
            ++n5;
        }
    }

    public void close() {
        this.isRateConversionInited = false;
        this.x1 = null;
        this.x2 = null;
        this.y1 = null;
        this.y2 = null;
        this.poly = null;
    }

    private void convertToMuLaw(float[] fArray, int n2, byte[] byArray, int n3) {
        int n4 = 0;
        while (n4 < n2) {
            int n5;
            float f2 = fArray[n4];
            if (f2 < -32767.0f) {
                f2 = -32767.0f;
            } else if (f2 > 32767.0f) {
                f2 = 32767.0f;
            }
            int n6 = (int)f2;
            if (n6 >= 0) {
                n5 = 128;
            } else {
                n6 = -n6;
                n5 = 0;
            }
            n6 = 132 + n6 >> 3;
            byArray[n3++] = n6 < 32 ? (byte)(n5 | 0x70 | 31 - n6) : (n6 < 64 ? (byte)(n5 | 0x60 | 31 - (n6 >> 1)) : (n6 < 128 ? (byte)(n5 | 0x50 | 31 - (n6 >> 2)) : (n6 < 256 ? (byte)(n5 | 0x40 | 31 - (n6 >> 3)) : (n6 < 512 ? (byte)(n5 | 0x30 | 31 - (n6 >> 4)) : (n6 < 1024 ? (byte)(n5 | 0x20 | 31 - (n6 >> 5)) : (n6 < 2048 ? (byte)(n5 | 0x10 | 31 - (n6 >> 6)) : (n6 < 4096 ? (byte)(n5 | 31 - (n6 >> 7)) : (byte)n5)))))));
            ++n4;
        }
    }

    void downsampleM(float[] fArray, float[] fArray2, float[] fArray3, int n2, int n3, int n4) {
        int n5 = n2 / 2;
        int n6 = n3 * 4;
        int n7 = n2 - 1;
        int n8 = 0;
        int n9 = 0;
        while (n9 < n4) {
            float f2 = 0.0f;
            float f3 = 0.0f;
            float f4 = 0.0f;
            float f5 = 0.0f;
            int n10 = n8 + n3;
            int n11 = n10 + n3;
            int n12 = n11 + n3;
            int n13 = 0;
            while (n13 < n5) {
                float f6 = fArray3[n13];
                f5 += f6 * (fArray[n8 + n13] + fArray[n8 + n7 - n13]);
                f4 += f6 * (fArray[n10 + n13] + fArray[n10 + n7 - n13]);
                f3 += f6 * (fArray[n11 + n13] + fArray[n11 + n7 - n13]);
                f2 += f6 * (fArray[n12 + n13] + fArray[n12 + n7 - n13]);
                ++n13;
            }
            fArray2[n9++] = f5;
            fArray2[n9++] = f4;
            fArray2[n9++] = f3;
            fArray2[n9++] = f2;
            n8 += n6;
        }
    }

    private int downsampleMtoL(float[] fArray, float[] fArray2, int n2, float[] fArray3, int n3, int n4, int n5, int n6, int n7) {
        int n8 = 0;
        int n9 = 0;
        while (n9 < n7) {
            float f2 = 0.0f;
            float f3 = 0.0f;
            float f4 = 0.0f;
            float f5 = 0.0f;
            int n10 = n2 * n3;
            int n11 = 0;
            while (n11 < n3) {
                float f6 = fArray3[n10 + n11];
                f5 += f6 * fArray[n11 + n8];
                f4 += f6 * fArray[n11 + n8 + n6];
                f3 += f6 * fArray[n11 + n8 + 2 * n6];
                f2 += f6 * fArray[n11 + n8 + 3 * n6];
                ++n11;
            }
            fArray2[n9 + n7] = f4;
            fArray2[n9 + 2 * n7] = f3;
            fArray2[n9 + 3 * n7] = f2;
            fArray2[n9] = f5;
            while (n2 < n5) {
                n2 += n4;
                ++n8;
            }
            n2 -= n5;
            ++n9;
        }
        return n2;
    }

    public int drain(byte[] byArray, int n2) {
        if (!this.isRateConversionInited) {
            return -3;
        }
        int n3 = (this.paddingLength + 4 * this.rateIn) * this.numberOfInputChannels * this.inputSampleSize;
        this.isDrained = true;
        int n4 = (int)((float)((this.paddingLength + this.inputRemainedSamples) * this.rateOut) / (float)this.rateIn);
        if (!this.useMuLaw) {
            n4 *= 2;
        }
        int n5 = this.process(null, 0, n3, byArray, n2);
        this.isDrained = false;
        if (n4 < n5) {
            n5 = n4;
        }
        return n5;
    }

    private void enlargeBufferAllocation(int n2) {
        this.maxInputLength = n2 / (this.inputSampleSize * this.numberOfInputChannels);
        float[] fArray = new float[this.maxInputLength + this.filterHistoryLength + 4 * this.rateIn];
        float[] fArray2 = new float[(this.maxInputLength + this.filterHistoryLength + 4 * this.rateIn) / this.rateIn * this.rateOut];
        int n3 = 0;
        while (n3 < this.x1.length) {
            fArray[n3] = this.x1[n3];
            ++n3;
        }
        n3 = 0;
        while (n3 < this.y1.length) {
            fArray2[n3] = this.y1[n3];
            ++n3;
        }
        this.x1 = fArray;
        this.y1 = fArray2;
        if (this.channels2To2) {
            fArray = new float[this.maxInputLength + this.filterHistoryLength + 4 * this.rateIn];
            fArray2 = new float[(this.maxInputLength + this.filterHistoryLength + 4 * this.rateIn) / this.rateIn * this.rateOut];
            n3 = 0;
            while (n3 < this.x2.length) {
                fArray[n3] = this.x2[n3];
                ++n3;
            }
            n3 = 0;
            while (n3 < this.y2.length) {
                fArray2[n3] = this.y2[n3];
                ++n3;
            }
            this.x2 = fArray;
            this.y2 = fArray2;
        }
    }

    private int extractInput(byte[] byArray, int n2, int n3, int n4) {
        int n5;
        int n6;
        int n7 = n4;
        float f2 = 0.0f;
        float f3 = 0.0f;
        int n8 = 0;
        int n9 = 0;
        boolean bl = false;
        if (this.isDrained) {
            int n10 = n3 / (this.numberOfInputChannels * this.inputSampleSize);
            int n11 = 0;
            while (n11 < n10) {
                this.x1[n7 + n11] = 0.0f;
                ++n11;
            }
            if (this.channels2To2) {
                n11 = 0;
                while (n11 < n10) {
                    this.x2[n7 + n11] = 0.0f;
                    ++n11;
                }
            }
            return n10;
        }
        if (this.pcmType == 1) {
            n6 = -1;
            n5 = 1;
        } else {
            n6 = 1;
            n5 = 0;
        }
        int n12 = n2 + n5;
        while (n12 < n3 + n2) {
            if (this.inputSampleSize == 1) {
                n8 = byArray[n12++] << 8;
                if (this.numberOfInputChannels == 2) {
                    n9 = byArray[n12++] << 8;
                }
            } else {
                n8 = (byArray[n12] << 8) + (0xFF & byArray[n12 + n6]);
                n12 += 2;
                if (this.numberOfInputChannels == 2) {
                    n9 = (byArray[n12] << 8) + (0xFF & byArray[n12 + n6]);
                    n12 += 2;
                }
            }
            if (this.channels2To1) {
                n8 = (n8 & this.signMask) + (n9 & this.signMask) >> 1;
            }
            f2 = (short)(n8 + this.bias);
            if (this.channels2To2) {
                f3 = (short)(n9 + this.bias);
            }
            if (this.channels1To2) {
                f3 = f2;
            }
            if (this.needInputCorrection) {
                if (this.frac > this.fractionDelimiter) {
                    ++this.precisionCount;
                    if (this.precisionCount == this.precisionCountDelimiter) {
                        this.precisionCount = 0;
                        this.frac = this.fractionDelta;
                    } else {
                        this.frac -= 1.0f;
                    }
                    this.prev_fsample1 = f2;
                    this.prev_fsample2 = f3;
                    continue;
                }
                this.x1[n7] = this.prev_fsample1 * (1.0f - this.frac) + this.frac * f2;
                this.prev_fsample1 = f2;
                if (this.channels2To2) {
                    this.x2[n7] = this.prev_fsample2 * (1.0f - this.frac) + this.frac * f3;
                    this.prev_fsample2 = f3;
                }
                this.frac += this.fractionDelta;
            } else {
                this.x1[n7] = f2;
                if (this.channels2To2) {
                    this.x2[n7] = f3;
                }
            }
            ++n7;
        }
        return n7 - n4;
    }

    public int getDelay() {
        if (!this.isRateConversionInited) {
            return -3;
        }
        int n2 = this.delay;
        if (!this.useMuLaw) {
            n2 *= 2;
        }
        return n2;
    }

    public int getDrainMaxLength() {
        if (!this.isRateConversionInited) {
            return -3;
        }
        int n2 = this.maxDrainedSamples;
        if (!this.useMuLaw) {
            n2 *= 2;
        }
        return n2;
    }

    public int getMaxOutputLength() {
        if (!this.isRateConversionInited) {
            return -3;
        }
        int n2 = (this.maxInputLength + this.rateIn * 4) * this.rateOut / this.rateIn;
        if (!this.useMuLaw) {
            n2 *= 2;
        }
        return n2;
    }

    public int getMaxOutputLength(int n2) {
        if (!this.isRateConversionInited) {
            return -3;
        }
        int n3 = n2 / (this.inputSampleSize * this.numberOfInputChannels);
        int n4 = (n3 + this.rateIn * 4) * this.rateOut / this.rateIn;
        if (!this.useMuLaw) {
            n4 *= 2;
        }
        return n4 *= this.numberOfOutputChannels;
    }

    public int init(int n2, int n3, int n4, int n5, int n6, int n7, boolean bl, boolean bl2) {
        int n8;
        this.useMuLaw = bl2;
        this.inputSampleSize = 2;
        if (n7 != 0 && n7 != 1 && n7 != 2) {
            return -4;
        }
        if (bl) {
            this.bias = 0;
            this.signMask = -1;
        } else {
            this.bias = 32768;
            this.signMask = 65535;
        }
        if (n7 == 2) {
            this.inputSampleSize = 1;
        }
        this.pcmType = n7;
        this.maxInputLength = n2 / (this.inputSampleSize * n5);
        this.numberOfInputChannels = n5;
        this.numberOfOutputChannels = n6;
        this.channels2To1 = this.numberOfInputChannels == 2 && this.numberOfOutputChannels == 1;
        this.channels1To2 = this.numberOfInputChannels == 1 && this.numberOfOutputChannels == 2;
        this.channels2To2 = this.numberOfInputChannels == 2 && this.numberOfOutputChannels == 2;
        this.needInputCorrection = false;
        this.delay = 0;
        this.decimFlag = -1;
        if (n3 == 44100 && n4 == 8000) {
            this.decimFlag = 1;
            this.rateIn = 11;
            this.rateOut = 2;
            this.needInputCorrection = true;
        } else if (n3 == 22050 && n4 == 8000) {
            this.decimFlag = 2;
            this.rateIn = 11;
            this.rateOut = 4;
            this.needInputCorrection = true;
        } else if (n3 == 11025 && n4 == 8000) {
            this.decimFlag = 3;
            this.rateIn = 11;
            this.rateOut = 8;
            this.needInputCorrection = true;
        } else if (n3 == 48000 && n4 == 8000) {
            this.decimFlag = 4;
            this.rateIn = 6;
            this.rateOut = 1;
            this.needInputCorrection = false;
        } else if (n3 == 32000 && n4 == 8000) {
            this.decimFlag = 5;
            this.rateIn = 4;
            this.rateOut = 1;
            this.needInputCorrection = false;
        } else if (n3 == 16000 && n4 == 8000) {
            this.decimFlag = 6;
            this.rateIn = 2;
            this.rateOut = 1;
            this.needInputCorrection = false;
        } else if (n3 == 11127 && n4 == 8000) {
            this.decimFlag = 3;
            this.rateIn = 11;
            this.rateOut = 8;
            this.needInputCorrection = true;
            this.fractionDelta = 0.011545454f;
            this.precisionCountDelimiter = 127;
        } else if (n3 == 22254 && n4 == 8000) {
            this.decimFlag = 2;
            this.rateIn = 11;
            this.rateOut = 4;
            this.needInputCorrection = true;
            this.fractionDelta = 0.011545454f;
            this.precisionCountDelimiter = 127;
        } else if (n3 == 22255 && n4 == 8000) {
            this.decimFlag = 2;
            this.rateIn = 11;
            this.rateOut = 4;
            this.needInputCorrection = true;
            this.fractionDelta = 0.011590909f;
            this.precisionCountDelimiter = 255;
        } else {
            this.close();
            return -2;
        }
        switch (this.decimFlag) {
            case 3: {
                this.filterHistoryLength = 25;
                this.delay = 9;
                n8 = 200;
                break;
            }
            case 2: {
                this.filterHistoryLength = 50;
                this.delay = 9;
                n8 = 200;
                break;
            }
            case 1: {
                this.filterHistoryLength = 100;
                this.delay = 9;
                n8 = 200;
                break;
            }
            case 4: {
                this.filterHistoryLength = 128;
                this.delay = 11;
                n8 = 128;
                break;
            }
            case 5: {
                this.filterHistoryLength = 128;
                this.delay = 16;
                n8 = 128;
                break;
            }
            case 6: {
                this.filterHistoryLength = 64;
                this.delay = 16;
                n8 = 64;
                break;
            }
            default: {
                this.close();
                return -2;
            }
        }
        this.poly = new float[n8];
        this.x1 = new float[this.maxInputLength + this.filterHistoryLength + 4 * this.rateIn];
        this.y1 = new float[(this.maxInputLength + this.filterHistoryLength + 4 * this.rateIn) / this.rateIn * this.rateOut];
        if (this.channels2To2) {
            this.x2 = new float[this.maxInputLength + this.filterHistoryLength + 4 * this.rateIn];
            this.y2 = new float[(this.maxInputLength + this.filterHistoryLength + 4 * this.rateIn) / this.rateIn * this.rateOut];
        }
        float f2 = 1.0f;
        switch (this.decimFlag) {
            case 1: {
                f2 = 2.0f;
                int n9 = 0;
                while (n9 < 2) {
                    int n10 = 0;
                    while (n10 < 100) {
                        this.poly[n9 * 100 + n10] = RateConversionTables.filter11[n9 + n10 * 2] * f2;
                        ++n10;
                    }
                    ++n9;
                }
                break;
            }
            case 2: {
                f2 = 4.0f;
                int n11 = 0;
                while (n11 < 4) {
                    int n12 = 0;
                    while (n12 < 50) {
                        this.poly[n11 * 50 + n12] = RateConversionTables.filter11[n11 + n12 * 4] * f2;
                        ++n12;
                    }
                    ++n11;
                }
                break;
            }
            case 3: {
                f2 = 8.0f;
                int n13 = 0;
                while (n13 < 8) {
                    int n14 = 0;
                    while (n14 < 25) {
                        this.poly[n13 * 25 + n14] = RateConversionTables.filter11[n13 + n14 * 8] * f2;
                        ++n14;
                    }
                    ++n13;
                }
                break;
            }
            case 4: {
                int n15 = 0;
                while (n15 < 128) {
                    this.poly[n15] = RateConversionTables.filter6[n15];
                    ++n15;
                }
                break;
            }
            case 5: {
                int n16 = 0;
                while (n16 < 128) {
                    this.poly[n16] = RateConversionTables.filter4[n16];
                    ++n16;
                }
                break;
            }
            case 6: {
                int n17 = 0;
                while (n17 < 64) {
                    this.poly[n17] = RateConversionTables.filter2[n17];
                    ++n17;
                }
                break;
            }
        }
        this.paddingLength = this.filterHistoryLength / 2;
        this.maxDrainedSamples = (int)((float)((this.paddingLength + 4 * this.rateIn * 2) * this.rateOut) / (float)this.rateIn);
        this.isRateConversionInited = true;
        this.fractionDelimiter = 1.0f + this.fractionDelta / 2.0f;
        this.reset();
        return -1;
    }

    public int process(byte[] byArray, int n2, int n3, byte[] byArray2, int n4) {
        if (!this.isRateConversionInited) {
            return -3;
        }
        if (!this.isDrained && n3 > this.maxInputLength * this.inputSampleSize * this.numberOfInputChannels) {
            this.enlargeBufferAllocation(n3);
        }
        if (n3 == 0) {
            return 0;
        }
        int n5 = this.inputRemainedSamples + this.filterHistoryLength;
        n3 = this.extractInput(byArray, n2, n3, n5);
        int n6 = n3 + this.inputRemainedSamples;
        int n7 = n6 / (4 * this.rateIn);
        this.inputRemainedSamples = n6 - n7 * (4 * this.rateIn);
        n5 = this.inputRemainedSamples + this.filterHistoryLength;
        if ((n6 -= this.inputRemainedSamples) == 0) {
            return 0;
        }
        int n8 = n6 / this.rateIn * this.rateOut;
        int n9 = 1;
        if (this.channels2To2) {
            n9 = 2;
        }
        int n10 = 0;
        while (n10 < n9) {
            float[] fArray;
            float[] fArray2;
            if (n10 > 0) {
                fArray2 = this.x2;
                fArray = this.y2;
            } else {
                fArray2 = this.x1;
                fArray = this.y1;
            }
            switch (this.decimFlag) {
                case 3: {
                    this.index[n10] = this.downsampleMtoL(fArray2, fArray, this.index[n10], this.poly, 25, 8, 11, (n8 >> 5) * 11, n8 >> 2);
                    break;
                }
                case 2: {
                    this.index[n10] = this.downsampleMtoL(fArray2, fArray, this.index[n10], this.poly, 50, 4, 11, (n8 >> 4) * 11, n8 >> 2);
                    break;
                }
                case 1: {
                    this.index[n10] = this.downsampleMtoL(fArray2, fArray, this.index[n10], this.poly, 100, 2, 11, (n8 >> 3) * 11, n8 >> 2);
                    break;
                }
                case 4: {
                    this.downsampleM(fArray2, fArray, this.poly, 128, 6, n8);
                    break;
                }
                case 5: {
                    this.downsampleM(fArray2, fArray, this.poly, 128, 4, n8);
                    break;
                }
                case 6: {
                    this.downsampleM(fArray2, fArray, this.poly, 64, 2, n8);
                    break;
                }
            }
            int n11 = 0;
            while (n11 < n5) {
                fArray2[n11] = fArray2[n11 + n6];
                ++n11;
            }
            ++n10;
        }
        if (!this.useMuLaw) {
            if (this.numberOfOutputChannels == 1) {
                this.Fl2Byte(this.y1, n8, byArray2, n4);
                return 2 * n8;
            }
            if (this.channels1To2) {
                this.y2 = this.y1;
            }
            this.Fl2ByteStereo(this.y1, this.y2, n8, byArray2, n4);
            return 4 * n8;
        }
        this.convertToMuLaw(this.y1, n8, byArray2, n4);
        return n8;
    }

    private float remove_dc(float[] fArray, int n2, float f2, int n3) {
        return 0.0f;
    }

    public int reset() {
        if (!this.isRateConversionInited) {
            return -3;
        }
        this.inputRemainedSamples = 0;
        this.isDrained = false;
        this.frac = 1.0f;
        this.precisionCount = this.precisionCountDelimiter - 1;
        this.prev_fsample1 = 0.0f;
        this.prev_fsample2 = 0.0f;
        int n2 = 0;
        while (n2 < this.filterHistoryLength) {
            this.x1[n2] = 0.0f;
            ++n2;
        }
        this.index[0] = 0;
        if (this.channels2To2) {
            n2 = 0;
            while (n2 < this.filterHistoryLength) {
                this.x2[n2] = 0.0f;
                ++n2;
            }
            this.index[1] = 0;
        }
        this.lastInputSample1 = 0.0f;
        this.lastInputSample2 = 0.0f;
        return -1;
    }
}

