/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.codec.video.mpeg;

import java.awt.Dimension;
import java.io.BufferedOutputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Vector;
import javax.media.Buffer;
import javax.media.Format;
import javax.media.format.VideoFormat;

public class RTPDePacketizer {
    private static final float[] RATE_TABLE;
    private static char[] hexChar;
    private long discardtimestamp;
    private MPEGFrame currentframe;
    private boolean newframe;
    private boolean gotSequenceHeader;
    private boolean sequenceSent;
    private byte[] sequenceHeader;
    private boolean gopset;
    private int closedGop;
    private int ref_pic_temp;
    private int dep_pic_temp;
    private int sequenceNumber;
    private int width;
    private int height;
    private float frameRate;
    private VideoFormat outFormat;
    private boolean allowHeadless;
    private boolean fullFrameOnly;
    private boolean droppedPFrame;
    private boolean droppedIFrame;
    private boolean capture;
    private OutputStream captureFile;
    private static final boolean debug = false;
    private static int MAX_SEQ;

    static {
        float[] fArray = new float[9];
        fArray[1] = 23.976f;
        fArray[2] = 24.0f;
        fArray[3] = 25.0f;
        fArray[4] = 29.97f;
        fArray[5] = 30.0f;
        fArray[6] = 50.0f;
        fArray[7] = 59.94f;
        fArray[8] = 60.0f;
        RATE_TABLE = fArray;
        hexChar = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};
        MAX_SEQ = 65535;
    }

    RTPDePacketizer() {
        block2: {
            this.discardtimestamp = -1L;
            this.currentframe = null;
            this.newframe = true;
            this.gotSequenceHeader = false;
            this.sequenceSent = false;
            this.sequenceHeader = null;
            this.gopset = false;
            this.closedGop = 0;
            this.ref_pic_temp = -1;
            this.dep_pic_temp = -1;
            this.sequenceNumber = 0;
            this.width = 352;
            this.height = 240;
            this.frameRate = -1.0f;
            this.outFormat = null;
            this.allowHeadless = false;
            this.fullFrameOnly = true;
            this.droppedPFrame = false;
            this.droppedIFrame = false;
            this.capture = false;
            this.captureFile = null;
            if (!this.capture) break block2;
            try {
                this.captureFile = new BufferedOutputStream(new FileOutputStream("/tmp/rtpstream.mpg"));
            }
            catch (IOException iOException) {
                System.err.println("RTPDePacketizer: unable to open file " + iOException);
                this.capture = false;
            }
        }
    }

    private int addToFrame(Buffer buffer, Buffer buffer2) {
        Buffer buffer3 = this.copyInto(buffer);
        this.currentframe.add(buffer3);
        if ((buffer3.getFlags() & 0x800) != 0 && this.constructFrame(buffer2)) {
            return 0;
        }
        return 4;
    }

    private int compareSequenceNumbers(long l2, long l3) {
        if (l3 > l2) {
            return (int)(l3 - l2);
        }
        if (l3 == l2) {
            return 0;
        }
        if (l2 > (long)(MAX_SEQ - 100) && l3 < 100L) {
            return (int)((long)MAX_SEQ - l2 + l3 + 1L);
        }
        return -1;
    }

    private boolean constructFrame(Buffer buffer) {
        block24: {
            Object object;
            Object object2;
            int n2;
            Object object3 = (Buffer)this.currentframe.data.lastElement();
            int n3 = ((byte[])((Buffer)object3).getData())[((Buffer)object3).getOffset() + 2] & 7;
            if (this.fullFrameOnly) {
                if (n3 >= 2 && (this.droppedIFrame || this.droppedPFrame)) {
                    this.dropFrame();
                    return false;
                }
                if (n3 == 1) {
                    this.droppedIFrame = false;
                    this.droppedPFrame = false;
                }
                if ((((Buffer)object3).getFlags() & 0x800) == 0) {
                    this.dropFrame();
                    return false;
                }
                n2 = this.currentframe.data.size() - 2;
                while (n2 >= 0) {
                    object2 = (Buffer)this.currentframe.data.elementAt(n2);
                    if (this.compareSequenceNumbers(object2.getSequenceNumber(), ((Buffer)object3).getSequenceNumber()) != 1) {
                        this.dropFrame();
                        return false;
                    }
                    object3 = object2;
                    --n2;
                }
            }
            n2 = 1;
            object2 = (byte[])buffer.getData();
            if (object2 == null || ((byte[])object2).length < this.currentframe.datalength + this.sequenceHeader.length + 16) {
                object2 = new byte[this.currentframe.datalength + this.sequenceHeader.length + 16];
            }
            buffer.setData(object2);
            buffer.setOffset(0);
            buffer.setLength(0);
            this.constructHeaders(buffer);
            if (!this.sequenceSent) {
                this.dropFrame();
                return false;
            }
            int n4 = buffer.getLength();
            int n5 = 0;
            while (n5 < this.currentframe.data.size()) {
                block23: {
                    int n6;
                    object3 = (Buffer)this.currentframe.data.elementAt(n5);
                    object = (byte[])((Buffer)object3).getData();
                    if ((object[(n6 = ((Buffer)object3).getOffset()) + 2] & 0x10) == 16) {
                        if ((object[n6 + 2] & 8) == 8) {
                            System.arraycopy(object, n6 + 4, object2, n4, ((Buffer)object3).getLength() - 4);
                            n4 += ((Buffer)object3).getLength() - 4;
                            n2 = 0;
                        } else {
                            long l2 = ((Buffer)object3).getSequenceNumber();
                            int n7 = n5 + 1;
                            while (n7 < this.currentframe.data.size()) {
                                Buffer buffer2 = (Buffer)this.currentframe.data.elementAt(n7);
                                if (this.compareSequenceNumbers(l2, buffer2.getSequenceNumber()) != 1) {
                                    if (n5 == 0) {
                                        int n8 = ((Buffer)object3).getLength() - 4;
                                        int n9 = n6 += 4;
                                        while (n8 > 4) {
                                            if (object[n9] == false && object[n9 + 1] == false && object[n9 + 2] == true && (object[n9 + 3] & 0xFF) > 0 && (object[n9 + 3] & 0xFF) <= 175) break;
                                            ++n9;
                                            --n8;
                                        }
                                        if (n9 != n6) {
                                            System.arraycopy(object, n6, object2, n4, n9 - n6);
                                            n4 += n9 - n6;
                                        }
                                    }
                                    break block23;
                                }
                                l2 = buffer2.getSequenceNumber();
                                if ((((byte[])buffer2.getData())[buffer2.getOffset() + 2] & 8) == 8) break;
                                ++n7;
                            }
                            if (n7 == this.currentframe.data.size()) break;
                            int n10 = n5;
                            while (n10 <= n7) {
                                object3 = (Buffer)this.currentframe.data.elementAt(n10);
                                System.arraycopy((byte[])((Buffer)object3).getData(), ((Buffer)object3).getOffset() + 4, object2, n4, ((Buffer)object3).getLength() - 4);
                                n4 += ((Buffer)object3).getLength() - 4;
                                ++n10;
                            }
                            n2 = 0;
                            n5 = n7;
                        }
                    }
                }
                ++n5;
            }
            if (this.outFormat == null || this.outFormat.getSize().width != this.width || this.outFormat.getSize().height != this.height || this.outFormat.getFrameRate() != this.frameRate) {
                object = new Dimension(this.width, this.height);
                this.outFormat = new VideoFormat("mpeg", (Dimension)object, -1, Format.byteArray, this.frameRate);
            }
            buffer.setLength(n4);
            buffer.setFormat(this.outFormat);
            if (n2 != 0) {
                buffer.setFlags(2);
            }
            buffer.setTimeStamp(this.currentframe.rtptimestamp);
            buffer.setSequenceNumber(this.sequenceNumber++);
            this.newframe = true;
            this.currentframe = null;
            if (n2 != 0) {
                return false;
            }
            if (!this.capture) break block24;
            try {
                this.captureFile.write((byte[])buffer.getData(), buffer.getOffset(), buffer.getLength());
            }
            catch (IOException iOException) {
                System.err.println("RTPDePacketizer: write error for sequence number " + buffer.getSequenceNumber() + " : " + iOException);
                this.capture = false;
            }
        }
        return true;
    }

    private void constructGop(Buffer buffer) {
        byte[] byArray = (byte[])buffer.getData();
        int n2 = buffer.getLength();
        if (this.sequenceHeader != null) {
            System.arraycopy(this.sequenceHeader, 0, byArray, n2, this.sequenceHeader.length);
            buffer.setLength(buffer.getLength() + this.sequenceHeader.length);
            n2 += this.sequenceHeader.length;
            this.sequenceSent = true;
        }
        byArray[n2] = 0;
        byArray[n2 + 1] = 0;
        byArray[n2 + 2] = 1;
        byArray[n2 + 3] = -72;
        byArray[n2 + 4] = -128;
        byArray[n2 + 5] = 8;
        byArray[n2 + 6] = 0;
        byArray[n2 + 7] = (byte)(this.closedGop | 0x20);
        buffer.setLength(buffer.getLength() + 8);
        this.ref_pic_temp = 0;
        this.dep_pic_temp = -1;
    }

    private void constructHeaders(Buffer buffer) {
        boolean bl = false;
        boolean bl2 = false;
        byte[] byArray = (byte[])buffer.getData();
        Buffer buffer2 = (Buffer)this.currentframe.data.elementAt(0);
        byte[] byArray2 = (byte[])buffer2.getData();
        int n2 = buffer2.getOffset();
        int n3 = (byArray2[n2] & 3) << 8 | byArray2[n2 + 1] & 0xFF;
        int n4 = byArray2[n2 + 2] & 7;
        if (buffer2.getLength() >= 8 && (byArray2[n2 + 2] & 0x10) == 16 && byArray2[n2 + 4] == 0 && byArray2[n2 + 5] == 0 && byArray2[n2 + 6] == 1) {
            int n5 = byArray2[n2 + 7] & 0xFF;
            if (n5 == 179) {
                this.sequenceSent = true;
                this.ref_pic_temp = n3;
                this.dep_pic_temp = -1;
                return;
            }
            if (n5 == 184) {
                if (this.sequenceHeader != null) {
                    System.arraycopy(this.sequenceHeader, 0, byArray, buffer.getLength(), this.sequenceHeader.length);
                    buffer.setLength(buffer.getLength() + this.sequenceHeader.length);
                    this.sequenceSent = true;
                }
                this.ref_pic_temp = n3;
                this.dep_pic_temp = -1;
                return;
            }
            if (n5 == 0) {
                bl = true;
            }
        }
        ++this.ref_pic_temp;
        ++this.dep_pic_temp;
        if (n4 < 3) {
            if (n3 < this.ref_pic_temp) {
                this.constructGop(buffer);
            }
            this.ref_pic_temp = n3;
        } else {
            if (n3 < this.dep_pic_temp) {
                this.constructGop(buffer);
            }
            this.dep_pic_temp = n3;
        }
        if (!bl) {
            this.constructPicture(buffer2, buffer);
        }
    }

    private void constructPicture(Buffer buffer, Buffer buffer2) {
        byte[] byArray = (byte[])buffer.getData();
        int n2 = buffer.getOffset();
        byte[] byArray2 = (byte[])buffer2.getData();
        int n3 = buffer2.getLength();
        int n4 = 0;
        byArray2[n3] = 0;
        byArray2[n3 + 1] = 0;
        byArray2[n3 + 2] = 1;
        byArray2[n3 + 3] = 0;
        byArray2[n3 + 4] = (byte)((byArray[n2] & 3) << 6 | (byArray[n2 + 1] & 0xFC) >> 2);
        int n5 = byArray[n2 + 2] & 7;
        int n6 = (byArray[n2 + 3] & 0xF0) >> 4;
        int n7 = byArray[n2 + 3] & 0xF;
        byArray2[n3 + 5] = (byte)((byArray[n2 + 1] & 2) << 6 | n5 << 3);
        byArray2[n3 + 6] = 0;
        if (n5 == 1) {
            byArray2[n3 + 7] = 0;
            buffer2.setLength(buffer2.getLength() + 8);
        } else {
            n4 = n7 >> 1;
            byArray2[n3 + 7] = (byte)n4;
            n4 = (n7 & 1) << 7;
            if (n5 > 2) {
                n4 |= n6 << 3;
            }
            byArray2[n3 + 8] = (byte)n4;
            buffer2.setLength(buffer2.getLength() + 9);
        }
    }

    private Buffer copyInto(Buffer buffer) {
        Buffer buffer2 = new Buffer();
        buffer2.copy(buffer);
        buffer.setData(null);
        buffer.setHeader(null);
        buffer.setLength(0);
        buffer.setOffset(0);
        return buffer2;
    }

    private MPEGFrame createNewFrame(Buffer buffer) {
        Buffer buffer2 = this.copyInto(buffer);
        MPEGFrame mPEGFrame = new MPEGFrame(buffer2);
        mPEGFrame.add(buffer2);
        return mPEGFrame;
    }

    private void dropBufferFrame(Buffer buffer) {
        int n2 = ((byte[])buffer.getData())[buffer.getOffset() + 2] & 7;
        if (n2 == 1) {
            this.droppedIFrame = true;
        } else if (n2 == 2) {
            this.droppedPFrame = true;
        }
        this.newframe = true;
        this.currentframe = null;
    }

    private void dropFrame() {
        Buffer buffer = (Buffer)this.currentframe.data.firstElement();
        this.dropBufferFrame(buffer);
    }

    public void finalize() {
        block2: {
            if (!this.capture) break block2;
            try {
                this.captureFile.flush();
                this.captureFile.close();
                System.err.println("RTPDePacketizer: closed file");
            }
            catch (IOException iOException) {
                System.err.println("RTPDePacketizer: unable to close file " + iOException);
                this.capture = false;
            }
        }
    }

    private boolean firstPacket(Buffer buffer) {
        if (buffer == null) {
            return false;
        }
        byte[] byArray = (byte[])buffer.getData();
        if (byArray == null) {
            return false;
        }
        int n2 = buffer.getOffset();
        int n3 = buffer.getLength();
        if (n3 < 12) {
            return false;
        }
        if (!this.gotSequenceHeader) {
            if ((byArray[n2 + 2] & 0x20) == 32 && byArray[n2 + 4] == 0 && byArray[n2 + 5] == 0 && byArray[n2 + 6] == 1 && (byArray[n2 + 7] & 0xFF) == 179) {
                this.width = (byArray[n2 + 8] & 0xFF) << 4 | (byArray[n2 + 9] & 0xF0) >> 4;
                this.height = (byArray[n2 + 9] & 0xF) << 8 | byArray[n2 + 10] & 0xFF;
                this.gotSequenceHeader = true;
                n3 -= 4;
                int n4 = n2 += 4;
                while (n3 > 8) {
                    if (byArray[n4] == 0 && byArray[n4 + 1] == 0 && byArray[n4 + 2] == 1 && (byArray[n4 + 3] & 0xFF) == 184) {
                        this.gopset = true;
                        this.closedGop = byArray[n4 + 7] & 0x40;
                        byArray[n4 + 7] = (byte)(byArray[n4 + 7] & 0x20);
                        this.sequenceHeader = new byte[n4 - n2];
                        System.arraycopy(byArray, n2, this.sequenceHeader, 0, this.sequenceHeader.length);
                        return true;
                    }
                    ++n4;
                    --n3;
                }
                return true;
            }
            return false;
        }
        if ((byArray[n2 + 2] & 0x10) != 16) {
            return false;
        }
        n2 += 4;
        n3 -= 4;
        while (n3 > 8) {
            if (byArray[n2] == 0 && byArray[n2 + 1] == 0 && byArray[n2 + 2] == 1) {
                if (byArray[n2 + 3] == 0) {
                    return true;
                }
                if ((byArray[n2 + 3] & 0xFF) == 184) {
                    this.gopset = true;
                    this.closedGop = byArray[n2 + 7] & 0x40;
                    byArray[n2 + 7] = (byte)(byArray[n2 + 7] | 0x20);
                    return true;
                }
                if ((byArray[n2 + 3] & 0xFF) <= 175) {
                    return false;
                }
            }
            ++n2;
            --n3;
        }
        return false;
    }

    public int process(Buffer buffer, Buffer buffer2) {
        if (buffer.getTimeStamp() == this.discardtimestamp && this.discardtimestamp != -1L) {
            return 4;
        }
        if (!this.newframe && this.currentframe != null && buffer.getTimeStamp() != this.currentframe.rtptimestamp) {
            if (this.allowHeadless || this.firstPacket(buffer)) {
                boolean bl = false;
                if (this.fullFrameOnly) {
                    this.dropFrame();
                } else {
                    bl = this.constructFrame(buffer2);
                }
                this.currentframe = this.createNewFrame(buffer);
                if (bl) {
                    return 0;
                }
                if ((this.currentframe.getFirst().getFlags() & 0x800) != 0 && this.constructFrame(buffer2)) {
                    return 0;
                }
                return 4;
            }
            this.discardtimestamp = buffer.getTimeStamp();
            if (this.fullFrameOnly) {
                this.dropFrame();
                this.dropBufferFrame(buffer);
            } else if (this.compareSequenceNumbers(this.currentframe.seqno, buffer.getSequenceNumber()) > 0 && this.constructFrame(buffer2)) {
                return 0;
            }
            return 4;
        }
        if (this.newframe) {
            if (this.firstPacket(buffer)) {
                this.newframe = false;
                this.currentframe = this.createNewFrame(buffer);
                if ((this.currentframe.getFirst().getFlags() & 0x800) != 0 && this.constructFrame(buffer2)) {
                    return 0;
                }
                return 4;
            }
            if (this.fullFrameOnly) {
                this.dropBufferFrame(buffer);
            }
            this.discardtimestamp = buffer.getTimeStamp();
            this.newframe = true;
            return 4;
        }
        int n2 = this.addToFrame(buffer, buffer2);
        return n2;
    }

    protected String toHex(byte[] byArray, int n2) {
        String string = new String();
        int n3 = 0;
        while (n3 < 4) {
            string = String.valueOf(string) + hexChar[byArray[n2 + n3] >> 4 & 0xF];
            string = String.valueOf(string) + hexChar[byArray[n2 + n3] & 0xF];
            ++n3;
        }
        return string;
    }

    class MPEGFrame {
        public long rtptimestamp = -1L;
        public long seqno = -1L;
        private int datalength = 0;
        private Vector data = new Vector();

        public MPEGFrame(Buffer buffer) {
            this.rtptimestamp = buffer.getTimeStamp();
        }

        public void add(Buffer buffer) {
            if (buffer == null || buffer.getData() == null || buffer.getLength() < 4) {
                return;
            }
            if (RTPDePacketizer.this.compareSequenceNumbers(this.seqno, buffer.getSequenceNumber()) > 0) {
                this.data.addElement(buffer);
                this.seqno = buffer.getSequenceNumber();
            } else {
                long l2 = buffer.getSequenceNumber();
                int n2 = 0;
                while (n2 < this.data.size()) {
                    long l3 = ((Buffer)this.data.elementAt(n2)).getSequenceNumber();
                    if (RTPDePacketizer.this.compareSequenceNumbers(l3, l2) < 0) {
                        this.data.insertElementAt(buffer, n2);
                        break;
                    }
                    if (l2 == l3) {
                        return;
                    }
                    ++n2;
                }
            }
            this.datalength += buffer.getLength() - 4;
        }

        public Vector getData() {
            return this.data;
        }

        public Buffer getFirst() {
            if (this.data.size() > 0) {
                return (Buffer)this.data.firstElement();
            }
            return null;
        }

        public int getLength() {
            return this.datalength;
        }
    }
}

