/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.rtp;

import com.ms.security.PermissionID;
import com.ms.security.PolicyEngine;
import com.sun.media.JMFSecurity;
import com.sun.media.JMFSecurityManager;
import com.sun.media.Log;
import com.sun.media.protocol.BasicSourceStream;
import com.sun.media.protocol.BufferListener;
import com.sun.media.protocol.rtp.DataSource;
import com.sun.media.rtp.BufferControlImpl;
import com.sun.media.rtp.RTPRawReceiver;
import com.sun.media.rtp.util.RTPMediaThread;
import com.sun.media.util.MediaThread;
import com.sun.media.util.jdk12;
import com.sun.media.util.jdk12CreateThreadRunnableAction;
import com.sun.media.util.jdk12PriorityAction;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import javax.media.Buffer;
import javax.media.Format;
import javax.media.control.BufferControl;
import javax.media.format.AudioFormat;
import javax.media.format.VideoFormat;
import javax.media.protocol.BufferTransferHandler;
import javax.media.protocol.ContentDescriptor;
import javax.media.protocol.PushBufferStream;

public class RTPSourceStream
extends BasicSourceStream
implements PushBufferStream,
Runnable {
    private DataSource dsource;
    private Format format = null;
    BufferTransferHandler handler = null;
    boolean started = false;
    boolean killed = false;
    boolean replenish = true;
    PktQue pktQ;
    Object startReq = new Object();
    private RTPMediaThread thread = null;
    private boolean hasRead = false;
    private int DEFAULT_AUDIO_RATE = 8000;
    private int DEFAULT_VIDEO_RATE = 15;
    private BufferControlImpl bc = null;
    private long lastSeqRecv = -1L;
    private long lastSeqSent = -1L;
    private static JMFSecurity jmfSecurity = null;
    private static boolean securityPrivelege = false;
    private Method[] m = new Method[1];
    private Class[] cl = new Class[1];
    private Object[][] args = new Object[1][0];
    private static final int NOT_SPECIFIED = -1;
    private BufferListener listener = null;
    private int threshold = 0;
    private boolean prebuffering = false;
    private boolean prebufferNotice = false;
    private boolean bufferWhenStopped = true;
    static AudioFormat mpegAudio = new AudioFormat("mpegaudio/rtp");
    static VideoFormat mpegVideo = new VideoFormat("mpeg/rtp");
    static /* synthetic */ Class class$com$sun$media$rtp$util$RTPMediaThread;

    static {
        try {
            jmfSecurity = JMFSecurityManager.getJMFSecurity();
            securityPrivelege = true;
        }
        catch (SecurityException securityException) {}
    }

    public RTPSourceStream(DataSource dataSource) {
        this.dsource = dataSource;
        dataSource.setSourceStream(this);
        this.pktQ = new PktQue(4);
        this.createThread();
    }

    static /* synthetic */ int access$0(RTPSourceStream rTPSourceStream) {
        return rTPSourceStream.DEFAULT_VIDEO_RATE;
    }

    static /* synthetic */ long access$6(RTPSourceStream rTPSourceStream) {
        return rTPSourceStream.lastSeqSent;
    }

    public void add(Buffer buffer, boolean bl, RTPRawReceiver rTPRawReceiver) {
        if (!this.started && !this.bufferWhenStopped) {
            return;
        }
        if (this.lastSeqRecv - buffer.getSequenceNumber() > 256L) {
            this.pktQ.reset();
        }
        this.lastSeqRecv = buffer.getSequenceNumber();
        boolean bl2 = false;
        Object object = this.pktQ;
        synchronized (object) {
            this.pktQ.monitorQueueSize(buffer, rTPRawReceiver);
            if (this.pktQ.noMoreFree()) {
                long l2 = this.pktQ.getFirstSeq();
                if (l2 != -1L && buffer.getSequenceNumber() < l2) {
                    Object var6_8 = null;
                    return;
                }
                this.pktQ.dropPkt();
            }
        }
        if (this.pktQ.totalFree() <= 1) {
            bl2 = true;
        }
        object = this.pktQ.getFree();
        byte[] byArray = (byte[])buffer.getData();
        byte[] byArray2 = (byte[])((Buffer)object).getData();
        if (byArray2 == null || byArray2.length < byArray.length) {
            byArray2 = new byte[byArray.length];
        }
        System.arraycopy(byArray, buffer.getOffset(), byArray2, buffer.getOffset(), buffer.getLength());
        ((Buffer)object).copy(buffer);
        ((Buffer)object).setData(byArray2);
        if (bl2) {
            ((Buffer)object).setFlags(((Buffer)object).getFlags() | 0x2000 | 0x20);
        } else {
            ((Buffer)object).setFlags(((Buffer)object).getFlags() | 0x20);
        }
        this.pktQ.addPkt((Buffer)object);
        PktQue pktQue = this.pktQ;
        synchronized (pktQue) {
            if (this.started && this.prebufferNotice && this.listener != null && this.pktQ.totalPkts() >= this.threshold) {
                this.listener.minThresholdReached(this.dsource);
                this.prebufferNotice = false;
                this.prebuffering = false;
                Object object2 = this.startReq;
                synchronized (object2) {
                    this.startReq.notifyAll();
                }
            }
            if (this.replenish && this.format instanceof AudioFormat) {
                if (this.pktQ.totalPkts() >= this.pktQ.size / 2) {
                    this.replenish = false;
                    this.pktQ.notifyAll();
                }
            } else {
                this.pktQ.notifyAll();
            }
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public void close() {
        if (this.killed) {
            return;
        }
        this.stop();
        this.killed = true;
        Object object = this.startReq;
        synchronized (object) {
            this.startReq.notifyAll();
        }
        object = this.pktQ;
        synchronized (object) {
            this.pktQ.notifyAll();
        }
        this.thread = null;
        if (this.bc != null) {
            this.bc.removeSourceStream(this);
        }
    }

    public void connect() {
        this.killed = false;
        this.createThread();
    }

    private void createThread() {
        Object object;
        if (this.thread != null) {
            return;
        }
        if (jmfSecurity != null) {
            object = null;
            try {
                if (jmfSecurity.getName().startsWith("jmf-security")) {
                    object = "thread";
                    jmfSecurity.requestPermission(this.m, this.cl, this.args, 16);
                    this.m[0].invoke((Object)this.cl[0], this.args[0]);
                    object = "thread group";
                    jmfSecurity.requestPermission(this.m, this.cl, this.args, 32);
                    this.m[0].invoke((Object)this.cl[0], this.args[0]);
                } else if (jmfSecurity.getName().startsWith("internet")) {
                    PolicyEngine.checkPermission((PermissionID)PermissionID.THREAD);
                    PolicyEngine.assertPermission((PermissionID)PermissionID.THREAD);
                }
            }
            catch (Throwable throwable) {
                if (((String)object).endsWith("group")) {
                    jmfSecurity.permissionFailureNotification(32);
                }
                jmfSecurity.permissionFailureNotification(16);
            }
        }
        if (jmfSecurity != null && jmfSecurity.getName().startsWith("jdk12")) {
            try {
                object = jdk12CreateThreadRunnableAction.cons;
                this.thread = (RTPMediaThread)jdk12.doPrivM.invoke((Object)jdk12.ac, ((Constructor)object).newInstance(class$com$sun$media$rtp$util$RTPMediaThread != null ? class$com$sun$media$rtp$util$RTPMediaThread : (class$com$sun$media$rtp$util$RTPMediaThread = RTPSourceStream.class$("com.sun.media.rtp.util.RTPMediaThread")), this));
                this.thread.setName("RTPStream");
                object = jdk12PriorityAction.cons;
                jdk12.doPrivM.invoke((Object)jdk12.ac, ((Constructor)object).newInstance(this.thread, new Integer(MediaThread.getControlPriority())));
            }
            catch (Exception exception) {}
        } else {
            this.thread = new RTPMediaThread(this, "RTPStream");
            this.thread.useControlPriority();
        }
        this.thread.start();
    }

    public Format getFormat() {
        return this.format;
    }

    public void prebuffer() {
        PktQue pktQue = this.pktQ;
        synchronized (pktQue) {
            this.prebuffering = true;
            this.prebufferNotice = true;
        }
    }

    public void read(Buffer buffer) {
        if (this.pktQ.totalPkts() == 0) {
            buffer.setDiscard(true);
            return;
        }
        Buffer buffer2 = this.pktQ.getPkt();
        this.lastSeqSent = buffer2.getSequenceNumber();
        Object object = buffer.getData();
        Object object2 = buffer.getHeader();
        buffer.copy(buffer2);
        buffer2.setData(object);
        buffer2.setHeader(object2);
        this.pktQ.returnFree(buffer2);
        PktQue pktQue = this.pktQ;
        synchronized (pktQue) {
            this.hasRead = true;
            if (this.format instanceof AudioFormat) {
                if (this.pktQ.totalPkts() > 0) {
                    this.pktQ.notifyAll();
                } else {
                    this.replenish = true;
                }
            } else {
                this.pktQ.notifyAll();
            }
        }
    }

    public void reset() {
        this.pktQ.reset();
        this.lastSeqSent = -1L;
    }

    public void run() {
        block8: while (true) {
            try {
                while (true) {
                    Object object = this.startReq;
                    synchronized (object) {
                        while (!(this.started && !this.prebuffering || this.killed)) {
                            this.startReq.wait();
                        }
                    }
                    object = this.pktQ;
                    synchronized (object) {
                        do {
                            if (!this.hasRead && !this.killed) {
                                this.pktQ.wait();
                            }
                            this.hasRead = false;
                        } while (this.pktQ.totalPkts() <= 0 && !this.killed);
                    }
                    if (this.killed) break block8;
                    if (this.handler == null) continue;
                    this.handler.transferData(this);
                }
            }
            catch (InterruptedException interruptedException) {
                Log.error("Thread " + interruptedException.getMessage());
                continue;
            }
            break;
        }
    }

    public void setBufferControl(BufferControl bufferControl) {
        this.bc = (BufferControlImpl)bufferControl;
        this.updateBuffer(this.bc.getBufferLength());
        this.updateThreshold(this.bc.getMinimumThreshold());
    }

    public void setBufferListener(BufferListener bufferListener) {
        this.listener = bufferListener;
    }

    public void setBufferWhenStopped(boolean bl) {
        this.bufferWhenStopped = bl;
    }

    void setContentDescriptor(String string) {
        this.contentDescriptor = new ContentDescriptor(string);
    }

    protected void setFormat(Format format) {
        this.format = format;
    }

    public void setTransferHandler(BufferTransferHandler bufferTransferHandler) {
        this.handler = bufferTransferHandler;
    }

    public void start() {
        Object object = this.startReq;
        synchronized (object) {
            this.started = true;
            this.startReq.notifyAll();
        }
    }

    public void stop() {
        Object object = this.startReq;
        synchronized (object) {
            this.started = false;
            this.prebuffering = false;
            if (!this.bufferWhenStopped) {
                this.reset();
            }
        }
    }

    public long updateBuffer(long l2) {
        return l2;
    }

    public long updateThreshold(long l2) {
        return l2;
    }

    class PktQue {
        int FUDGE = 5;
        int DEFAULT_AUD_PKT_SIZE = 256;
        int DEFAULT_MILLISECS_PER_PKT = 30;
        int DEFAULT_PKTS_TO_BUFFER = 30;
        int MIN_BUF_CHECK = 10;
        int BUF_CHECK_INTERVAL = 7;
        int pktsEst;
        int framesEst = 0;
        int fps = 15;
        int pktsPerFrame = RTPSourceStream.access$0(RTPSourceStream.this);
        int sizePerPkt = this.DEFAULT_AUD_PKT_SIZE;
        int maxPktsToBuffer = 0;
        int sockBufSize = 0;
        int tooMuchBufferingCount = 0;
        long lastPktSeq = 0L;
        long lastCheckTime = 0L;
        Buffer[] fill;
        Buffer[] free;
        int headFill;
        int tailFill;
        int headFree;
        int tailFree;
        protected int size;

        public PktQue(int n2) {
            this.allocBuffers(n2);
        }

        public synchronized void addPkt(Buffer buffer) {
            long l2 = -1L;
            long l3 = -1L;
            long l4 = buffer.getSequenceNumber();
            if (this.moreFilled()) {
                l2 = this.fill[this.headFill].getSequenceNumber();
                int n2 = this.tailFill - 1;
                if (n2 < 0) {
                    n2 = this.size - 1;
                }
                l3 = this.fill[n2].getSequenceNumber();
            }
            if (l2 == -1L && l3 == -1L) {
                this.append(buffer);
            } else if (l4 < l2) {
                this.prepend(buffer);
            } else if (l2 < l4 && l4 < l3) {
                this.insert(buffer);
            } else if (l4 > l3) {
                this.append(buffer);
            } else {
                this.returnFree(buffer);
            }
        }

        private void allocBuffers(int n2) {
            this.fill = new Buffer[n2];
            this.free = new Buffer[n2];
            int n3 = 0;
            while (n3 < n2 - 1) {
                this.free[n3] = new Buffer();
                ++n3;
            }
            this.size = n2;
            this.tailFill = 0;
            this.headFill = 0;
            this.headFree = 0;
            this.tailFree = this.size - 1;
        }

        private synchronized void append(Buffer buffer) {
            this.fill[this.tailFill] = buffer;
            ++this.tailFill;
            if (this.tailFill >= this.size) {
                this.tailFill = 0;
            }
        }

        private synchronized void cutByHalf() {
            int n2 = this.size / 2;
            if (n2 <= 0) {
                return;
            }
            Buffer[] bufferArray = new Buffer[this.size / 2];
            Buffer[] bufferArray2 = new Buffer[this.size / 2];
            int n3 = this.totalPkts();
            int n4 = 0;
            while (n4 < n2 && n4 < n3) {
                bufferArray[n4] = this.get();
                ++n4;
            }
            n3 = n2 - n4 - (this.size - n3 - this.totalFree());
            this.headFill = 0;
            this.tailFill = n4;
            n4 = 0;
            while (n4 <= n3) {
                bufferArray2[n4] = new Buffer();
                ++n4;
            }
            this.headFree = 0;
            this.tailFree = n3;
            this.fill = bufferArray;
            this.free = bufferArray2;
            this.size = n2;
        }

        public synchronized void dropFirstPkt() {
            Buffer buffer = this.get();
            RTPSourceStream.this.lastSeqSent = buffer.getSequenceNumber();
            this.returnFree(buffer);
        }

        public synchronized void dropMpegPkt() {
            Buffer buffer;
            int n2 = this.headFill;
            int n3 = -1;
            int n4 = -1;
            while (n2 != this.tailFill) {
                int n5;
                buffer = this.fill[n2];
                byte[] byArray = (byte[])buffer.getData();
                int n6 = byArray[(n5 = buffer.getOffset()) + 2] & 7;
                if (n6 > 2) {
                    n4 = n2;
                    break;
                }
                if (n6 == 2 && n3 == -1) {
                    n3 = n2;
                }
                if (++n2 < this.size) continue;
                n2 = 0;
            }
            if (n4 == -1) {
                n2 = n3 == -1 ? this.headFill : n3;
            }
            buffer = this.fill[n2];
            if (n2 == 0) {
                RTPSourceStream.this.lastSeqSent = buffer.getSequenceNumber();
            }
            this.removeAt(n2);
        }

        public void dropPkt() {
            while (!this.moreFilled()) {
                try {
                    this.wait();
                }
                catch (Exception exception) {}
            }
            if (RTPSourceStream.this.format instanceof AudioFormat) {
                this.dropFirstPkt();
            } else if (mpegVideo.matches(RTPSourceStream.this.format)) {
                this.dropMpegPkt();
            } else {
                this.dropFirstPkt();
            }
        }

        private synchronized Buffer get() {
            Buffer buffer = this.fill[this.headFill];
            this.fill[this.headFill] = null;
            ++this.headFill;
            if (this.headFill >= this.size) {
                this.headFill = 0;
            }
            return buffer;
        }

        public synchronized long getFirstSeq() {
            if (!this.moreFilled()) {
                return -1L;
            }
            return this.fill[this.headFill].getSequenceNumber();
        }

        public synchronized Buffer getFree() {
            Buffer buffer = this.free[this.headFree];
            this.free[this.headFree] = null;
            ++this.headFree;
            if (this.headFree >= this.size) {
                this.headFree = 0;
            }
            return buffer;
        }

        public synchronized Buffer getPkt() {
            while (!this.moreFilled()) {
                try {
                    this.wait();
                }
                catch (Exception exception) {}
            }
            Buffer buffer = this.get();
            return buffer;
        }

        private synchronized void grow(int n2) {
            Buffer[] bufferArray = new Buffer[n2];
            Buffer[] bufferArray2 = new Buffer[n2];
            int n3 = this.totalPkts();
            int n4 = this.totalFree();
            int n5 = this.headFill;
            int n6 = 0;
            while (n5 != this.tailFill) {
                bufferArray[n6] = this.fill[n5];
                if (++n5 >= this.size) {
                    n5 = 0;
                }
                ++n6;
            }
            this.headFill = 0;
            this.tailFill = n3;
            this.fill = bufferArray;
            n5 = this.headFree;
            n6 = 0;
            while (n5 != this.tailFree) {
                bufferArray2[n6] = this.free[n5];
                if (++n5 >= this.size) {
                    n5 = 0;
                }
                ++n6;
            }
            this.headFree = 0;
            this.tailFree = n4;
            n5 = n2 - this.size;
            while (n5 > 0) {
                bufferArray2[this.tailFree] = new Buffer();
                ++this.tailFree;
                --n5;
            }
            this.free = bufferArray2;
            this.size = n2;
        }

        private synchronized void insert(Buffer buffer) {
            int n2 = this.headFill;
            while (n2 != this.tailFill) {
                if (this.fill[n2].getSequenceNumber() > buffer.getSequenceNumber()) break;
                if (++n2 < this.size) continue;
                n2 = 0;
            }
            if (n2 != this.tailFill) {
                int n3;
                ++this.tailFill;
                if (this.tailFill >= this.size) {
                    this.tailFill = 0;
                }
                int n4 = n3 = this.tailFill;
                do {
                    if (--n3 < 0) {
                        n3 = this.size - 1;
                    }
                    this.fill[n4] = this.fill[n3];
                } while ((n4 = n3) != n2);
                this.fill[n2] = buffer;
            }
        }

        public void monitorQueueSize(Buffer buffer, RTPRawReceiver rTPRawReceiver) {
            this.sizePerPkt = (this.sizePerPkt + buffer.getLength()) / 2;
            if (RTPSourceStream.this.format instanceof VideoFormat) {
                int n2;
                int n3;
                int n4;
                this.pktsEst = this.lastPktSeq + 1L == buffer.getSequenceNumber() ? ++this.pktsEst : 1;
                this.lastPktSeq = buffer.getSequenceNumber();
                if (mpegVideo.matches(RTPSourceStream.this.format)) {
                    byte[] byArray = (byte[])buffer.getData();
                    n3 = byArray[(n4 = buffer.getOffset()) + 2] & 7;
                    if (n3 < 3 && (buffer.getFlags() & 0x800) != 0) {
                        this.pktsPerFrame = (this.pktsPerFrame + this.pktsEst) / 2;
                        this.pktsEst = 0;
                    }
                    this.fps = 30;
                } else if ((buffer.getFlags() & 0x800) != 0) {
                    this.pktsPerFrame = (this.pktsPerFrame + this.pktsEst) / 2;
                    this.pktsEst = 0;
                    ++this.framesEst;
                    long l2 = System.currentTimeMillis();
                    if (l2 - this.lastCheckTime >= 1000L) {
                        this.lastCheckTime = l2;
                        this.fps = (this.fps + this.framesEst) / 2;
                        this.framesEst = 0;
                        if (this.fps > 30) {
                            this.fps = 30;
                        }
                    }
                }
                if (RTPSourceStream.this.bc != null) {
                    n2 = (int)(RTPSourceStream.this.bc.getBufferLength() * (long)this.fps / 1000L);
                    if (n2 <= 0) {
                        n2 = 1;
                    }
                    n2 = this.pktsPerFrame * n2;
                    RTPSourceStream.this.threshold = (int)(RTPSourceStream.this.bc.getMinimumThreshold() * (long)this.fps / 1000L * (long)this.pktsPerFrame);
                    RTPSourceStream.this.threshold;
                    RTPSourceStream.this.threshold = n2 / 2;
                } else {
                    n2 = this.DEFAULT_PKTS_TO_BUFFER;
                }
                this.maxPktsToBuffer = this.maxPktsToBuffer > 0 ? (this.maxPktsToBuffer + n2) / 2 : n2;
                n4 = this.totalPkts();
                if (this.size > this.MIN_BUF_CHECK && n4 < this.size / 4) {
                    if (!RTPSourceStream.this.prebuffering && this.tooMuchBufferingCount++ > this.pktsPerFrame * this.fps * this.BUF_CHECK_INTERVAL) {
                        this.cutByHalf();
                        this.tooMuchBufferingCount = 0;
                    }
                } else if (n4 >= this.size / 2 && this.size < this.maxPktsToBuffer) {
                    n2 = this.size + this.size / 2;
                    if (n2 > this.maxPktsToBuffer) {
                        n2 = this.maxPktsToBuffer;
                    }
                    this.grow(n2 + this.FUDGE);
                    Log.comment("RTP video buffer size: " + this.size + " pkts, " + n2 * this.sizePerPkt + " bytes.\n");
                    this.tooMuchBufferingCount = 0;
                } else {
                    this.tooMuchBufferingCount = 0;
                }
                n3 = n2 * this.sizePerPkt / 2;
                if (rTPRawReceiver != null && n3 > this.sockBufSize) {
                    rTPRawReceiver.setRecvBufSize(n3);
                    this.sockBufSize = rTPRawReceiver.getRecvBufSize() < n3 ? Integer.MAX_VALUE : n3;
                    Log.comment("RTP video socket buffer size: " + rTPRawReceiver.getRecvBufSize() + " bytes.\n");
                }
            } else if (RTPSourceStream.this.format instanceof AudioFormat) {
                if (this.sizePerPkt <= 0) {
                    this.sizePerPkt = this.DEFAULT_AUD_PKT_SIZE;
                }
                if (RTPSourceStream.this.bc != null) {
                    int n5 = mpegAudio.matches(RTPSourceStream.this.format) ? this.sizePerPkt / 4 : this.DEFAULT_MILLISECS_PER_PKT;
                    int n6 = (int)(RTPSourceStream.this.bc.getBufferLength() / (long)n5);
                    RTPSourceStream.this.threshold = (int)(RTPSourceStream.this.bc.getMinimumThreshold() / (long)n5);
                    RTPSourceStream.this.threshold;
                    RTPSourceStream.this.threshold = n6 / 2;
                    if (n6 > this.size) {
                        this.grow(n6);
                        Log.comment("RTP audio buffer size: " + this.size + " pkts, " + n6 * this.sizePerPkt + " bytes.\n");
                    }
                    int n7 = n6 * this.sizePerPkt / 2;
                    if (rTPRawReceiver != null && n7 > this.sockBufSize) {
                        rTPRawReceiver.setRecvBufSize(n7);
                        this.sockBufSize = rTPRawReceiver.getRecvBufSize() < n7 ? Integer.MAX_VALUE : n7;
                        Log.comment("RTP audio socket buffer size: " + rTPRawReceiver.getRecvBufSize() + " bytes.\n");
                    }
                }
            }
        }

        private boolean moreFilled() {
            return this.headFill != this.tailFill;
        }

        private boolean noMoreFree() {
            return this.headFree == this.tailFree;
        }

        private synchronized void prepend(Buffer buffer) {
            --this.headFill;
            if (this.headFill < 0) {
                this.headFill = 0;
            }
            this.fill[this.headFill] = buffer;
        }

        private void removeAt(int n2) {
            Buffer buffer = this.fill[n2];
            if (n2 == this.headFill) {
                ++this.headFill;
                if (this.headFill >= this.size) {
                    this.headFill = 0;
                }
            } else if (n2 == this.tailFill) {
                --this.tailFill;
                if (this.tailFill < 0) {
                    this.tailFill = this.size - 1;
                }
            } else {
                int n3 = n2;
                do {
                    if (--n3 < 0) {
                        n3 = this.size - 1;
                    }
                    this.fill[n2] = this.fill[n3];
                } while ((n2 = n3) != this.headFill);
                ++this.headFill;
                if (this.headFill >= this.size) {
                    this.headFill = 0;
                }
            }
            this.returnFree(buffer);
        }

        public synchronized void reset() {
            while (this.moreFilled()) {
                this.returnFree(this.get());
            }
            this.tooMuchBufferingCount = 0;
            this.notifyAll();
        }

        private synchronized void returnFree(Buffer buffer) {
            this.free[this.tailFree] = buffer;
            ++this.tailFree;
            if (this.tailFree >= this.size) {
                this.tailFree = 0;
            }
        }

        public int totalFree() {
            return this.tailFree >= this.headFree ? this.tailFree - this.headFree : this.size - (this.headFree - this.tailFree);
        }

        public int totalPkts() {
            return this.tailFill >= this.headFill ? this.tailFill - this.headFill : this.size - (this.headFill - this.tailFill);
        }
    }
}

