/*
 * Decompiled with CFR 0.152.
 */
package quicktime.app.actions;

import quicktime.QTException;
import quicktime.QTRuntimeException;
import quicktime.QTSession;
import quicktime.app.actions.PeriodicAction;
import quicktime.app.actions.Targetable;
import quicktime.app.actions.TransformMatrix;
import quicktime.app.display.QTDisplaySpace;
import quicktime.app.display.QTDrawable;
import quicktime.app.image.Transformable;
import quicktime.qd.QDDimension;
import quicktime.qd.QDRect;
import quicktime.std.image.Matrix;

public class MatrixAction
extends PeriodicAction
implements Targetable {
    protected static final int kLeftSide = 1;
    protected static final int kRightSide = 16;
    protected static final int kTopSide = 256;
    protected static final int kBottomSide = 4096;
    protected Transformable target;
    protected TransformMatrix transMatrix;
    protected boolean doConstraintBoundsTesting = false;
    private boolean forwards = true;
    private QTDrawable space;
    private boolean consReached = false;

    protected MatrixAction(int n, int n2, QTDrawable qTDrawable, Transformable transformable) throws QTException {
        super(n, n2);
        this.target = transformable;
        this.space = qTDrawable;
    }

    public MatrixAction(int n, int n2, QTDisplaySpace qTDisplaySpace, Transformable transformable, TransformMatrix transformMatrix) throws QTException {
        super(n, n2);
        this.target = transformable;
        this.space = qTDisplaySpace;
        this.transMatrix = transformMatrix;
        this.transMatrix.initialize(qTDisplaySpace, transformable);
    }

    public void setTarget(Object object) {
        this.target = (Transformable)object;
    }

    public Object getTarget() {
        return this.target;
    }

    public QTDrawable getSpace() {
        return this.space;
    }

    public void setSpace(QTDrawable qTDrawable) {
        this.space = qTDrawable;
    }

    protected void doAction(float f, int n) throws QTException {
        this.consReached = false;
        if (f > 0.0f && !this.forwards || f < 0.0f && this.forwards) {
            boolean bl = this.forwards = f > 0.0f;
            if (this.transMatrix != null) {
                this.transMatrix.flipTransformationSettings();
            } else {
                this.rateDirectionChanged(this.forwards);
            }
        }
        if (this.transMatrix != null) {
            this.consReached = this.transMatrix.transformTarget();
        } else {
            Matrix matrix = this.target.getMatrix().copy();
            this.transformMatrix(matrix);
            if (this.doConstraintBoundsTesting) {
                Matrix matrix2 = new Matrix();
                this.space.getMatrix().inverse(matrix2);
                QDRect qDRect = this.space.getDisplayBounds().copy();
                matrix2.transformRect(qDRect);
                QDDimension qDDimension = this.target.getOriginalSize();
                float f2 = matrix.getTx();
                float f3 = matrix.getTy();
                int n2 = qDRect.getX();
                int n3 = qDRect.getWidth() - qDDimension.getWidth();
                int n4 = qDRect.getY();
                int n5 = qDRect.getHeight() - qDDimension.getHeight();
                switch (matrix.getType()) {
                    case 0: 
                    case 1: {
                        break;
                    }
                    default: {
                        QDRect qDRect2 = new QDRect(0, 0, qDDimension.getWidth(), qDDimension.getHeight());
                        matrix.transformRect(qDRect2);
                        qDDimension.setWidth(qDRect2.getWidth());
                        qDDimension.setHeight(qDRect2.getHeight());
                        n2 = (int)(matrix.getTx() - (float)qDRect2.getX() + 0.5f);
                        f2 -= (float)n2;
                        n4 = (int)(matrix.getTy() - (float)qDRect2.getY() + 0.5f);
                        f3 -= (float)n4;
                        n5 = qDRect.getHeight() - qDDimension.getHeight() + n4;
                        n3 = qDRect.getWidth() - qDDimension.getWidth() + n2;
                    }
                }
                if (f2 < (float)qDRect.getX()) {
                    matrix.setTx(n2);
                    this.boundsReached(1);
                    this.consReached = true;
                } else if (f2 + (float)qDDimension.getWidth() > (float)qDRect.getWidth()) {
                    matrix.setTx(n3);
                    this.boundsReached(16);
                    this.consReached = true;
                }
                if (f3 < (float)qDRect.getY()) {
                    matrix.setTy(n4);
                    this.boundsReached(256);
                    this.consReached = true;
                } else if (f3 + (float)qDDimension.getHeight() > (float)qDRect.getHeight()) {
                    matrix.setTy(n5);
                    this.boundsReached(4096);
                    this.consReached = true;
                }
            }
            this.setTargetMatrix(matrix);
        }
    }

    protected void rateDirectionChanged(boolean bl) throws QTException {
    }

    protected void transformMatrix(Matrix matrix) throws QTException {
    }

    protected void boundsReached(int n) {
    }

    protected void setTargetMatrix(Matrix matrix) throws QTException {
        this.target.setMatrix(matrix);
    }

    protected boolean constraintReached() {
        return this.consReached;
    }

    public String toString() {
        return this.getClass().getName() + "[target=" + this.target + "]";
    }

    public boolean equals(Object object) {
        if (object instanceof MatrixAction) {
            MatrixAction matrixAction = (MatrixAction)object;
            if (this.transMatrix != null) {
                if (!this.transMatrix.equals(matrixAction.transMatrix)) {
                    return false;
                }
                return super.equals(object);
            }
            if (!this.target.equals(matrixAction.target)) {
                return false;
            }
            return super.equals(object);
        }
        return false;
    }

    static {
        if (QTSession.isCurrentOS(4) && QTSession.getJavaVersion() >= 65540) {
            throw new QTRuntimeException("Unsupported on Mac OS X and Java 1.4 and higher.");
        }
    }
}

