/*
 * Decompiled with CFR 0.152.
 */
package quicktime.app.anim;

import java.util.Enumeration;
import java.util.Hashtable;
import quicktime.QTException;
import quicktime.QTRuntimeException;
import quicktime.QTSession;
import quicktime.app.anim.SWCompositor;
import quicktime.app.anim.TwoDSprite;
import quicktime.app.anim.TwoDSpriteInfo;
import quicktime.app.display.Layerable;
import quicktime.app.image.Compositable;
import quicktime.app.image.ImageSpec;
import quicktime.app.image.Transformable;
import quicktime.app.spaces.Protocol;
import quicktime.qd.QDColor;
import quicktime.qd.QDGraphics;
import quicktime.std.image.GraphicsMode;
import quicktime.std.image.Matrix;

public class Compositor
extends SWCompositor {
    private static Protocol defaultProtocol;
    protected Hashtable membersTable = new Hashtable();
    protected Hashtable spritesTable = new Hashtable();

    private static Protocol makeP() {
        try {
            return new Protocol(Class.forName("quicktime.app.image.ImageSpec"));
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new QTRuntimeException(classNotFoundException.getMessage());
        }
    }

    public Compositor(QDGraphics qDGraphics, QDColor qDColor) throws QTException {
        this(qDGraphics, qDColor, null, 10, 1, defaultProtocol);
    }

    public Compositor(QDGraphics qDGraphics, QDColor qDColor, QDGraphics qDGraphics2) throws QTException {
        this(qDGraphics, qDColor, qDGraphics2, 10, 1, defaultProtocol);
    }

    public Compositor(QDGraphics qDGraphics, QDColor qDColor, int n, int n2) throws QTException {
        this(qDGraphics, qDColor, null, n, n2, defaultProtocol);
    }

    public Compositor(QDGraphics qDGraphics, QDColor qDColor, QDGraphics qDGraphics2, int n, int n2) throws QTException {
        this(qDGraphics, qDColor, qDGraphics2, n, n2, defaultProtocol);
    }

    protected Compositor(QDGraphics qDGraphics, QDColor qDColor, QDGraphics qDGraphics2, int n, int n2, Protocol protocol) throws QTException {
        super(qDGraphics, qDColor, qDGraphics2, n, n2, protocol);
    }

    public Enumeration members() {
        return this.membersTable.keys();
    }

    public Enumeration sprites() {
        return this.spritesTable.keys();
    }

    public boolean isEmpty() {
        return this.membersTable.isEmpty();
    }

    public TwoDSprite getMemberSprite(Object object) {
        if (object instanceof TwoDSprite && this.spritesTable.containsKey(object)) {
            return (TwoDSprite)object;
        }
        Object v = this.membersTable.get(object);
        return v != null ? (TwoDSprite)v : null;
    }

    public Object getSpriteMember(TwoDSprite twoDSprite) {
        return this.spritesTable.get(twoDSprite);
    }

    public boolean addMember(Object object) throws QTException {
        int n = 1;
        if (object instanceof Layerable) {
            n = ((Layerable)object).getLayer();
        }
        boolean bl = true;
        if (object instanceof TwoDSprite) {
            bl = ((TwoDSprite)object).getVisible();
        } else if (object instanceof TwoDSpriteInfo) {
            bl = ((TwoDSpriteInfo)object).getVisible();
        }
        return this.addMember(object, n, bl);
    }

    public boolean addMember(Object object, int n) throws QTException {
        boolean bl = true;
        if (object instanceof TwoDSprite) {
            bl = ((TwoDSprite)object).getVisible();
        } else if (object instanceof TwoDSpriteInfo) {
            bl = ((TwoDSpriteInfo)object).getVisible();
        }
        return this.addMember(object, n, bl);
    }

    public boolean addMember(Object object, int n, boolean bl) throws QTException {
        if (!this.isAppropriate(object)) {
            return false;
        }
        if (this.hasMember(object)) {
            return true;
        }
        TwoDSprite twoDSprite = null;
        if (object instanceof TwoDSprite) {
            twoDSprite = (TwoDSprite)object;
            twoDSprite.setLayer(n);
            twoDSprite.setVisible(bl);
        } else {
            ImageSpec imageSpec = (ImageSpec)object;
            GraphicsMode graphicsMode = null;
            if (object instanceof Compositable) {
                graphicsMode = ((Compositable)object).getGraphicsMode();
            }
            Matrix matrix = object instanceof Transformable ? ((Transformable)object).getMatrix() : new Matrix();
            twoDSprite = new TwoDSprite(imageSpec, matrix, bl, n, graphicsMode);
        }
        this.membersTable.put(object, twoDSprite);
        this.spritesTable.put(twoDSprite, object);
        this.postProcessAdd(object, twoDSprite);
        return true;
    }

    public int size() {
        return this.membersTable.size();
    }

    public int getFrontLayer() throws QTException {
        Enumeration enumeration = this.sprites();
        int n = Integer.MAX_VALUE;
        while (enumeration.hasMoreElements()) {
            TwoDSprite twoDSprite = (TwoDSprite)enumeration.nextElement();
            int n2 = twoDSprite.getLayer();
            if (n2 >= n) continue;
            n = n2;
        }
        return n;
    }

    public int getBackLayer() throws QTException {
        Enumeration enumeration = this.sprites();
        int n = Integer.MIN_VALUE;
        while (enumeration.hasMoreElements()) {
            TwoDSprite twoDSprite = (TwoDSprite)enumeration.nextElement();
            int n2 = twoDSprite.getLayer();
            if (n2 <= n) continue;
            n = n2;
        }
        return n;
    }

    public void removeMember(Object object) throws QTException {
        if (this.membersTable.containsKey(object)) {
            TwoDSprite twoDSprite = (TwoDSprite)this.membersTable.remove(object);
            this.spritesTable.remove(twoDSprite);
            this.postProcessRemove(object, twoDSprite);
        }
    }

    static {
        if (QTSession.isCurrentOS(4) && QTSession.getJavaVersion() >= 65540) {
            throw new QTRuntimeException("Unsupported on Mac OS X and Java 1.4 and higher.");
        }
        defaultProtocol = Compositor.makeP();
    }
}

