/*
 * Decompiled with CFR 0.152.
 */
package quicktime.app.anim;

import java.awt.Dimension;
import java.util.Enumeration;
import java.util.Vector;
import quicktime.QTException;
import quicktime.QTRuntimeException;
import quicktime.QTSession;
import quicktime.app.RecordMovie;
import quicktime.app.actions.Invalidator;
import quicktime.app.actions.Notifier;
import quicktime.app.actions.TickleList;
import quicktime.app.anim.TwoDSprite;
import quicktime.app.display.DrawingListener;
import quicktime.app.display.DrawingNotifier;
import quicktime.app.display.Layerable;
import quicktime.app.display.QTDisplaySpace;
import quicktime.app.image.Compositable;
import quicktime.app.image.DynamicImage;
import quicktime.app.image.Transformable;
import quicktime.app.spaces.Protocol;
import quicktime.app.spaces.SimpleSpace;
import quicktime.app.time.Timer;
import quicktime.qd.QDColor;
import quicktime.qd.QDDimension;
import quicktime.qd.QDGraphics;
import quicktime.qd.QDPoint;
import quicktime.qd.QDRect;
import quicktime.qd.Region;
import quicktime.std.StdQTException;
import quicktime.std.anim.Sprite;
import quicktime.std.anim.SpriteWorld;
import quicktime.std.image.GraphicsMode;
import quicktime.std.image.ImageDescription;
import quicktime.std.image.Matrix;
import quicktime.util.EncodedImage;
import quicktime.util.RawEncodedImage;

public abstract class SWCompositor
extends SimpleSpace
implements QTDisplaySpace,
DynamicImage,
DrawingNotifier {
    private static final boolean debug = false;
    public int hitTestFlag = 10;
    private QDPoint hitTestPoint = new QDPoint(0, 0);
    private QDGraphics mBGPict;
    private QDGraphics mSpriteGWorld;
    private Region mClip = null;
    private QDColor mBGColor;
    private QDGraphics mCurrentGrafPort = QDGraphics.scratch;
    private QDRect bnds;
    private GraphicsMode gMode;
    private Matrix savedMatrix = new Matrix();
    private ASpriteWorld mSpriteWorld = null;
    public int taskFlag = 0;
    private int lastDrawRequiresDrawing = 0;
    private TickleList invalList;
    private RecordMovie rm;
    private boolean recordMovie = false;
    TwoDSprite spritePresenter;
    private long startTime = 0L;
    private int frameCount = 0;
    private SWCompositor parent;
    private boolean autoRedraw = true;
    private Vector listenerList;

    protected SWCompositor(QDGraphics qDGraphics, QDColor qDColor, QDGraphics qDGraphics2, int n, int n2, Protocol protocol) throws QTException {
        super(protocol, n, n2);
        this.mSpriteGWorld = qDGraphics;
        this.mBGColor = qDColor;
        this.mBGPict = qDGraphics2;
        this.bnds = qDGraphics.getPortRect();
    }

    SpriteWorld getSpriteWorld() {
        return this.mSpriteWorld;
    }

    public void resetStatistics() {
        this.startTime = System.currentTimeMillis();
        this.frameCount = 0;
    }

    public float getStatistics() {
        if (this.getTimer().getRate() == 0.0f || this.mSpriteWorld == null) {
            return 0.0f;
        }
        if (this.frameCount == 0) {
            return 0.0f;
        }
        return 1000.0f / (float)((System.currentTimeMillis() - this.startTime) / (long)this.frameCount);
    }

    public Enumeration getInvalidatorList() {
        return this.invalList == null ? null : this.invalList.members();
    }

    public synchronized Invalidator getMemberInvalidator(Object object) {
        if (!this.hasMember(object)) {
            return null;
        }
        if (this.invalList == null) {
            return null;
        }
        Enumeration enumeration = this.invalList.members();
        while (enumeration.hasMoreElements()) {
            Invalidator invalidator = (Invalidator)enumeration.nextElement();
            if (!invalidator.getTarget().equals(object)) continue;
            return invalidator;
        }
        return null;
    }

    public void setRecordMovie(RecordMovie recordMovie) throws QTException {
        this.rm = recordMovie;
        recordMovie.addedToSource(this.mSpriteGWorld);
        this.recordMovie = true;
    }

    public boolean hasRecordMovie() {
        return this.recordMovie;
    }

    public ImageDescription getDescription() throws QTException {
        return new ImageDescription(this.mSpriteGWorld.getPixMap());
    }

    public EncodedImage getImage() throws QTException, IndexOutOfBoundsException {
        return RawEncodedImage.fromPixMap(this.mSpriteGWorld.getPixMap());
    }

    public SWCompositor getParent() {
        return this.parent;
    }

    public Matrix getMatrix() throws StdQTException {
        return this.mSpriteWorld != null ? this.mSpriteWorld.getMatrix() : this.savedMatrix;
    }

    public void setMatrix(Matrix matrix) throws QTException {
        if (this.mSpriteWorld != null) {
            this.mSpriteWorld.setMatrix(matrix);
        }
    }

    public Dimension getInitialSize() throws QTException {
        QDRect qDRect = this.mSpriteGWorld.getPortRect();
        return new Dimension(qDRect.getWidth(), qDRect.getHeight());
    }

    public QDDimension getOriginalSize() throws QTException {
        QDRect qDRect = this.mSpriteGWorld.getPortRect();
        return new QDDimension(qDRect.getWidth(), qDRect.getHeight());
    }

    public QDGraphics getGWorld() {
        return this.mCurrentGrafPort;
    }

    public synchronized void setGWorld(QDGraphics qDGraphics) throws QTException {
        if (qDGraphics == null) {
            qDGraphics = QDGraphics.scratch;
        }
        if (qDGraphics.equals(this.mCurrentGrafPort)) {
            return;
        }
        this.getTimer().setActive(false);
        if (this.mSpriteWorld == null && !QDGraphics.scratch.equals(qDGraphics)) {
            this.mSpriteWorld = new ASpriteWorld(qDGraphics, this.mSpriteGWorld, this.mBGColor, this.mBGPict, this);
            if (this.gMode != null) {
                this.mSpriteWorld.setGraphicsMode(this.gMode);
            }
            this.setMatrix(this.savedMatrix);
            this.createMembers();
        } else if (QDGraphics.scratch.equals(qDGraphics)) {
            this.saveMembers();
            this.savedMatrix = this.mSpriteWorld.getMatrix();
            this.mSpriteWorld._cleanup();
            this.mSpriteWorld = null;
        } else {
            this.saveMembers();
            this.savedMatrix = this.mSpriteWorld.getMatrix();
            this.mSpriteWorld._cleanup();
            this.mSpriteWorld = null;
            this.mSpriteWorld = new ASpriteWorld(qDGraphics, this.mSpriteGWorld, this.mBGColor, this.mBGPict, this);
            if (this.gMode != null) {
                this.mSpriteWorld.setGraphicsMode(this.gMode);
            }
            this.setMatrix(this.savedMatrix);
            this.createMembers();
        }
        this.mCurrentGrafPort = qDGraphics;
        this.getTimer().setActive(this.mSpriteWorld != null);
    }

    public synchronized void setDisplayBounds(QDRect qDRect) throws StdQTException {
        if (this.mSpriteWorld != null) {
            this.mSpriteWorld.setBounds(qDRect);
        } else {
            this.savedMatrix.setTx(qDRect.getX());
            this.savedMatrix.setTy(qDRect.getY());
            QDRect qDRect2 = this.mSpriteGWorld.getPortRect();
            this.savedMatrix.setSx((float)qDRect.getWidth() / (float)qDRect2.getWidth());
            this.savedMatrix.setSy((float)qDRect.getHeight() / (float)qDRect2.getHeight());
        }
        this.bnds = qDRect;
    }

    public void setLocation(int n, int n2) throws QTException {
        QDRect qDRect = this.getDisplayBounds();
        qDRect.setX(n);
        qDRect.setY(n2);
        this.setDisplayBounds(qDRect);
    }

    public QDRect getDisplayBounds() throws QTException {
        if (this.mSpriteWorld != null) {
            return this.mSpriteWorld.getBounds();
        }
        return this.bnds;
    }

    public final void redraw(Region region) throws QTException {
        if (this.mSpriteWorld != null) {
            QDRect qDRect = null;
            if (region != null) {
                QDRect qDRect2 = region.getRgnBBox();
                qDRect = qDRect2.equals(qDRect = qDRect2.union(this.getDisplayBounds())) ? null : qDRect2.intersection(this.getDisplayBounds());
            }
            this.mSpriteWorld.invalidate(qDRect);
            this.idle();
        }
    }

    public boolean isAutoRedrawing() {
        return this.autoRedraw;
    }

    public void setAutoRedrawing(boolean bl) {
        this.autoRedraw = bl;
    }

    protected void idle() throws QTException {
        this.mSpriteWorld._idle(this.taskFlag);
        if (this.spritePresenter != null && this.lastDrawRequiresDrawing != 0) {
            this.lastDrawRequiresDrawing = 0;
            this.spritePresenter.invalidate();
        }
    }

    public Object hitTest(int n, int n2) throws QTException {
        if (this.mSpriteWorld != null) {
            this.hitTestPoint.setX(n);
            this.hitTestPoint.setY(n2);
            if (this.getClip() != null && !this.getClip().pointIn(this.hitTestPoint)) {
                return null;
            }
            Sprite sprite = this.mSpriteWorld.hitTest(this.hitTestFlag, this.hitTestPoint);
            if (sprite == null) {
                return null;
            }
            Enumeration enumeration = this.sprites();
            while (enumeration.hasMoreElements()) {
                TwoDSprite twoDSprite = (TwoDSprite)enumeration.nextElement();
                if (!sprite.equals(twoDSprite.getSprite())) continue;
                return twoDSprite;
            }
        }
        return null;
    }

    public void setClip(Region region) throws QTException {
        if (this.mSpriteWorld != null) {
            this.mSpriteWorld.setClip(region);
        }
        this.mClip = region;
    }

    public Region getClip() {
        return this.mClip;
    }

    public boolean tickle(float f, int n) throws QTException {
        Timer timer = this.getTimer();
        if (timer.isActive() && this.mSpriteWorld != null) {
            super.tickle(f, n);
            if (this.invalList != null) {
                this.invalList.tickle(f, n);
            }
            this.idle();
            ++this.frameCount;
            return this.mSpriteWorld != null;
        }
        return false;
    }

    public synchronized void removedFromCompositor(SWCompositor sWCompositor) throws QTException {
        this.spritePresenter.spriteIsCompositor = null;
        this.spritePresenter = null;
        this.parent = null;
        this.setGWorld(QDGraphics.scratch);
        this.taskFlag = 0;
    }

    public Invalidator addedToCompositor(SWCompositor sWCompositor, TwoDSprite twoDSprite) throws QTException {
        if (this.spritePresenter != null) {
            this.removedFromCompositor(null);
        }
        this.setGWorld(QDGraphics.validScratch);
        this.taskFlag = 1;
        this.spritePresenter = twoDSprite;
        this.spritePresenter.spriteIsCompositor = this;
        this.parent = sWCompositor;
        return null;
    }

    public GraphicsMode getGraphicsMode() {
        return this.gMode;
    }

    public void setGraphicsMode(GraphicsMode graphicsMode) throws QTException {
        if (this.mSpriteWorld != null) {
            this.mSpriteWorld.setGraphicsMode(graphicsMode);
        }
        this.gMode = graphicsMode;
    }

    public abstract TwoDSprite getMemberSprite(Object var1);

    public abstract Enumeration sprites();

    public abstract Object getSpriteMember(TwoDSprite var1);

    public Compositable getCompositable(Object object) {
        return this.getMemberSprite(object);
    }

    public Layerable getLayerable(Object object) {
        return this.getMemberSprite(object);
    }

    public Transformable getTransformable(Object object) {
        return this.getMemberSprite(object);
    }

    protected synchronized void postProcessAdd(Object object, TwoDSprite twoDSprite) throws QTException {
        this.doDynamicImageAdd(object, twoDSprite);
        twoDSprite.setParent(this);
        if (object instanceof Notifier) {
            Notifier notifier = (Notifier)object;
            notifier.addNotifyListener(twoDSprite);
        }
        this.memberAdded(object);
        if (this.mSpriteWorld != null) {
            twoDSprite.createSprite(this.mSpriteWorld);
            if (this.autoRedraw) {
                this.idle();
            }
        }
    }

    protected synchronized void postProcessRemove(Object object, TwoDSprite twoDSprite) throws QTException {
        this.doDynamicImageRemove(object, twoDSprite);
        this.memberRemoved(object);
        twoDSprite.remove();
        twoDSprite.setParent(null);
        if (this.autoRedraw && this.mSpriteWorld != null) {
            this.idle();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void saveMembers() throws QTException {
        boolean bl = this.autoRedraw;
        try {
            this.autoRedraw = false;
            Enumeration enumeration = this.sprites();
            while (enumeration.hasMoreElements()) {
                TwoDSprite twoDSprite = (TwoDSprite)enumeration.nextElement();
                this.doDynamicImageRemove(this.getSpriteMember(twoDSprite), twoDSprite);
                twoDSprite.removeNotify();
            }
            Object var5_4 = null;
            this.autoRedraw = bl;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            this.autoRedraw = bl;
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void createMembers() throws QTException {
        boolean bl = this.autoRedraw;
        try {
            this.autoRedraw = false;
            Enumeration enumeration = this.sprites();
            while (enumeration.hasMoreElements()) {
                TwoDSprite twoDSprite = (TwoDSprite)enumeration.nextElement();
                twoDSprite.createSprite(this.mSpriteWorld);
                this.doDynamicImageAdd(this.getSpriteMember(twoDSprite), twoDSprite);
            }
            Object var5_4 = null;
            this.autoRedraw = bl;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            this.autoRedraw = bl;
            throw throwable;
        }
    }

    public String toString() {
        try {
            return this.getClass().getName() + "[sw=" + this.mSpriteWorld + ",timer=" + this.getTimer() + ",grafPort=" + this.getGWorld() + ",bounds=" + this.getDisplayBounds() + "]";
        }
        catch (QTException qTException) {
            return this.getClass().getName();
        }
    }

    private void doDynamicImageAdd(Object object, TwoDSprite twoDSprite) throws QTException {
        Invalidator invalidator;
        if (this.mSpriteWorld != null && object instanceof DynamicImage && (invalidator = ((DynamicImage)object).addedToCompositor(this, twoDSprite)) != null) {
            if (this.invalList == null) {
                this.invalList = new TickleList();
            }
            this.invalList.addMember(invalidator);
        }
    }

    private void doDynamicImageRemove(Object object, TwoDSprite twoDSprite) throws QTException {
        if (this.mSpriteWorld != null && object instanceof DynamicImage) {
            ((DynamicImage)object).removedFromCompositor(this);
            if (this.invalList != null) {
                Enumeration enumeration = this.invalList.members();
                while (enumeration.hasMoreElements()) {
                    Invalidator invalidator = (Invalidator)enumeration.nextElement();
                    if (!invalidator.getTarget().equals(twoDSprite)) continue;
                    this.invalList.removeMember(invalidator);
                    break;
                }
                if (this.invalList.isEmpty()) {
                    this.invalList = null;
                }
            }
        }
    }

    public synchronized void addDrawingListener(DrawingListener drawingListener) {
        if (this.listenerList == null) {
            this.listenerList = new Vector();
        }
        if (this.listenerList.contains(drawingListener)) {
            return;
        }
        this.listenerList.addElement(drawingListener);
    }

    public synchronized void removeDrawingListener(DrawingListener drawingListener) {
        this.listenerList.removeElement(drawingListener);
        if (this.listenerList.isEmpty()) {
            this.listenerList = null;
        }
    }

    static {
        if (QTSession.isCurrentOS(4) && QTSession.getJavaVersion() >= 65540) {
            throw new QTRuntimeException("Unsupported on Mac OS X and Java 1.4 and higher.");
        }
    }

    final class ASpriteWorld
    extends SpriteWorld {
        SWCompositor theCompositor;

        ASpriteWorld(QDGraphics qDGraphics, QDGraphics qDGraphics2, QDColor qDColor, QDGraphics qDGraphics3, SWCompositor sWCompositor2) throws QTException {
            super(qDGraphics, qDGraphics2, qDColor, qDGraphics3);
            this.theCompositor = sWCompositor2;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void _idle(int n) throws QTException {
            SWCompositor.this.lastDrawRequiresDrawing = this.idle(n);
            if (SWCompositor.this.recordMovie) {
                SWCompositor.this.recordMovie = SWCompositor.this.rm.frameReady();
                if (!SWCompositor.this.recordMovie) {
                    SWCompositor.this.rm = null;
                }
            }
            if (SWCompositor.this.listenerList != null) {
                SWCompositor sWCompositor = SWCompositor.this;
                synchronized (sWCompositor) {
                    int n2 = 0;
                    while (n2 < SWCompositor.this.listenerList.size()) {
                        ((DrawingListener)SWCompositor.this.listenerList.elementAt(n2)).drawingComplete(this.theCompositor);
                        ++n2;
                    }
                }
            }
        }

        void _cleanup() {
            try {
                this.finalize();
            }
            catch (Throwable throwable) {
                QTRuntimeException.handleOrThrow(new QTRuntimeException(throwable.getMessage()), this, "finalize");
            }
        }
    }
}

