/*
 * Decompiled with CFR 0.152.
 */
package quicktime.app.anim;

import java.awt.event.MouseEvent;
import java.util.Enumeration;
import quicktime.QTException;
import quicktime.QTRuntimeException;
import quicktime.QTSession;
import quicktime.app.actions.MouseController;
import quicktime.app.actions.MouseResponder;
import quicktime.app.anim.SWCompositor;
import quicktime.app.anim.TwoDSprite;
import quicktime.app.spaces.Space;
import quicktime.qd.QDPoint;
import quicktime.qd.QDRect;

public class SWController
extends MouseController {
    private SWCompositor sd;
    private boolean isActive;
    private int flags;
    private QDPoint p = new QDPoint(0, 0);

    public SWController(MouseResponder mouseResponder, boolean bl) {
        this(mouseResponder, bl, 10);
    }

    public SWController(MouseResponder mouseResponder, boolean bl, int n) {
        super(mouseResponder, bl);
        this.flags = n;
    }

    public Space getSpace() {
        return this.sd;
    }

    protected void setTargetSpace(Space space) {
        this.sd = (SWCompositor)space;
    }

    public int getFlags() {
        return this.flags;
    }

    public void setFlags(int n) {
        this.flags = n;
    }

    protected void deactivateResponder() {
        this.isActive = false;
        super.deactivateResponder();
    }

    protected void responderActivated() {
        this.isActive = true;
    }

    protected void setTranslation() {
        SWCompositor sWCompositor;
        SWCompositor sWCompositor2 = sWCompositor = this.sd;
        this.xLocationOffset = 0;
        this.yLocationOffset = 0;
        try {
            while (sWCompositor != null) {
                sWCompositor2 = sWCompositor;
                QDRect qDRect = sWCompositor2.getDisplayBounds();
                this.xLocationOffset += qDRect.getX();
                this.yLocationOffset += qDRect.getY();
                sWCompositor = sWCompositor2.getParent();
            }
        }
        catch (QTException qTException) {
            QTRuntimeException.handleOrThrow(new QTRuntimeException(qTException), sWCompositor2, "getDisplayBounds");
        }
    }

    protected Object getSelected(MouseEvent mouseEvent) throws QTException {
        QDRect qDRect = this.sd.getDisplayBounds();
        this.p.setX(mouseEvent.getX() + qDRect.getX());
        this.p.setY(mouseEvent.getY() + qDRect.getY());
        if (!qDRect.inside(this.p.getX(), this.p.getY())) {
            return null;
        }
        if (this.isWholespace()) {
            this.sd.hitTestFlag = this.flags;
            return this.sd.hitTest(this.p.getX(), this.p.getY());
        }
        TwoDSprite twoDSprite = null;
        Enumeration enumeration = this.members();
        while (enumeration.hasMoreElements()) {
            this.p.setX(mouseEvent.getX());
            this.p.setY(mouseEvent.getY());
            TwoDSprite twoDSprite2 = (TwoDSprite)enumeration.nextElement();
            if (!twoDSprite2.hitTest(this.flags, this.p)) continue;
            if (twoDSprite != null) {
                if (twoDSprite2.getLayer() >= twoDSprite.getLayer()) continue;
                twoDSprite = twoDSprite2;
                continue;
            }
            twoDSprite = twoDSprite2;
        }
        return twoDSprite;
    }

    static {
        if (QTSession.isCurrentOS(4) && QTSession.getJavaVersion() >= 65540) {
            throw new QTRuntimeException("Unsupported on Mac OS X and Java 1.4 and higher.");
        }
    }
}

