/*
 * Decompiled with CFR 0.152.
 */
package quicktime.app.display;

import java.awt.Dimension;
import java.util.Enumeration;
import quicktime.QTException;
import quicktime.QTRuntimeException;
import quicktime.QTSession;
import quicktime.app.display.GroupDrawable;
import quicktime.app.display.GroupMember;
import quicktime.app.display.Layerable;
import quicktime.app.display.QTDrawable;
import quicktime.app.spaces.Protocol;
import quicktime.jdirect.QTNative;
import quicktime.qd.QDColor;
import quicktime.qd.QDDimension;
import quicktime.qd.QDGraphics;
import quicktime.qd.QDRect;
import quicktime.qd.Region;
import quicktime.std.image.Matrix;
import quicktime.util.QTHandle;
import quicktime.util.QTUtils;

public class DirectGroup
extends GroupDrawable {
    private static Protocol p;
    private boolean doMemCleanup;
    private boolean redoCachedMembersClip = false;

    private static Protocol makeP() {
        try {
            return new Protocol(Class.forName("quicktime.app.display.QTDrawable"));
        }
        catch (Exception exception) {
            throw new QTRuntimeException(exception.getMessage());
        }
    }

    public DirectGroup(Dimension dimension, QDColor qDColor) throws QTException {
        this(new QDDimension(dimension.width, dimension.height), qDColor, 10, 1, p);
    }

    public DirectGroup(QDDimension qDDimension, QDColor qDColor) throws QTException {
        this(qDDimension, qDColor, 10, 1, p);
    }

    protected DirectGroup(QDDimension qDDimension, QDColor qDColor, int n, int n2, Protocol protocol) throws QTException {
        super(qDDimension, qDColor, n, n2, protocol);
    }

    public boolean isAppropriate(Object object) {
        return this.getProtocol().passProtocol(object) && !(object instanceof GroupDrawable);
    }

    public boolean addMember(Object object, int n, float f, float f2) throws QTException {
        if (!this.isAppropriate(object)) {
            return false;
        }
        this.setAlignedMemberLocation((QTDrawable)object, f, f2);
        this._addQTDrawable(new GroupMember(this, (QTDrawable)object, n));
        return true;
    }

    public boolean addMember(Object object, int n) throws QTException {
        if (!this.isAppropriate(object)) {
            return false;
        }
        QTDrawable qTDrawable = (QTDrawable)object;
        this._addQTDrawable(new GroupMember(this, qTDrawable, n));
        return true;
    }

    public boolean addMember(Object object) throws QTException {
        int n = 1;
        if (object instanceof Layerable) {
            n = ((Layerable)object).getLayer();
        }
        return this.addMember((QTDrawable)object, n);
    }

    public void setGWorld(QDGraphics qDGraphics) throws QTException {
        super.setGWorld(qDGraphics);
        Enumeration enumeration = this.vec.elements();
        while (enumeration.hasMoreElements()) {
            GroupMember groupMember = (GroupMember)enumeration.nextElement();
            groupMember.drawer.setGWorld(this.port);
        }
        if (this.visible) {
            this.setClip(null);
        }
    }

    public void setDisplayBounds(QDRect qDRect) throws QTException {
        super.setDisplayBounds(qDRect);
        this.setClip(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void redrawMember(QTDrawable qTDrawable, Region region) throws QTException {
        if (qTDrawable != null) {
            GroupMember groupMember = null;
            try {
                groupMember = this.memberChanged(qTDrawable);
            }
            catch (QTException qTException) {
                if (qTException.errorCode() == -500 || qTException.errorCode() == -108) {
                    QTUtils.reclaimMemory();
                }
                throw qTException;
            }
            if (groupMember == null) {
                this.redraw(null);
                return;
            }
            Object object = QTNative.globalsLock;
            synchronized (object) {
                Object object2;
                boolean bl = false;
                boolean bl2 = false;
                int n = 0;
                while (n < this.vec.size()) {
                    Region region2;
                    object2 = (GroupMember)this.vec.elementAt(n);
                    if (bl && !(region2 = ((GroupMember)object2).drawer.getClip().sect(region)).empty()) {
                        ((GroupMember)object2).drawer.redraw(region2);
                    }
                    if (!bl && ((GroupMember)object2).drawer.equals(qTDrawable)) {
                        ((GroupMember)object2).drawer.redraw(null);
                        bl = true;
                        region = region != null ? region.union(groupMember.clipRegion) : groupMember.clipRegion;
                    }
                    ++n;
                }
                object2 = region.sect(this.eraseRegion);
                if (!((Region)object2).empty()) {
                    this.port.setBackColor(this.bgColor);
                    this.port.eraseRgn((Region)object2);
                }
            }
        }
        this.redraw(null);
    }

    public void setClip(Region region) throws QTException {
        Region region2 = this.clip = region == null ? new Region(this.getDisplayBounds()) : region.sect(this.getDisplayBounds());
        GroupMember groupMember = null;
        this.doMemCleanup = true;
        int n = 0;
        while (n < this.vec.size()) {
            GroupMember groupMember2 = (GroupMember)this.vec.elementAt(n);
            if (groupMember != null) {
                region2 = region2.diff(this.drawersRegion(groupMember));
            }
            groupMember2.drawer.setClip(region2);
            groupMember = groupMember2;
            ++n;
        }
        this.eraseRegion = groupMember != null ? region2.diff(this.drawersRegion(groupMember)) : region2;
        if (!this.doMemCleanup) {
            QTUtils.reclaimMemory();
        }
    }

    private Region drawersRegion(GroupMember groupMember) throws QTException {
        QTDrawable qTDrawable = groupMember.drawer;
        short s = qTDrawable.getMatrix().getType();
        boolean bl = false;
        switch (s) {
            case 4: 
            case 5: 
            case 6: {
                bl = true;
                break;
            }
            case 2: 
            case 3: {
                Matrix matrix = qTDrawable.getMatrix();
                if (!(matrix.getSx() < 0.0f) && !(matrix.getSy() < 0.0f)) break;
                bl = true;
                break;
            }
        }
        if (groupMember.clipRegion == null || this.redoCachedMembersClip) {
            groupMember.clipRegion = bl ? this.createRotatedRegion(qTDrawable) : new Region(qTDrawable.getDisplayBounds());
        }
        return groupMember.clipRegion;
    }

    private Region createRotatedRegion(QTDrawable qTDrawable) throws QTException {
        if (this.doMemCleanup) {
            QTUtils.reclaimMemory();
            QTUtils.checkFreeMemory();
            this.doMemCleanup = false;
        }
        Matrix matrix = qTDrawable.getMatrix().copy();
        QDRect qDRect = new QDRect(qTDrawable.getOriginalSize());
        matrix.transformRect(qDRect);
        QDGraphics qDGraphics = new QDGraphics(1, qDRect);
        qDGraphics.setBackColor(QDColor.white);
        qDGraphics.eraseRect(qDRect);
        qTDrawable.setGWorld(qDGraphics);
        qTDrawable.redraw(null);
        qTDrawable.setGWorld(this.getGWorld());
        try {
            return new Region(qDGraphics.getPixMap());
        }
        catch (QTException qTException) {
            block6: {
                if (qTException.errorCode() == -108 || qTException.errorCode() == -500) {
                    QTUtils.reclaimMemory();
                    try {
                        return new Region(qDGraphics.getPixMap());
                    }
                    catch (QTException qTException2) {
                        if (qTException2.errorCode() != -500) break block6;
                        new QTHandle(512000, false);
                        return new Region(qDGraphics.getPixMap());
                    }
                }
            }
            throw qTException;
        }
    }

    public GroupMember memberChanged(QTDrawable qTDrawable) throws QTException {
        GroupMember groupMember = this.getGroupMember(qTDrawable);
        if (groupMember != null) {
            this.setClips(qTDrawable);
        }
        return groupMember;
    }

    public boolean setMemberAlignment(QTDrawable qTDrawable, float f, float f2) throws QTException {
        boolean bl = super.setMemberAlignment(qTDrawable, f, f2);
        if (bl) {
            this.setClips(qTDrawable);
            this.redraw(null);
        }
        return bl;
    }

    public boolean setMemberLayer(QTDrawable qTDrawable, int n) throws QTException {
        boolean bl = super.setMemberLayer(qTDrawable, n);
        if (bl) {
            this.redoCachedMembersClip = true;
            this.setClip(null);
            this.redoCachedMembersClip = false;
            this.redraw(null);
        }
        return bl;
    }

    private boolean setClips(QTDrawable qTDrawable) throws QTException {
        boolean bl = false;
        Region region = this.clip;
        GroupMember groupMember = null;
        int n = 0;
        while (n < this.vec.size()) {
            GroupMember groupMember2 = (GroupMember)this.vec.elementAt(n);
            if (groupMember != null) {
                region = region.diff(groupMember.clipRegion);
            }
            groupMember = groupMember2;
            if (groupMember.drawer.equals(qTDrawable)) {
                bl = true;
                this.doMemCleanup = true;
                groupMember.clipRegion = null;
                this.redoCachedMembersClip = true;
                ++n;
                while (n < this.vec.size()) {
                    groupMember2 = (GroupMember)this.vec.elementAt(n);
                    region = region.diff(this.drawersRegion(groupMember));
                    groupMember2.drawer.setClip(region);
                    groupMember = groupMember2;
                    ++n;
                }
                break;
            }
            ++n;
        }
        if (groupMember != null) {
            this.eraseRegion = region.diff(this.drawersRegion(groupMember));
        }
        this.redoCachedMembersClip = false;
        if (!this.doMemCleanup) {
            QTUtils.reclaimMemory();
        }
        return bl;
    }

    static {
        if (QTSession.isCurrentOS(4) && QTSession.getJavaVersion() >= 65540) {
            throw new QTRuntimeException("Unsupported on Mac OS X and Java 1.4 and higher.");
        }
        p = DirectGroup.makeP();
    }
}

