/*
 * Decompiled with CFR 0.152.
 */
package quicktime.app.display;

import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Insets;
import java.awt.Window;
import quicktime.QTException;
import quicktime.QTRuntimeException;
import quicktime.QTSession;
import quicktime.jdirect.InterfaceLib;
import quicktime.qd.GDevice;
import quicktime.qd.QDRect;
import quicktime.std.movies.FullScreen;

public class FullScreenWindow
extends Window {
    private static Frame fr;
    private FullScreen fs;
    private int w;
    private int h;
    private int f;
    private GDevice gd;
    protected boolean doNotify = false;

    private static Frame _getFrame() {
        if (fr == null) {
            fr = new Frame();
        }
        return fr;
    }

    public FullScreenWindow() throws QTException {
        this(new FullScreen());
    }

    public FullScreenWindow(FullScreen fullScreen) throws QTException {
        this(fullScreen, FullScreenWindow._getFrame());
    }

    public FullScreenWindow(FullScreen fullScreen, Frame frame) throws QTException {
        super(frame);
        this.fs = fullScreen;
    }

    public FullScreen getFullScreen() {
        return this.fs;
    }

    public Dimension getPreferredSize() {
        try {
            if (this.w == 0 || this.h == 0) {
                Dimension dimension = this.fs.preflightSize(this.gd, this.w, this.h);
                this.w = dimension.width;
                this.h = dimension.height;
            }
        }
        catch (QTException qTException) {
            // empty catch block
        }
        return new Dimension(this.w, this.h);
    }

    public void setPreferredSize(int n, int n2) {
        this.w = n;
        this.h = n2;
    }

    public int getFlags() {
        return this.f;
    }

    public void setFlags(int n) {
        this.f = n;
    }

    public void setGDevice(GDevice gDevice) {
        this.gd = gDevice;
    }

    public GDevice getGDevice() {
        return this.gd;
    }

    public void show() {
        if (QTSession.isCurrentOS(1) || QTSession.isCurrentOS(4)) {
            this.doNotify = true;
            this.pack();
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        try {
            Dimension dimension = this.fs.begin(this.gd, this.w, this.h, this.f);
            this.setSize(dimension);
            this.w = dimension.width;
            this.h = dimension.height;
            if (QTSession.isCurrentOS(1) || QTSession.isCurrentOS(4)) {
                if (this.gd != null && !this.gd.equals(GDevice.getMain())) {
                    QDRect qDRect = this.gd.getBounds();
                    if (QTSession.isCurrentOS(4)) {
                        this.setLocation(qDRect.getX(), qDRect.getY() + -22);
                    } else {
                        this.setLocation(qDRect.getX() + -5, qDRect.getY() + -20);
                    }
                } else if (QTSession.isCurrentOS(4)) {
                    this.setLocation(0, -44);
                } else {
                    this.setLocation(-5, -40);
                }
            } else {
                if (this.gd != null) {
                    QDRect qDRect = this.gd.getBounds();
                    this.setLocation(qDRect.getX(), qDRect.getY());
                } else {
                    this.setLocation(0, 0);
                }
                this.doNotify = true;
                this.pack();
            }
            super.show();
            if (QTSession.isCurrentOS(4)) {
                this.requestFocus();
            }
            this.toFront();
        }
        catch (QTException qTException) {
            QTRuntimeException.handleOrThrow(new QTRuntimeException(qTException), this.fs, "begin");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void hide() {
        this.doNotify = false;
        try {
            this.fs.end();
        }
        catch (QTException qTException) {
            QTRuntimeException.handleOrThrow(new QTRuntimeException(qTException), this.fs, "end");
        }
        finally {
            super.hide();
            if (QTSession.isCurrentOS(1)) {
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException interruptedException) {}
                QTM.DrawMenuBar();
            }
        }
    }

    public void addNotify() {
        if (this.doNotify) {
            super.addNotify();
        }
    }

    public void pack() {
        if (this.doNotify) {
            super.pack();
        }
    }

    public Insets getInsets() {
        return new Insets(0, 0, 0, 0);
    }

    static {
        if (QTSession.isCurrentOS(4) && QTSession.getJavaVersion() >= 65540) {
            throw new QTRuntimeException("Unsupported on Mac OS X and Java 1.4 and higher.");
        }
        fr = null;
    }

    private static final class QTM
    implements InterfaceLib {
        private QTM() {
        }

        private static native void DrawMenuBar();
    }
}

