/*
 * Decompiled with CFR 0.152.
 */
package quicktime.app.display;

import java.awt.Dimension;
import java.util.Enumeration;
import java.util.Vector;
import quicktime.QTException;
import quicktime.QTRuntimeException;
import quicktime.QTSession;
import quicktime.app.display.GroupMember;
import quicktime.app.display.Layerable;
import quicktime.app.display.QTDisplaySpace;
import quicktime.app.display.QTDrawable;
import quicktime.app.image.Transformable;
import quicktime.app.spaces.Protocol;
import quicktime.app.spaces.SimpleSpace;
import quicktime.qd.QDColor;
import quicktime.qd.QDDimension;
import quicktime.qd.QDGraphics;
import quicktime.qd.QDRect;
import quicktime.qd.Region;
import quicktime.std.StdQTException;
import quicktime.std.image.Matrix;

public abstract class GroupDrawable
extends SimpleSpace
implements QTDisplaySpace {
    static final boolean debug = false;
    QDGraphics port = QDGraphics.scratch;
    QDRect displayBounds;
    boolean visible = false;
    QDDimension initSize;
    Region eraseRegion;
    QDColor bgColor;
    protected Region clip;
    protected Vector vec = new Vector(8);

    protected GroupDrawable(Dimension dimension, QDColor qDColor, int n, int n2, Protocol protocol) throws QTException {
        this(new QDDimension(dimension.width, dimension.height), qDColor, n, n2, protocol);
    }

    protected GroupDrawable(QDDimension qDDimension, QDColor qDColor, int n, int n2, Protocol protocol) throws QTException {
        super(protocol, n, n2);
        this.displayBounds = new QDRect(qDDimension);
        this.initSize = qDDimension;
        this.clip = this.eraseRegion = new Region(this.displayBounds);
        this.setBackgroundColor(qDColor);
    }

    public QDGraphics getGWorld() throws StdQTException {
        return this.port;
    }

    public void setGWorld(QDGraphics qDGraphics) throws QTException {
        this.port = qDGraphics;
        boolean bl = this.visible;
        this.visible = !QDGraphics.scratch.equals(qDGraphics);
    }

    public void setLocation(int n, int n2) throws QTException {
        this.displayBounds.setX(n);
        this.displayBounds.setY(n2);
        this.setDisplayBounds(this.displayBounds);
    }

    public void setDisplayBounds(QDRect qDRect) throws QTException {
        this.displayBounds = qDRect;
    }

    public QDRect getDisplayBounds() throws StdQTException {
        return this.displayBounds;
    }

    public QDColor getBackgroundColor() {
        return this.bgColor;
    }

    public void setBackgroundColor(QDColor qDColor) throws QTException {
        this.bgColor = qDColor == null ? this.port.getBackColor() : qDColor;
        if (this.visible) {
            this.redraw(null);
        }
    }

    public synchronized void removeMember(Object object) throws QTException {
        int n = 0;
        while (n < this.vec.size()) {
            GroupMember groupMember = (GroupMember)this.vec.elementAt(n);
            QTDrawable qTDrawable = groupMember.drawer;
            if (qTDrawable.equals(object)) {
                qTDrawable.setGWorld(QDGraphics.scratch);
                this.vec.removeElementAt(n);
                this.memberRemoved(object);
                if (!this.visible) break;
                this.setClip(null);
                this.redraw(null);
                break;
            }
            ++n;
        }
    }

    public synchronized Enumeration members() {
        Vector<QTDrawable> vector = new Vector<QTDrawable>();
        Enumeration enumeration = this.vec.elements();
        while (enumeration.hasMoreElements()) {
            GroupMember groupMember = (GroupMember)enumeration.nextElement();
            vector.addElement(groupMember.drawer);
        }
        return vector.elements();
    }

    public boolean isEmpty() {
        return this.vec.isEmpty();
    }

    public GroupMember getGroupMember(Object object) {
        Enumeration enumeration = this.vec.elements();
        while (enumeration.hasMoreElements()) {
            GroupMember groupMember = (GroupMember)enumeration.nextElement();
            if (!groupMember.drawer.equals(object)) continue;
            return groupMember;
        }
        return null;
    }

    public int size() {
        return this.vec.size();
    }

    public abstract GroupMember memberChanged(QTDrawable var1) throws QTException;

    public abstract void redrawMember(QTDrawable var1, Region var2) throws QTException;

    public boolean setMemberAlignment(QTDrawable qTDrawable, float f, float f2) throws QTException {
        GroupMember groupMember = this.getGroupMember(qTDrawable);
        if (groupMember != null) {
            this.setAlignedMemberLocation(groupMember.drawer, f, f2);
        }
        return groupMember != null;
    }

    public boolean setMemberLayer(QTDrawable qTDrawable, int n) throws QTException {
        if (!this.isAppropriate(qTDrawable)) {
            return false;
        }
        if (!this.hasMember(qTDrawable)) {
            return false;
        }
        GroupMember groupMember = null;
        int n2 = 0;
        while (n2 < this.vec.size()) {
            groupMember = (GroupMember)this.vec.elementAt(n2);
            if (groupMember.drawer.equals(qTDrawable)) {
                this.vec.removeElementAt(n2);
                break;
            }
            groupMember = null;
            ++n2;
        }
        if (groupMember != null) {
            boolean bl = false;
            groupMember.layer = n;
            int n3 = 0;
            while (n3 < this.vec.size()) {
                GroupMember groupMember2 = (GroupMember)this.vec.elementAt(n3);
                if (n <= groupMember2.layer) {
                    bl = true;
                    this.vec.insertElementAt(groupMember, n3);
                    break;
                }
                ++n3;
            }
            if (!bl) {
                this.vec.addElement(groupMember);
            }
        }
        return groupMember != null;
    }

    public int getBackLayer() {
        if (this.vec.size() == 0) {
            return -1;
        }
        GroupMember groupMember = (GroupMember)this.vec.elementAt(this.vec.size() - 1);
        return groupMember.getLayer();
    }

    public int getFrontLayer() {
        if (this.vec.size() == 0) {
            return -1;
        }
        GroupMember groupMember = (GroupMember)this.vec.elementAt(0);
        return groupMember.getLayer();
    }

    public Dimension getInitialSize() throws QTException {
        return new Dimension(this.initSize.getWidth(), this.initSize.getHeight());
    }

    public QDDimension getOriginalSize() throws QTException {
        return this.initSize.copy();
    }

    public synchronized void redraw(Region region) throws QTException {
        if (!this.eraseRegion.empty()) {
            this.port.setBackColor(this.bgColor);
            this.port.eraseRgn(this.eraseRegion);
        }
        int n = this.vec.size() - 1;
        while (n >= 0) {
            ((GroupMember)this.vec.elementAt((int)n)).drawer.redraw(region);
            --n;
        }
    }

    public Layerable getLayerable(Object object) {
        return this.getGroupMember(object);
    }

    public Transformable getTransformable(Object object) {
        if (this.hasMember(object)) {
            return (Transformable)object;
        }
        return null;
    }

    public Object hitTest(int n, int n2) throws QTException {
        if (this.vec != null) {
            if (!this.displayBounds.inside(n, n2)) {
                return null;
            }
            int n3 = 0;
            while (n3 < this.vec.size()) {
                GroupMember groupMember = (GroupMember)this.vec.elementAt(n3);
                if (groupMember.drawer.getDisplayBounds().inside(n, n2)) {
                    return groupMember.drawer;
                }
                ++n3;
            }
        }
        return null;
    }

    public Matrix getMatrix() throws StdQTException {
        Matrix matrix = new Matrix();
        matrix.setTx(this.displayBounds.getX());
        matrix.setTy(this.displayBounds.getY());
        return matrix;
    }

    public void setMatrix(Matrix matrix) throws QTException {
        int n = (int)(matrix.getTx() + 0.5f);
        int n2 = (int)(matrix.getTy() + 0.5f);
        this.setDisplayBounds(new QDRect(n, n2, this.displayBounds.getWidth(), this.displayBounds.getHeight()));
    }

    public Region getClip() throws QTException {
        return this.clip;
    }

    public Region getBackgroundClip() {
        return this.eraseRegion;
    }

    public abstract void setClip(Region var1) throws QTException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final synchronized void _addQTDrawable(GroupMember groupMember) throws QTException {
        QDRect qDRect = this.getDisplayBounds();
        boolean bl = false;
        Vector vector = this.vec;
        synchronized (vector) {
            int n = 0;
            while (n < this.vec.size()) {
                GroupMember groupMember2 = (GroupMember)this.vec.elementAt(n);
                if (groupMember.drawer.equals(groupMember2.drawer)) {
                    return;
                }
                if (groupMember.layer <= groupMember2.layer) {
                    this.vec.insertElementAt(groupMember, n);
                    bl = true;
                    break;
                }
                ++n;
            }
            if (!bl) {
                this.vec.addElement(groupMember);
            }
        }
        this.memberAdded(groupMember.drawer);
        if (this.visible) {
            this.setClip(null);
        }
        groupMember.drawer.setGWorld(this.getGWorld());
        if (this.visible) {
            this.redraw(null);
        }
    }

    protected void setAlignedMemberLocation(QTDrawable qTDrawable, float f, float f2) throws QTException {
        if (f < 0.0f) {
            f = 1.0f;
        } else if (f > 1.0f) {
            f = 1.0f;
        }
        if (f2 < 0.0f) {
            f2 = 1.0f;
        } else if (f2 > 1.0f) {
            f2 = 1.0f;
        }
        QDRect qDRect = this.getDisplayBounds();
        int n = qDRect.getX();
        int n2 = qDRect.getY();
        int n3 = qDRect.getWidth();
        int n4 = qDRect.getHeight();
        QDRect qDRect2 = qTDrawable.getDisplayBounds();
        int n5 = n3 - qDRect2.getWidth();
        int n6 = n4 - qDRect2.getHeight();
        if (n5 < 0) {
            n5 = 0;
        }
        if (n6 < 0) {
            n6 = 0;
        }
        int n7 = (int)((float)n5 * f);
        int n8 = (int)((float)n6 * f2);
        qTDrawable.setLocation(n + n7, n2 + n8);
    }

    static {
        if (QTSession.isCurrentOS(4) && QTSession.getJavaVersion() >= 65540) {
            throw new QTRuntimeException("Unsupported on Mac OS X and Java 1.4 and higher.");
        }
    }
}

