/*
 * Decompiled with CFR 0.152.
 */
package quicktime.app.display;

import java.awt.AWTEventMulticaster;
import java.awt.Canvas;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.util.Vector;
import quicktime.QTException;
import quicktime.QTRuntimeException;
import quicktime.QTSession;
import quicktime.QTUnknownOSException;
import quicktime.app.display.Drawable;
import quicktime.app.display.GroupDrawable;
import quicktime.app.display.QTCanvasHelper;
import quicktime.app.display.QTDrawable;
import quicktime.app.image.ImageDrawer;
import quicktime.app.players.QTPlayer;
import quicktime.qd.NativeGraphics;
import quicktime.qd.NativeGraphicsException;
import quicktime.qd.QDGraphics;
import quicktime.qd.QDPoint;
import quicktime.qd.QDRect;
import quicktime.qd.Region;
import quicktime.util.QTUtils;
import quicktime.util.UtilException;

public class QTCanvas
extends Canvas {
    private static boolean MRJWorkaroundFlag;
    private static final boolean debug = false;
    private static int canvasCount;
    public static final int kIntegralResize = 1;
    public static final int kInitialSize = 2;
    public static final int kFreeResize = 3;
    public static final int kAspectResize = 4;
    public static final int kPerformanceResize = 5;
    public static final int kHorizontalResize = 6;
    public static final int kVerticalResize = 7;
    public static final int kInitialSizeNoResize = 8;
    transient int numCanvas;
    private transient Vector mControllers;
    private QTCanvasHelper qtcHelper;
    private boolean doRedrawForQTPlayer = false;
    private float xAlignment;
    private float yAlignment;
    private int resizeFlag;
    transient int initialWidth;
    transient int initialHeight;
    int currentX;
    int currentY;
    private int minWidth;
    private int minHeight;
    private int maxWidth;
    private int maxHeight;
    private transient int prefWidth;
    private transient int prefHeight;
    int currentWidth;
    int currentHeight;
    transient NativeGraphics ng = null;
    private transient long msecs = 0L;
    transient boolean deferResize = false;
    private transient boolean appHasSetPreferredSize = false;
    boolean isWin = QTSession.isCurrentOS(2);
    boolean deferRedraw = false;
    private boolean moved;
    private int countRegionErr = 0;
    ComponentListener clientListener;
    private boolean addDone = false;

    public QTCanvas() {
        this(3, 0.0f, 0.0f);
    }

    public QTCanvas(int n, float f, float f2) {
        this.resizeFlag = n;
        this.initialWidth = 1;
        this.initialHeight = 1;
        this.setAlignmentValues(f, f2);
        this.minWidth = 1;
        this.minHeight = 1;
        this.maxWidth = Integer.MAX_VALUE;
        this.maxHeight = Integer.MAX_VALUE;
        this.numCanvas = canvasCount++;
        this.qtcHelper = new QTCanvasHelper(this);
    }

    public final QDGraphics getPort() throws QTUnknownOSException, NativeGraphicsException {
        QDGraphics qDGraphics = null;
        if (this.isVisible()) {
            qDGraphics = this.ng != null ? this.ng.getGWorld() : null;
        }
        return qDGraphics == null ? QDGraphics.scratch : qDGraphics;
    }

    public final Point getNGLocation() throws QTUnknownOSException, NativeGraphicsException {
        if (this.qtcHelper.mClient instanceof QTDrawable) {
            return this.ng != null ? this.ng.getLocation() : new Point(0, 0);
        }
        return this.getLocation();
    }

    public final NativeGraphics getNativeGraphics() {
        return this.ng;
    }

    public final QDPoint translatePoint(int n, int n2) throws QTUnknownOSException, NativeGraphicsException {
        Point point = this.getNGLocation();
        return new QDPoint(n + point.x, n2 + point.y);
    }

    public final synchronized void removeClient() {
        this.qtcHelper.doRemoveClient();
        this.repaint();
    }

    public synchronized void setClient(Drawable drawable, boolean bl) throws QTException {
        this.qtcHelper.doSetClient(drawable, drawable != null ? drawable.getDisplayBounds() : null, this.getMinimumSize(), this.getMaximumSize(), bl);
    }

    public synchronized void setClient(Drawable drawable, QDRect qDRect) throws QTException {
        this.qtcHelper.doSetClient(drawable, qDRect, this.getMinimumSize(), this.getMaximumSize(), true);
    }

    public final Drawable getClient() {
        return this.qtcHelper.mClient;
    }

    void setInitialWidthAndHeight(QDRect qDRect, Dimension dimension, Dimension dimension2) {
        this.initialWidth = qDRect.getWidth();
        this.initialHeight = qDRect.getHeight();
        this.minWidth = dimension.width < 0 ? 0 : dimension.width;
        this.minHeight = dimension.height < 0 ? 0 : dimension.height;
        this.maxWidth = dimension2.width < this.minWidth ? this.minWidth : dimension2.width;
        this.maxHeight = dimension2.height < this.minHeight ? this.minHeight : dimension2.height;
        if (this.initialWidth < this.minWidth) {
            this.initialWidth = this.minWidth;
        } else if (this.initialWidth > this.maxWidth) {
            this.initialWidth = this.maxWidth;
        }
        if (this.initialHeight < this.minHeight) {
            this.initialHeight = this.minHeight;
        } else if (this.initialHeight > this.maxHeight) {
            this.initialHeight = this.maxHeight;
        }
        if (!this.appHasSetPreferredSize) {
            this.prefWidth = this.initialWidth;
            this.prefHeight = this.initialHeight;
        }
    }

    final void doParentLayout() {
        Container container = this.getParent();
        if (container != null) {
            this.invalidate();
            container.validate();
            return;
        }
        super.reshape(this.currentX, this.currentY, this.currentWidth, this.currentHeight);
    }

    public void setAlignment(float f, float f2) {
        Rectangle rectangle = this.getBounds();
        this.setAlignmentValues(f, f2);
        this.doParentLayout();
        this.doRedrawForQTPlayer = this.qtcHelper.shouldRedrawQTPlayer(rectangle);
    }

    public final void setAlignmentX(float f) {
        this.setAlignment(f, this.getAlignmentY());
    }

    public final void setAlignmentY(float f) {
        this.setAlignment(this.getAlignmentX(), f);
    }

    private final void setAlignmentValues(float f, float f2) {
        this.xAlignment = f > 1.0f ? 1.0f : (f < 0.0f ? 0.0f : f);
        this.yAlignment = f2 > 1.0f ? 1.0f : (f2 < 0.0f ? 0.0f : f2);
    }

    public float getAlignmentX() {
        return this.xAlignment;
    }

    public float getAlignmentY() {
        return this.yAlignment;
    }

    public void setResizeFlag(int n) {
        this.resizeFlag = n;
        Rectangle rectangle = this.getBounds();
        this.doParentLayout();
        this.doRedrawForQTPlayer = this.qtcHelper.shouldRedrawQTPlayer(rectangle);
    }

    public int getResizeFlag() {
        return this.resizeFlag;
    }

    public void setMinimumSize(Dimension dimension) {
        if (dimension == null) {
            this.setMinimumSize(0, 0);
        } else {
            this.setMinimumSize(dimension.width, dimension.height);
        }
    }

    public void setMinimumSize(int n, int n2) {
        this.minWidth = n < 0 ? 0 : n;
        this.minHeight = n2 < 0 ? 0 : n2;
        if (this.currentWidth < this.minWidth || this.currentHeight < this.minHeight) {
            this.doParentLayout();
        }
    }

    public Dimension getMinimumSize() {
        return new Dimension(this.minWidth, this.minHeight);
    }

    public Dimension getBestSize() {
        return new Dimension(this.initialWidth, this.initialHeight);
    }

    public void clientChanged(Dimension dimension) {
        this.clientChanged(dimension.width, dimension.height);
    }

    public void clientChanged(int n, int n2) {
        Rectangle rectangle = new Rectangle(this.getLocation(), new Dimension(this.initialWidth, this.initialHeight));
        this.initialWidth = n < 0 ? 0 : n;
        this.initialHeight = n2 < 0 ? 0 : n2;
        if (!this.appHasSetPreferredSize) {
            this.prefWidth = this.initialWidth;
            this.prefHeight = this.initialHeight;
        }
        this.doRedrawForQTPlayer = this.qtcHelper.shouldRedrawQTPlayer(rectangle);
    }

    public Dimension getPreferredSize() {
        return new Dimension(this.prefWidth, this.prefHeight);
    }

    public void setPreferredSize(Dimension dimension) {
        if (dimension == null) {
            this.setPreferredSize(this.initialWidth, this.initialHeight);
        } else {
            this.setPreferredSize(dimension.width, dimension.height);
        }
    }

    public void setPreferredSize(int n, int n2) {
        if (n < 0) {
            this.prefWidth = this.initialWidth;
            this.appHasSetPreferredSize = false;
        } else {
            this.prefWidth = n;
            this.appHasSetPreferredSize = true;
        }
        if (n2 < 0) {
            this.prefHeight = this.initialHeight;
            this.appHasSetPreferredSize = false;
        } else {
            this.prefHeight = n2;
            this.appHasSetPreferredSize = true;
        }
        if (this.currentWidth != this.prefWidth || this.currentHeight != this.prefHeight) {
            this.doParentLayout();
        }
    }

    public boolean isFocusTraversable() {
        return true;
    }

    public void setMaximumSize(Dimension dimension) {
        if (dimension == null) {
            Dimension dimension2 = Toolkit.getDefaultToolkit().getScreenSize();
            this.setMaximumSize(dimension2.width, dimension2.height);
        } else {
            this.setMaximumSize(dimension.width, dimension.height);
        }
    }

    public void setMaximumSize(int n, int n2) {
        this.maxWidth = n < 0 ? 0 : n;
        this.maxHeight = n2 < 0 ? 0 : n2;
        if (this.currentWidth > this.maxWidth || this.currentHeight > this.maxHeight) {
            this.doParentLayout();
        }
    }

    public Dimension getMaximumSize() {
        return new Dimension(this.maxWidth, this.maxHeight);
    }

    private Dimension getAspectSize(int n, int n2) {
        int n3;
        int n4;
        if (n < this.minWidth) {
            n = this.minWidth;
        } else if (n > this.maxWidth) {
            n = this.maxWidth;
        }
        if (n2 < this.minHeight) {
            n2 = this.minHeight;
        } else if (n2 > this.maxHeight) {
            n2 = this.maxHeight;
        }
        float f = (float)n / (float)(this.initialWidth < 1 ? 1 : this.initialWidth);
        float f2 = (float)n2 / (float)(this.initialHeight < 1 ? 1 : this.initialHeight);
        if (f < f2) {
            n4 = (int)((float)this.initialWidth * f);
            n3 = (int)((float)this.initialHeight * f);
        } else {
            n4 = (int)((float)this.initialWidth * f2);
            n3 = (int)((float)this.initialHeight * f2);
        }
        return new Dimension(n4, n3);
    }

    private void setCurrentWidthHeight(int n, int n2) {
        switch (this.getResizeFlag()) {
            case 2: {
                this.currentWidth = this.initialWidth;
                this.currentHeight = this.initialHeight;
                if (this.currentWidth < this.minWidth) {
                    this.currentWidth = this.minWidth;
                } else if (this.currentWidth > this.maxWidth) {
                    this.currentWidth = this.maxWidth;
                }
                if (this.currentHeight < this.minHeight) {
                    this.currentHeight = this.minHeight;
                } else if (this.currentHeight > this.maxHeight) {
                    this.currentHeight = this.maxHeight;
                }
                if (this.currentWidth <= n && this.currentHeight <= n2) break;
                Dimension dimension = this.getAspectSize(n, n2);
                this.currentWidth = dimension.width;
                this.currentHeight = dimension.height;
                break;
            }
            case 4: {
                Dimension dimension = this.getAspectSize(n, n2);
                this.currentWidth = dimension.width;
                this.currentHeight = dimension.height;
                break;
            }
            case 6: {
                this.currentWidth = n;
                this.currentHeight = this.initialHeight;
                if (this.currentWidth < this.minWidth) {
                    this.currentWidth = this.minWidth;
                } else if (this.currentWidth > this.maxWidth) {
                    this.currentWidth = this.maxWidth;
                }
                if (this.currentHeight < this.minHeight) {
                    this.currentHeight = this.minHeight;
                } else if (this.currentHeight > this.maxHeight) {
                    this.currentHeight = this.maxHeight;
                }
                if (this.currentHeight <= n2) break;
                Dimension dimension = this.getAspectSize(n, n2);
                this.currentHeight = dimension.height;
                break;
            }
            case 7: {
                this.currentWidth = this.initialWidth;
                this.currentHeight = n2;
                if (this.currentWidth < this.minWidth) {
                    this.currentWidth = this.minWidth;
                } else if (this.currentWidth > this.maxWidth) {
                    this.currentWidth = this.maxWidth;
                }
                if (this.currentHeight < this.minHeight) {
                    this.currentHeight = this.minHeight;
                } else if (this.currentHeight > this.maxHeight) {
                    this.currentHeight = this.maxHeight;
                }
                if (this.currentWidth <= n) break;
                Dimension dimension = this.getAspectSize(n, n2);
                this.currentWidth = dimension.width;
                break;
            }
            case 5: {
                if (n < this.minWidth) {
                    n = this.minWidth;
                } else if (n > this.maxWidth) {
                    n = this.maxWidth;
                }
                if (n2 < this.minHeight) {
                    n2 = this.minHeight;
                } else if (n2 > this.maxHeight) {
                    n2 = this.maxHeight;
                }
                boolean bl = false;
                int n3 = 2;
                while (!bl) {
                    boolean bl2;
                    int n4;
                    int n5;
                    if (n < this.initialWidth || n2 < this.initialHeight) {
                        n5 = this.initialWidth / n3;
                        n4 = this.initialHeight / n3;
                        if (n5 <= n && n4 <= n2) {
                            bl = true;
                            bl2 = false;
                            this.currentWidth = n5;
                            this.currentHeight = n4;
                            while (bl2) {
                                if (this.currentWidth >= this.minWidth && this.currentHeight >= this.minHeight) {
                                    bl2 = true;
                                }
                                this.currentWidth *= 2;
                                this.currentHeight *= 2;
                            }
                        }
                    } else {
                        n5 = this.initialWidth * n3;
                        n4 = this.initialHeight * n3;
                        if (n5 >= n || n4 >= n2) {
                            bl = true;
                            if (n5 > n || n4 > n2) {
                                n5 /= 2;
                                n4 /= 2;
                            }
                            bl2 = false;
                            this.currentWidth = n5;
                            this.currentHeight = n4;
                            while (bl2) {
                                if (this.currentWidth <= this.maxWidth && this.currentHeight <= this.maxHeight) {
                                    bl2 = true;
                                }
                                this.currentWidth /= 2;
                                this.currentHeight /= 2;
                            }
                        }
                    }
                    n3 *= 2;
                }
                break;
            }
            case 1: {
                if (n < this.minWidth) {
                    n = this.minWidth;
                } else if (n > this.maxWidth) {
                    n = this.maxWidth;
                }
                if (n2 < this.minHeight) {
                    n2 = this.minHeight;
                } else if (n2 > this.maxHeight) {
                    n2 = this.maxHeight;
                }
                int n6 = this.initialWidth == 0 ? 0 : n / this.initialWidth;
                int n7 = this.initialHeight == 0 ? 0 : n2 / this.initialHeight;
                int n8 = Math.min(n6, n7);
                if (n8 < 1) {
                    float f = this.initialWidth == 0 ? 0.0f : (float)n / (float)this.initialWidth;
                    float f2 = this.initialHeight == 0 ? 0.0f : (float)n2 / (float)this.initialHeight;
                    n8 = 0;
                    n8 = f <= f2 ? this.initialWidth / n + 1 : this.initialHeight / n2 + 1;
                    this.currentWidth = (int)((float)this.initialWidth * 1.0f / (float)n8);
                    this.currentHeight = (int)((float)this.initialHeight * 1.0f / (float)n8);
                    break;
                }
                this.currentWidth = this.initialWidth * n8;
                this.currentHeight = this.initialHeight * n8;
                break;
            }
            case 8: {
                this.currentWidth = this.initialWidth;
                this.currentHeight = this.initialHeight;
                if (this.currentWidth < this.minWidth) {
                    this.currentWidth = this.minWidth;
                } else if (this.currentWidth > this.maxWidth) {
                    this.currentWidth = this.maxWidth;
                }
                if (this.currentHeight < this.minHeight) {
                    this.currentHeight = this.minHeight;
                    break;
                }
                if (this.currentHeight <= this.maxHeight) break;
                this.currentHeight = this.maxHeight;
                break;
            }
            default: {
                if (n < this.minWidth) {
                    n = this.minWidth;
                } else if (n > this.maxWidth) {
                    n = this.maxWidth;
                }
                if (n2 < this.minHeight) {
                    n2 = this.minHeight;
                } else if (n2 > this.maxHeight) {
                    n2 = this.maxHeight;
                }
                this.currentWidth = n;
                this.currentHeight = n2;
            }
        }
    }

    private final void setCurrentXY(int n, int n2, int n3, int n4) {
        int n5;
        int n6 = n3 - this.currentWidth;
        if (n6 < 0) {
            n6 = 0;
        }
        if ((n5 = n4 - this.currentHeight) < 0) {
            n5 = 0;
        }
        this.currentX = n + (int)(this.xAlignment * (float)n6);
        this.currentY = n2 + (int)(this.yAlignment * (float)n5);
    }

    public void setSize(Dimension dimension) {
        this.setSize(dimension.width, dimension.height);
    }

    public void setSize(int n, int n2) {
        this.setBounds(this.currentX, this.currentY, n, n2);
    }

    public final void reshape(int n, int n2, int n3, int n4) {
        this.setBounds(n, n2, n3, n4);
    }

    public final synchronized void setBounds(int n, int n2, int n3, int n4) {
        boolean bl = this.isValid();
        int n5 = this.currentWidth;
        int n6 = this.currentHeight;
        this.setCurrentWidthHeight(n3, n4);
        boolean bl2 = n5 != this.currentWidth || n6 != this.currentHeight;
        int n7 = this.currentX;
        int n8 = this.currentY;
        this.setCurrentXY(n, n2, n3, n4);
        super.reshape(this.currentX, this.currentY, this.currentWidth, this.currentHeight);
        if (this.qtcHelper.mClient != null) {
            boolean bl3 = this.deferResize = this.deferResize || bl2;
            if (this.deferResize) {
                this.doRedrawForQTPlayer = !this.isWin && !bl && (this.qtcHelper.mClient instanceof QTPlayer || this.qtcHelper.mClient instanceof GroupDrawable || this.qtcHelper.mClient instanceof ImageDrawer) && this.isShowing();
            }
            this.moved = n7 != this.currentX || n8 != this.currentY || this.moved;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void paint(Graphics graphics) {
        if (this.qtcHelper.mClient != null) {
            if (this.isValid()) {
                QTCanvas qTCanvas = this;
                synchronized (qTCanvas) {
                    block34: {
                        QDGraphics qDGraphics = null;
                        Region region = null;
                        try {
                            if (QTSession.isCurrentOS(1) || QTSession.isCurrentOS(4)) {
                                qDGraphics = this.getPort();
                                region = qDGraphics.getClip();
                                qDGraphics.clipRect();
                            }
                            Drawable drawable = this.qtcHelper.mClient;
                            synchronized (drawable) {
                                block33: {
                                    if (this.deferResize) {
                                        this.qtcHelper.doClientSetBounds();
                                    }
                                    if (this.moved) {
                                        this.moved = false;
                                        if (this.clientListener != null) {
                                            this.clientListener.componentMoved(new ComponentEvent(this, 100));
                                        }
                                    }
                                    if (!this.deferResize) break block33;
                                    this.deferResize = false;
                                    if (this.clientListener != null) {
                                        this.clientListener.componentResized(new ComponentEvent(this, 101));
                                    }
                                    if (this.doRedrawForQTPlayer) {
                                        this.qtcHelper.mClient.redraw(null);
                                        this.doRedrawForQTPlayer = false;
                                    }
                                    if (!MRJWorkaroundFlag || this.deferRedraw || this.isWin) break block33;
                                    return;
                                }
                                if (this.qtcHelper.mClient instanceof QTDrawable) {
                                    if (!((QTDrawable)this.qtcHelper.mClient).getGWorld().equals(QDGraphics.scratch)) {
                                        QTUtils.checkFreeMemory();
                                        this.qtcHelper.mClient.redraw(null);
                                    }
                                } else if (this.isShowing()) {
                                    QTUtils.checkFreeMemory();
                                    this.qtcHelper.mClient.redraw(null);
                                }
                                this.deferRedraw = false;
                            }
                        }
                        catch (QTException qTException) {
                            if (qTException.errorCode() == -500 || qTException.errorCode() == -108) {
                                if (qTException.errorCode() == -108) {
                                    try {
                                        QTUtils.checkFreeMemory();
                                    }
                                    catch (UtilException utilException) {
                                        QTRuntimeException.handleOrThrow(new QTRuntimeException(utilException), this.qtcHelper.mClient, "redraw");
                                    }
                                }
                                if (this.countRegionErr < 3) {
                                    if (this.deferResize) {
                                        this.doRedrawForQTPlayer = true;
                                    }
                                    ++this.countRegionErr;
                                    QTUtils.reclaimMemory();
                                    this.repaint();
                                    return;
                                }
                                this.countRegionErr = 0;
                                QTRuntimeException.handleOrThrow(new QTRuntimeException(qTException), this.qtcHelper.mClient, "setDisplayBounds");
                                break block34;
                            }
                            QTRuntimeException.handleOrThrow(new QTRuntimeException(qTException), this.qtcHelper.mClient, "setDisplayBounds");
                        }
                        finally {
                            if (qDGraphics != null && region != null) {
                                qDGraphics.setClip(region);
                            }
                        }
                    }
                    this.countRegionErr = 0;
                }
            }
            this.doParentLayout();
            this.repaint();
        }
    }

    public void update(Graphics graphics) {
        if (this.qtcHelper.mClient == null) {
            super.update(graphics);
        } else if (QTSession.isCurrentOS(4)) {
            this.paint(graphics);
        } else if (!(this.qtcHelper.mClient instanceof QTDrawable) || this.deferRedraw) {
            this.paint(graphics);
        }
    }

    public synchronized void setVisible(boolean bl) {
        super.setVisible(bl);
        try {
            if (bl) {
                this.qtcHelper.doSetGWorld(true);
                this.doParentLayout();
            } else {
                this.qtcHelper.doSetGWorld(false);
                Container container = this.getParent();
                if (container != null) {
                    container.repaint();
                }
            }
        }
        catch (QTException qTException) {
            QTRuntimeException.handleOrThrow(new QTRuntimeException(qTException), this.qtcHelper.mClient, "setGWorld");
        }
    }

    public void addQTClientListener(ComponentListener componentListener) {
        this.clientListener = AWTEventMulticaster.add(this.clientListener, componentListener);
    }

    public void removeQTClientListener(ComponentListener componentListener) {
        this.clientListener = AWTEventMulticaster.remove(this.clientListener, componentListener);
    }

    public synchronized void addNotify() {
        super.addNotify();
        if (!this.addDone) {
            try {
                this.ng = NativeGraphics.getContext(this);
                if (this.qtcHelper.mClient != null) {
                    this.qtcHelper.doSetGWorld(this.isVisible());
                    this.qtcHelper.mClient.addedTo(this);
                    if (this.isVisible()) {
                        if (!this.isWin) {
                            this.deferRedraw = true;
                        } else {
                            this.repaint();
                        }
                    }
                }
                QTSession.addActiveCanvas(this);
            }
            catch (QTException qTException) {
                this.qtcHelper.doRemoveClient();
                throw new QTRuntimeException(qTException);
            }
            this.addDone = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void removeNotify() {
        Object object = QTSession.terminationLock();
        synchronized (object) {
            if (this.addDone && QTSession.isInitialized()) {
                try {
                    if (this.qtcHelper.mClient != null) {
                        this.qtcHelper.doSetGWorld(false);
                        this.qtcHelper.mClient.removedFrom(this);
                    }
                    QTSession.removeActiveCanvas(this);
                    this.addDone = false;
                }
                catch (QTException qTException) {
                    this.qtcHelper.doRemoveClient();
                    throw new QTRuntimeException(qTException);
                }
                finally {
                    if (QTSession.isCurrentOS(2) && this.ng != null) {
                        QTCanvas.RemoveContext(this.ng);
                    }
                    this.ng = null;
                    super.removeNotify();
                }
            } else {
                super.removeNotify();
            }
        }
    }

    public String toString() {
        return this.getClass().getName() + "_" + this.numCanvas + "_" + "[Location=" + this.getLocation() + ",Size=" + this.getSize() + "]";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void finalize() throws Throwable {
        try {
            this.removeNotify();
            Object var2_1 = null;
            this.qtcHelper.mClient = null;
        }
        catch (Throwable throwable) {
            Object var2_2 = null;
            this.qtcHelper.mClient = null;
            throw throwable;
        }
        super.finalize();
    }

    private static native void RemoveContext(Object var0);

    static {
        if (QTSession.isCurrentOS(4) && QTSession.getJavaVersion() >= 65540) {
            throw new QTRuntimeException("Unsupported on Mac OS X and Java 1.4 and higher.");
        }
        if (QTSession.isCurrentOS(2)) {
            MRJWorkaroundFlag = false;
        } else if (QTSession.isCurrentOS(1) || QTSession.isCurrentOS(4)) {
            String string = System.getProperty("java.version");
            int n = Character.getNumericValue(string.charAt(0));
            int n2 = 0;
            int n3 = 0;
            boolean bl = false;
            int n4 = 1;
            while (n4 < string.length()) {
                char c = string.charAt(n4);
                if (Character.isDigit(c)) {
                    if (!bl) {
                        n2 = Character.getNumericValue(c);
                        bl = true;
                    } else {
                        n3 = Character.getNumericValue(c);
                    }
                }
                ++n4;
            }
            MRJWorkaroundFlag = n == 1 && n2 == 1 && n3 < 8;
        }
        canvasCount = 0;
    }
}

