/*
 * Decompiled with CFR 0.152.
 */
package quicktime.app.display;

import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ComponentEvent;
import quicktime.QTException;
import quicktime.QTRuntimeException;
import quicktime.QTSession;
import quicktime.app.display.Drawable;
import quicktime.app.display.GroupDrawable;
import quicktime.app.display.QTCanvas;
import quicktime.app.display.QTDrawable;
import quicktime.app.image.ImageDrawer;
import quicktime.app.players.QTPlayer;
import quicktime.qd.QDGraphics;
import quicktime.qd.QDRect;
import quicktime.util.QTUtils;

class QTCanvasHelper {
    private static final boolean debug = false;
    private QTCanvas canvas;
    transient Drawable mClient;

    QTCanvasHelper(QTCanvas qTCanvas) {
        this.canvas = qTCanvas;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void doRemoveClient() {
        try {
            block5: {
                try {
                    if (this.mClient == null) break block5;
                    if (QTSession.isInitialized()) {
                        this.doSetGWorld(false);
                    }
                    this.mClient.removedFrom(this.canvas);
                }
                catch (QTException qTException) {
                    Object var3_2 = null;
                    this.mClient = null;
                }
            }
            Object var3_1 = null;
            this.mClient = null;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            this.mClient = null;
            throw throwable;
        }
    }

    void doSetClient(Drawable drawable, QDRect qDRect, Dimension dimension, Dimension dimension2, boolean bl) throws QTException {
        if (drawable == this.mClient) {
            return;
        }
        if (this.mClient != null) {
            this.doRemoveClient();
        }
        if (drawable != null) {
            this.mClient = drawable;
            int n = this.canvas.currentWidth;
            int n2 = this.canvas.currentHeight;
            if (bl) {
                qDRect = qDRect != null ? qDRect : new QDRect(0, 0, this.canvas.getSize().width, this.canvas.getSize().height);
                this.canvas.setInitialWidthAndHeight(qDRect, dimension, dimension2);
                this.canvas.currentX = qDRect.getX();
                this.canvas.currentY = qDRect.getY();
                this.canvas.currentWidth = this.canvas.initialWidth;
                this.canvas.currentHeight = this.canvas.initialHeight;
                this.canvas.doParentLayout();
                this.canvas.deferResize = true;
            } else {
                this.canvas.setInitialWidthAndHeight(qDRect, this.canvas.getMinimumSize(), this.canvas.getMaximumSize());
                this.doClientSetBounds();
            }
            try {
                this.doSetGWorld(this.canvas.isVisible());
                if (this.canvas.getPeer() != null) {
                    this.mClient.addedTo(this.canvas);
                    this.canvas.repaint();
                }
                if (this.canvas.isVisible()) {
                    if (!this.canvas.isWin || !bl || n == this.canvas.currentWidth && n2 == this.canvas.currentHeight) {
                        this.canvas.deferRedraw = true;
                    } else {
                        this.canvas.repaint();
                    }
                }
            }
            catch (QTException qTException) {
                this.mClient.removedFrom(this.canvas);
                throw qTException;
            }
        }
    }

    void doSetGWorld(boolean bl) throws QTException {
        QTDrawable qTDrawable;
        QDGraphics qDGraphics;
        QDGraphics qDGraphics2;
        if (this.mClient instanceof QTDrawable && !(qDGraphics2 = bl && this.canvas.getPeer() != null ? this.canvas.getPort() : QDGraphics.scratch).equals(qDGraphics = (qTDrawable = (QTDrawable)this.mClient).getGWorld())) {
            qTDrawable.setGWorld(qDGraphics2);
            if (bl) {
                QTUtils.checkFreeMemory();
                if (this.canvas.clientListener != null) {
                    this.canvas.clientListener.componentShown(new ComponentEvent(this.canvas, 102));
                }
            } else if (this.canvas.clientListener != null) {
                this.canvas.clientListener.componentHidden(new ComponentEvent(this.canvas, 103));
            }
        }
    }

    boolean shouldRedrawQTPlayer(Rectangle rectangle) {
        return !this.canvas.isWin && (this.mClient instanceof QTPlayer || this.mClient instanceof GroupDrawable || this.mClient instanceof ImageDrawer) && this.canvas.isShowing() && !rectangle.equals(this.canvas.getBounds());
    }

    void doClientSetBounds() throws QTException {
        Point point = this.canvas.getNGLocation();
        this.mClient.setDisplayBounds(new QDRect(point.x, point.y, this.canvas.currentWidth, this.canvas.currentHeight));
    }

    static {
        if (QTSession.isCurrentOS(4) && QTSession.getJavaVersion() >= 65540) {
            throw new QTRuntimeException("Unsupported on Mac OS X and Java 1.4 and higher.");
        }
    }
}

