/*
 * Decompiled with CFR 0.152.
 */
package quicktime.app.event;

import java.util.Enumeration;
import java.util.Vector;
import quicktime.QTException;
import quicktime.QTRuntimeException;
import quicktime.QTSession;
import quicktime.app.anim.TwoDSprite;
import quicktime.app.display.QTDrawable;
import quicktime.app.event.MouseTargetListener;
import quicktime.app.event.QTEventCaster;
import quicktime.app.event.QTMouseController;
import quicktime.app.event.QTMouseEvent;
import quicktime.app.event.QTMouseListener;
import quicktime.app.spaces.Collection;
import quicktime.app.spaces.Space;
import quicktime.qd.QDPoint;
import quicktime.qd.QDRect;
import quicktime.qd.Region;

public class QTMouseTargetController
extends QTMouseController
implements Collection {
    private Object mousePressTarget;
    private boolean inPressDraggingTarget;
    private QDPoint cachePoint = new QDPoint(0, 0);
    MouseTargetListener mouseTargetListener;
    private Object currentMouseMovedTarget = null;
    private boolean wholespace;
    private Vector memberVec;

    public QTMouseTargetController() {
        this(true);
    }

    public QTMouseTargetController(boolean bl) {
        this.wholespace = bl;
        this.memberVec = new Vector();
    }

    public synchronized void addedToSpace(Space space) {
        super.addedToSpace(space);
        int n = 0;
        while (n < this.memberVec.size()) {
            Object e = this.memberVec.elementAt(n);
            if (this.compSpace != null) {
                if (!(e instanceof TwoDSprite)) {
                    this.memberVec.removeElementAt(n);
                    TwoDSprite twoDSprite = this.compSpace.getMemberSprite(e);
                    if (twoDSprite != null) {
                        this.memberVec.insertElementAt(twoDSprite, n);
                    } else {
                        --n;
                    }
                } else if (!this.space.hasMember(e)) {
                    this.memberVec.removeElementAt(n);
                    --n;
                }
            } else if (!this.space.hasMember(e)) {
                this.memberVec.removeElementAt(n);
                --n;
            }
            ++n;
        }
    }

    protected void removeActiveHandler() {
        if (this.mouseTargetListener != null && this.currentMouseMovedTarget != null) {
            QTMouseEvent qTMouseEvent = new QTMouseEvent(this.space);
            qTMouseEvent.initialiseEventProfile(508, -1, -1, 0L, 0, 0);
            qTMouseEvent.setTarget(this.currentMouseMovedTarget);
            this.doMouseTargetExit(qTMouseEvent);
            this.currentMouseMovedTarget = null;
        }
        super.removeActiveHandler();
    }

    protected void addHandler() {
        super.addHandler();
        if (this.hasMouseTargetListener()) {
            this.handler.addMouseTargetListener();
        }
    }

    public boolean isWholespace() {
        return this.wholespace;
    }

    public void setWholespace(boolean bl) {
        this.wholespace = bl;
    }

    public synchronized boolean addMember(Object object) {
        if (!this.isAppropriate(object)) {
            return false;
        }
        if (!this.hasMember(object)) {
            if (this.compSpace != null) {
                if (!(object instanceof TwoDSprite)) {
                    TwoDSprite twoDSprite = this.compSpace.getMemberSprite(object);
                    if (twoDSprite == null) {
                        return false;
                    }
                    this.memberVec.addElement(twoDSprite);
                    return true;
                }
                if (!this.compSpace.hasMember(object)) {
                    return false;
                }
            } else if (this.space != null && !this.space.hasMember(object)) {
                return false;
            }
            this.memberVec.addElement(object);
        }
        return true;
    }

    public boolean isAppropriate(Object object) {
        if (this.space != null) {
            return this.space.isAppropriate(object);
        }
        return true;
    }

    public void removeMember(Object object) {
        this.memberVec.removeElement(object);
    }

    public Enumeration members() {
        return this.memberVec.elements();
    }

    public boolean isEmpty() {
        return this.memberVec.isEmpty();
    }

    public int size() {
        return this.memberVec.size();
    }

    public boolean hasMember(Object object) {
        return object == null ? false : this.memberVec.contains(object);
    }

    public void addQTMouseListener(QTMouseListener qTMouseListener) {
        if (qTMouseListener instanceof MouseTargetListener) {
            this.addMouseTargetListener((MouseTargetListener)qTMouseListener);
        }
        super.addQTMouseListener(qTMouseListener);
    }

    public void removeQTMouseListener(QTMouseListener qTMouseListener) {
        if (qTMouseListener instanceof MouseTargetListener) {
            this.removeMouseTargetListener((MouseTargetListener)qTMouseListener);
        }
        super.removeQTMouseListener(qTMouseListener);
    }

    void addMouseTargetListener(MouseTargetListener mouseTargetListener) {
        boolean bl = this.hasMouseTargetListener();
        this.mouseTargetListener = QTEventCaster.add(this.mouseTargetListener, mouseTargetListener);
        this.updateMouseTargetListener(bl);
    }

    void removeMouseTargetListener(MouseTargetListener mouseTargetListener) {
        boolean bl = this.hasMouseTargetListener();
        this.mouseTargetListener = QTEventCaster.remove(this.mouseTargetListener, mouseTargetListener);
        this.updateMouseTargetListener(bl);
    }

    void updateMouseTargetListener(boolean bl) {
        if (this.handler != null) {
            if (bl && !this.hasMouseTargetListener()) {
                this.handler.removeMouseTargetListener();
            } else if (this.hasMouseTargetListener() && !bl) {
                this.handler.addMouseTargetListener();
            }
        }
    }

    boolean hasMouseTargetListener() {
        return this.mouseTargetListener != null;
    }

    boolean isInterestedInMouseMoveEvents(QTMouseEvent qTMouseEvent) {
        return this.mouseTargetListener != null && this.mouseTargetListener.matchModifierFilter(qTMouseEvent.getModifiers()) || super.isInterestedInMouseMoveEvents(qTMouseEvent);
    }

    protected void doMousePressed(QTMouseEvent qTMouseEvent) {
        this.mousePressTarget = this.getHitTarget(qTMouseEvent.getX(), qTMouseEvent.getY());
        if (this.mousePressTarget != null) {
            this.inPressDraggingTarget = true;
            qTMouseEvent.setTarget(this.mousePressTarget);
            this.mouseButtonListener.mousePressed(qTMouseEvent);
            this.currentMouseMovedTarget = null;
        }
    }

    public void mouseReleased(QTMouseEvent qTMouseEvent) {
        if (this.mouseButtonListener != null && this.mouseButtonListener.matchModifierFilter(qTMouseEvent.getModifiers())) {
            if (this.translateAndIsWithin(qTMouseEvent)) {
                this.doMouseReleased(qTMouseEvent, true);
            } else if (this.mousePressTarget != null) {
                this.doMouseReleased(qTMouseEvent, false);
            }
        }
    }

    protected void doMouseReleased(QTMouseEvent qTMouseEvent, boolean bl) {
        qTMouseEvent.setTarget(this.mousePressTarget);
        this.mouseButtonListener.mouseReleased(qTMouseEvent);
        if (this.inPressDraggingTarget) {
            this.currentMouseMovedTarget = this.mousePressTarget;
        } else {
            this.currentMouseMovedTarget = this.getHitTarget(qTMouseEvent.getX(), qTMouseEvent.getY());
            if (this.mouseTargetListener != null && this.mouseTargetListener.matchModifierFilter(qTMouseEvent.getModifiers())) {
                if (bl) {
                    Object object = this.getHitTarget(qTMouseEvent.getX(), qTMouseEvent.getY());
                    if (object != null) {
                        qTMouseEvent.setEventType(507);
                        qTMouseEvent.setTarget(object);
                        this.doMouseTargetEnter(qTMouseEvent);
                        qTMouseEvent.setEventType(502);
                    }
                    this.currentMouseMovedTarget = object;
                } else {
                    this.currentMouseMovedTarget = null;
                }
            }
        }
        this.mousePressTarget = null;
        qTMouseEvent.setTarget(null);
    }

    protected void doMouseClicked(QTMouseEvent qTMouseEvent) {
        Object object = this.getHitTarget(qTMouseEvent.getX(), qTMouseEvent.getY());
        if (object != null) {
            qTMouseEvent.setTarget(object);
            this.mouseButtonListener.mouseClicked(qTMouseEvent);
            qTMouseEvent.setTarget(null);
        }
    }

    public void mouseDragged(QTMouseEvent qTMouseEvent) {
        if (this.mousePressTarget == null) {
            return;
        }
        super.mouseDragged(qTMouseEvent);
    }

    protected void doMouseDragged(QTMouseEvent qTMouseEvent) {
        Object object;
        qTMouseEvent.setTarget(this.mousePressTarget);
        if (this.mouseMoveListener != null && this.mouseMoveListener.matchModifierFilter(qTMouseEvent.getModifiers())) {
            if (this.drawSpace != null) {
                try {
                    object = (QTDrawable)this.mousePressTarget;
                    Region region = null;
                    region = new Region(object.getDisplayBounds());
                    this.mouseMoveListener.mouseDragged(qTMouseEvent);
                    Region region2 = new Region(object.getDisplayBounds());
                    Region region3 = region.union(region2).diff(region2);
                    if (!region3.empty()) {
                        this.drawSpace.redrawMember((QTDrawable)object, region3);
                    }
                }
                catch (QTException qTException) {
                    QTRuntimeException.handleOrThrow(new QTRuntimeException(qTException), this, "mouseDragged");
                }
            } else {
                this.mouseMoveListener.mouseDragged(qTMouseEvent);
            }
        }
        if (this.mouseTargetListener != null && this.mouseTargetListener.matchModifierFilter(qTMouseEvent.getModifiers())) {
            object = this.getHitTarget(qTMouseEvent.getX(), qTMouseEvent.getY());
            if (object == null && this.inPressDraggingTarget) {
                qTMouseEvent.setEventType(508);
                this.doMouseTargetExit(qTMouseEvent);
                qTMouseEvent.setEventType(506);
                this.inPressDraggingTarget = false;
            } else if (object != null) {
                if (this.inPressDraggingTarget && object != this.mousePressTarget) {
                    qTMouseEvent.setEventType(508);
                    this.doMouseTargetExit(qTMouseEvent);
                    qTMouseEvent.setEventType(506);
                    this.inPressDraggingTarget = false;
                } else if (!this.inPressDraggingTarget && object == this.mousePressTarget) {
                    qTMouseEvent.setEventType(507);
                    this.doMouseTargetEnter(qTMouseEvent);
                    qTMouseEvent.setEventType(506);
                    this.inPressDraggingTarget = true;
                }
            }
        }
    }

    protected void doMouseTargetExit(QTMouseEvent qTMouseEvent) {
        this.mouseTargetListener.mouseTargetExited(qTMouseEvent);
    }

    protected void doMouseTargetEnter(QTMouseEvent qTMouseEvent) {
        this.mouseTargetListener.mouseTargetEntered(qTMouseEvent);
    }

    protected void doMouseMoved(QTMouseEvent qTMouseEvent, boolean bl) {
        if (this.mouseTargetListener != null && this.mouseTargetListener.matchModifierFilter(qTMouseEvent.getModifiers())) {
            if (!bl && this.currentMouseMovedTarget != null) {
                qTMouseEvent.setEventType(508);
                qTMouseEvent.setTarget(this.currentMouseMovedTarget);
                this.doMouseTargetExit(qTMouseEvent);
                qTMouseEvent.setEventType(503);
                this.currentMouseMovedTarget = null;
                return;
            }
            Object object = this.getHitTarget(qTMouseEvent.getX(), qTMouseEvent.getY());
            if (object == null) {
                if (this.currentMouseMovedTarget != null) {
                    qTMouseEvent.setEventType(508);
                    qTMouseEvent.setTarget(this.currentMouseMovedTarget);
                    this.doMouseTargetExit(qTMouseEvent);
                    qTMouseEvent.setEventType(503);
                    this.currentMouseMovedTarget = null;
                }
            } else if (this.currentMouseMovedTarget == null) {
                qTMouseEvent.setEventType(507);
                qTMouseEvent.setTarget(object);
                this.doMouseTargetEnter(qTMouseEvent);
                qTMouseEvent.setEventType(503);
                this.currentMouseMovedTarget = object;
            } else if (this.currentMouseMovedTarget != object) {
                qTMouseEvent.setEventType(508);
                qTMouseEvent.setTarget(this.currentMouseMovedTarget);
                this.doMouseTargetExit(qTMouseEvent);
                qTMouseEvent.setEventType(507);
                qTMouseEvent.setTarget(object);
                this.doMouseTargetEnter(qTMouseEvent);
                qTMouseEvent.setEventType(503);
                this.currentMouseMovedTarget = object;
            } else if (this.mouseMoveListener != null && this.mouseMoveListener.matchModifierFilter(qTMouseEvent.getModifiers())) {
                qTMouseEvent.setTarget(this.currentMouseMovedTarget);
                this.mouseMoveListener.mouseMoved(qTMouseEvent);
            }
        }
    }

    public void mouseEntered(QTMouseEvent qTMouseEvent) {
        super.mouseEntered(qTMouseEvent);
        if (!(this.mouseEnterExitListener != null && this.mouseEnterExitListener.matchModifierFilter(qTMouseEvent.getModifiers()))) {
            this.doMouseEnter_Target(qTMouseEvent);
        }
    }

    protected void doMouseEntered(QTMouseEvent qTMouseEvent) {
        super.doMouseEntered(qTMouseEvent);
        this.doMouseEnter_Target(qTMouseEvent);
    }

    public void mouseExited(QTMouseEvent qTMouseEvent) {
        if (!(this.mouseEnterExitListener != null && this.mouseEnterExitListener.matchModifierFilter(qTMouseEvent.getModifiers()))) {
            this.doMouseExit_Target(qTMouseEvent);
        }
        super.mouseExited(qTMouseEvent);
    }

    protected void doMouseExited(QTMouseEvent qTMouseEvent) {
        this.doMouseExit_Target(qTMouseEvent);
        super.doMouseExited(qTMouseEvent);
    }

    private void doMouseEnter_Target(QTMouseEvent qTMouseEvent) {
        if (this.mouseTargetListener != null && this.mouseTargetListener.matchModifierFilter(qTMouseEvent.getModifiers())) {
            if (this.mousePressTarget != null) {
                Object object = this.getHitTarget(qTMouseEvent.getX(), qTMouseEvent.getY());
                if (object != null && !this.inPressDraggingTarget && object == this.mousePressTarget) {
                    qTMouseEvent.setEventType(507);
                    qTMouseEvent.setTarget(this.mousePressTarget);
                    this.doMouseTargetEnter(qTMouseEvent);
                    this.inPressDraggingTarget = true;
                }
            } else {
                Object object = this.getHitTarget(qTMouseEvent.getX(), qTMouseEvent.getY());
                if (object != null) {
                    qTMouseEvent.setEventType(507);
                    qTMouseEvent.setTarget(object);
                    this.doMouseTargetEnter(qTMouseEvent);
                    this.currentMouseMovedTarget = object;
                }
            }
            qTMouseEvent.setTarget(null);
            qTMouseEvent.setEventType(504);
        }
    }

    private void doMouseExit_Target(QTMouseEvent qTMouseEvent) {
        if (this.mouseTargetListener != null && this.mouseTargetListener.matchModifierFilter(qTMouseEvent.getModifiers())) {
            if (this.mousePressTarget != null) {
                Object object = this.getHitTarget(qTMouseEvent.getX(), qTMouseEvent.getY());
                if (object == null && this.inPressDraggingTarget) {
                    qTMouseEvent.setEventType(508);
                    qTMouseEvent.setTarget(this.mousePressTarget);
                    this.doMouseTargetExit(qTMouseEvent);
                    this.inPressDraggingTarget = false;
                }
            } else if (this.currentMouseMovedTarget != null) {
                qTMouseEvent.setEventType(508);
                qTMouseEvent.setTarget(this.currentMouseMovedTarget);
                this.doMouseTargetExit(qTMouseEvent);
                this.currentMouseMovedTarget = null;
            }
            qTMouseEvent.setTarget(null);
            qTMouseEvent.setEventType(505);
        }
    }

    protected Object getHitTarget(int n, int n2) {
        if (this.displaySpace != null) {
            try {
                QDRect qDRect = this.displaySpace.getDisplayBounds();
                int n3 = n + qDRect.getX();
                int n4 = n2 + qDRect.getY();
                if (!qDRect.inside(n3, n4)) {
                    return null;
                }
                if (this.isWholespace()) {
                    return this.displaySpace.hitTest(n3, n4);
                }
                if (this.drawSpace != null) {
                    Object object = this.displaySpace.hitTest(n3, n4);
                    if (this.hasMember(object)) {
                        return object;
                    }
                    return null;
                }
                TwoDSprite twoDSprite = null;
                Enumeration enumeration = this.members();
                this.cachePoint.setX(n3);
                this.cachePoint.setY(n4);
                while (enumeration.hasMoreElements()) {
                    TwoDSprite twoDSprite2 = (TwoDSprite)enumeration.nextElement();
                    if (!twoDSprite2.hitTest(this.compSpace.hitTestFlag | 0x10, this.cachePoint)) continue;
                    if (twoDSprite != null) {
                        if (twoDSprite2.getLayer() >= twoDSprite.getLayer()) continue;
                        twoDSprite = twoDSprite2;
                        continue;
                    }
                    twoDSprite = twoDSprite2;
                }
                return twoDSprite;
            }
            catch (QTException qTException) {
                QTRuntimeException.handleOrThrow(new QTRuntimeException(qTException), this.displaySpace, "getDisplayBounds");
            }
        }
        return null;
    }

    static {
        if (QTSession.isCurrentOS(4) && QTSession.getJavaVersion() >= 65540) {
            throw new QTRuntimeException("Unsupported on Mac OS X and Java 1.4 and higher.");
        }
    }
}

