/*
 * Decompiled with CFR 0.152.
 */
package quicktime.app.image;

import java.awt.Dimension;
import quicktime.QTException;
import quicktime.QTRuntimeException;
import quicktime.QTSession;
import quicktime.app.display.QTDrawable;
import quicktime.app.image.Compositable;
import quicktime.io.QTFile;
import quicktime.qd.QDDimension;
import quicktime.qd.QDGraphics;
import quicktime.qd.QDRect;
import quicktime.qd.Region;
import quicktime.std.StdQTException;
import quicktime.std.image.GraphicsImporter;
import quicktime.std.image.GraphicsMode;
import quicktime.std.image.ImageDescription;
import quicktime.std.image.Matrix;
import quicktime.std.movies.media.DataRef;
import quicktime.util.EncodedImage;
import quicktime.util.RawEncodedImage;

public class GraphicsImporterDrawer
implements QTDrawable,
Compositable {
    private GraphicsImporter mGraphicsImporter;

    public GraphicsImporterDrawer(GraphicsImporter graphicsImporter) {
        this.mGraphicsImporter = graphicsImporter;
    }

    public GraphicsImporterDrawer(QTFile qTFile) throws QTException {
        this.mGraphicsImporter = new GraphicsImporter(qTFile);
    }

    public GraphicsImporterDrawer(DataRef dataRef) throws QTException {
        this.mGraphicsImporter = new GraphicsImporter(dataRef);
    }

    public GraphicsImporter getImporter() {
        return this.mGraphicsImporter;
    }

    public Region getClip() throws QTException {
        return this.mGraphicsImporter.getClip();
    }

    public void setClip(Region region) throws StdQTException {
        this.mGraphicsImporter.setClip(region);
    }

    public ImageDescription getDescription() throws StdQTException {
        return (ImageDescription)this.mGraphicsImporter.getImageDescription().clone();
    }

    public EncodedImage getImage() throws QTException {
        int n = this.mGraphicsImporter.getDataOffset();
        int n2 = this.mGraphicsImporter.getDataSize();
        RawEncodedImage rawEncodedImage = new RawEncodedImage(n2, true);
        this.mGraphicsImporter.readData(rawEncodedImage, n, n2);
        return rawEncodedImage;
    }

    public void addedTo(Object object) {
    }

    public void removedFrom(Object object) {
    }

    public QDGraphics getGWorld() throws StdQTException {
        return this.mGraphicsImporter.getGWorld();
    }

    public void setGWorld(QDGraphics qDGraphics) throws StdQTException {
        this.mGraphicsImporter.setGWorld(qDGraphics, null);
    }

    public Dimension getInitialSize() throws QTException {
        QDRect qDRect = this.mGraphicsImporter.getNaturalBounds();
        return new Dimension(qDRect.getWidth(), qDRect.getHeight());
    }

    public QDDimension getOriginalSize() throws QTException {
        QDRect qDRect = this.mGraphicsImporter.getNaturalBounds();
        return new QDDimension(qDRect.getWidth(), qDRect.getHeight());
    }

    public Matrix getMatrix() throws StdQTException {
        return this.mGraphicsImporter.getMatrix();
    }

    public void setMatrix(Matrix matrix) throws QTException {
        this.mGraphicsImporter.setMatrix(matrix);
    }

    public void setDisplayBounds(QDRect qDRect) throws StdQTException {
        this.mGraphicsImporter.setBoundsRect(qDRect);
    }

    public void setLocation(int n, int n2) throws QTException {
        QDRect qDRect = this.getDisplayBounds();
        qDRect.setX(n);
        qDRect.setY(n2);
        this.setDisplayBounds(qDRect);
    }

    public QDRect getDisplayBounds() throws StdQTException {
        return this.mGraphicsImporter.getBoundsRect();
    }

    public final synchronized void redraw(Region region) throws QTException {
        if (region != null) {
            Region region2 = this.mGraphicsImporter.getClip();
            this.mGraphicsImporter.setClip(region);
            this.mGraphicsImporter.draw();
            this.mGraphicsImporter.setClip(region2);
        } else {
            this.mGraphicsImporter.draw();
        }
    }

    public GraphicsMode getGraphicsMode() throws StdQTException {
        return this.mGraphicsImporter.getGraphicsMode();
    }

    public void setGraphicsMode(GraphicsMode graphicsMode) throws StdQTException {
        this.mGraphicsImporter.setGraphicsMode(graphicsMode);
    }

    public String toString() {
        return this.getClass().getName() + "[" + this.mGraphicsImporter + "]";
    }

    static {
        if (QTSession.isCurrentOS(4) && QTSession.getJavaVersion() >= 65540) {
            throw new QTRuntimeException("Unsupported on Mac OS X and Java 1.4 and higher.");
        }
    }
}

