/*
 * Decompiled with CFR 0.152.
 */
package quicktime.app.image;

import java.awt.Dimension;
import quicktime.QTException;
import quicktime.QTRuntimeException;
import quicktime.QTSession;
import quicktime.app.display.DrawingListener;
import quicktime.app.display.DrawingNotifier;
import quicktime.app.display.QTDrawable;
import quicktime.app.image.ImageSpec;
import quicktime.app.image.QTEffect;
import quicktime.qd.QDDimension;
import quicktime.qd.QDGraphics;
import quicktime.std.image.ImageDescription;
import quicktime.std.image.ImageSequenceDataSource;
import quicktime.std.movies.Atom;
import quicktime.std.movies.AtomContainer;
import quicktime.std.movies.AtomData;
import quicktime.util.EncodedImage;
import quicktime.util.EndianOrder;
import quicktime.util.QTUtils;
import quicktime.util.RawEncodedImage;

public class QTFilter
extends QTEffect {
    int srcA = QTUtils.toOSType("srcA");
    boolean inEffect = false;
    ImageContainer drawSourceListener;
    private static int nThreads;

    public QTFilter() throws QTException {
        this(1, new QDDimension(0, 0));
    }

    public QTFilter(Dimension dimension) throws QTException {
        this(1, dimension);
    }

    public QTFilter(QDDimension qDDimension) throws QTException {
        this(1, qDDimension);
    }

    public QTFilter(int n) throws QTException {
        this(n, new QDDimension(0, 0));
    }

    public QTFilter(int n, Dimension dimension) throws QTException {
        this(n, new QDDimension(dimension.width, dimension.height));
    }

    public QTFilter(int n, QDDimension qDDimension) throws QTException {
        super(n, qDDimension);
        if (n == 2) {
            // empty if block
        }
    }

    public void setEffect(AtomContainer atomContainer) throws QTException {
        Atom atom;
        if (atomContainer == null) {
            this.effectSamplePtr = null;
            if (this.effectSample != null) {
                this.effectSample.unlock();
            }
            this.effectSample = null;
            return;
        }
        this.effectSample = atomContainer;
        Atom atom2 = Atom.kParentIsContainer;
        int n = this.effectSample.countChildrenOfType(atom2, 1936876320);
        int n2 = 0;
        while (n2 < n) {
            atom = this.effectSample.findChildByIndex_Atom(atom2, 1936876320, 1);
            this.effectSample.removeAtom(atom);
            ++n2;
        }
        this.effectSample.insertChild(atom2, 1936876320, 1, 0, EndianOrder.flipNativeToBigEndian32(this.srcA));
        atom = this.effectSample.findChildByID_Atom(atom2, 2003329396, 1);
        this.effectSample.lock();
        AtomData atomData = this.effectSample.getAtomData(atom);
        this.effectDesc.setCType(EndianOrder.flipBigEndianToNative32(atomData.getInt(0)));
        this.effectSamplePtr = RawEncodedImage.fromQTPointer(this.effectSample.toQTPointer());
        this.setUpSequence();
    }

    public QDDimension getOriginalSize() throws QTException {
        return super.getOriginalSize();
    }

    public void setSourceImage(ImageSpec imageSpec) throws QTException {
        if (imageSpec != null) {
            if (this.drawSourceListener != null) {
                this.drawSourceListener.dispose();
            }
            this.drawSourceListener = new ImageContainer(imageSpec);
            this.initSize = new QDDimension(this.drawSourceListener.imgDesc.getWidth(), this.drawSourceListener.imgDesc.getHeight());
        } else {
            this.drawSourceListener.dispose();
            this.drawSourceListener = null;
        }
        this.setUpSequence();
    }

    public ImageSpec getSourceImage() {
        return this.drawSourceListener != null ? this.drawSourceListener.image : null;
    }

    protected synchronized boolean setUpSequence() throws QTException {
        if (this.drawSourceListener == null) {
            return false;
        }
        if (super.setUpSequence()) {
            this.drawSourceListener.prepareSequence(this.srcA);
            return true;
        }
        return false;
    }

    static {
        if (QTSession.isCurrentOS(4) && QTSession.getJavaVersion() >= 65540) {
            throw new QTRuntimeException("Unsupported on Mac OS X and Java 1.4 and higher.");
        }
    }

    class ImageContainer
    extends Thread
    implements DrawingListener {
        ImageSpec image;
        EncodedImage encImage;
        ImageDescription imgDesc;
        ImageSequenceDataSource imgDataSeq;

        ImageContainer(ImageSpec imageSpec) throws QTException {
            super("Draw Thread:" + nThreads++);
            this.image = imageSpec;
            this.imgDesc = this.image.getDescription();
            this.encImage = this.image.getImage();
            if (this.image instanceof DrawingNotifier) {
                ((DrawingNotifier)((Object)this.image)).addDrawingListener(this);
                if (this.image instanceof QTDrawable) {
                    ((QTDrawable)((Object)this.image)).setGWorld(QDGraphics.validScratch);
                }
                this.start();
            }
        }

        void prepareSequence(int n) throws QTException {
            if (this.imgDataSeq != null) {
                this.imgDataSeq.dispose();
            }
            this.imgDataSeq = new ImageSequenceDataSource(QTFilter.this.effectSequence, n, 1, this.imgDesc);
            this.imgDataSeq.setSourceData(this.encImage);
        }

        void dispose() throws QTException {
            if (this.imgDataSeq != null) {
                this.imgDataSeq.dispose();
            }
            if (this.image instanceof DrawingNotifier) {
                ((DrawingNotifier)((Object)this.image)).removeDrawingListener(this);
                if (this.image instanceof QTDrawable) {
                    ((QTDrawable)((Object)this.image)).setGWorld(QDGraphics.scratch);
                }
            }
        }

        public void drawingComplete(QTDrawable qTDrawable) {
            if (this.imgDataSeq != null) {
                try {
                    this.imgDataSeq.setSourceData(this.encImage);
                    this.imgDataSeq.changedSourceData();
                }
                catch (QTException qTException) {
                    qTException.printStackTrace();
                }
                if (!QTFilter.this.inEffect && this == QTFilter.this.drawSourceListener) {
                    this.resume();
                }
            }
        }

        public void run() {
            this.suspend();
            while (true) {
                try {
                    QTFilter.this.redraw(null);
                }
                catch (QTException qTException) {
                    qTException.printStackTrace();
                }
                this.suspend();
            }
        }
    }
}

