/*
 * Decompiled with CFR 0.152.
 */
package quicktime.app.image;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.image.PixelGrabber;
import quicktime.QTException;
import quicktime.QTRuntimeException;
import quicktime.QTSession;
import quicktime.app.QTAppException;
import quicktime.app.actions.Invalidator;
import quicktime.app.actions.Notifier;
import quicktime.app.actions.NotifyListener;
import quicktime.app.anim.SWCompositor;
import quicktime.app.anim.TwoDSprite;
import quicktime.app.display.QTDrawable;
import quicktime.app.image.DynamicImage;
import quicktime.app.image.ImagePresenter;
import quicktime.app.image.JImagePainter;
import quicktime.app.image.Paintable;
import quicktime.app.image.Redrawable;
import quicktime.qd.QDDimension;
import quicktime.qd.QDGraphics;
import quicktime.qd.QDRect;
import quicktime.qd.Region;
import quicktime.std.StdQTException;
import quicktime.std.image.GraphicsExporter;
import quicktime.std.image.GraphicsMode;
import quicktime.std.image.ImageDescription;
import quicktime.std.image.Matrix;
import quicktime.util.EncodedImage;
import quicktime.util.IntEncodedImage;
import quicktime.util.RawEncodedImage;

public class QTImageDrawer
implements Notifier,
QTDrawable,
DynamicImage,
Redrawable {
    private static final boolean debug = false;
    private static final boolean isWin;
    public static final int kMultiFrameRetain = 6;
    private ImagePresenter image;
    private Dimension mSize;
    private Image offscreenImage;
    private Image jPainterImage;
    private Graphics offscreenGraphics;
    private Paintable painter;
    private boolean interruptedGrab = false;
    private Component canv;
    private boolean mRedrawFlag = false;
    private NotifyListener nl;
    private int singleFrameFlag;
    private RawEncodedImage rei;
    private IntEncodedImage iData;
    private TwoDSprite sprite;

    public QTImageDrawer(Paintable paintable, Dimension dimension, int n) {
        this.mSize = dimension;
        this.painter = paintable;
        this.image = new ImagePresenter(new QDRect(this.mSize));
        this.singleFrameFlag = n;
        this.mRedrawFlag = n != 1;
    }

    public QTImageDrawer(Image image) throws QTAppException {
        int n = image.getWidth(null);
        if (n == -1) {
            throw new QTAppException("Image size must be known");
        }
        int n2 = image.getHeight(null);
        this.mSize = new Dimension(n, n2);
        this.image = new ImagePresenter(new QDRect(this.mSize));
        this.painter = new JImagePainter(image);
        this.singleFrameFlag = 1;
        this.mRedrawFlag = false;
    }

    public QTImageDrawer(Image image, Dimension dimension) {
        this(new JImagePainter(image), dimension, 1);
    }

    public Paintable getPaintable() {
        return this.painter;
    }

    public int export(GraphicsExporter graphicsExporter) throws QTException {
        QDGraphics qDGraphics = new QDGraphics(this.getDescription(), 0);
        return this.export(graphicsExporter, qDGraphics);
    }

    public int export(GraphicsExporter graphicsExporter, QDGraphics qDGraphics) throws QTException {
        if (this.canv == null) {
            throw new QTAppException("QTImageDrawer must be added to a QTCanvas before it can export");
        }
        if (!qDGraphics.isOffscreen()) {
            throw new QTAppException("QTImageDrawer.export must be supplied an offscreen QDGraphics");
        }
        QDGraphics qDGraphics2 = this.getGWorld();
        this.setGWorld(qDGraphics);
        this.redraw(null);
        this.setGWorld(qDGraphics2);
        graphicsExporter.setInputGWorld(qDGraphics);
        int n = graphicsExporter.doExport();
        qDGraphics = null;
        return n;
    }

    private synchronized void setSize(Dimension dimension) {
        this.mSize = dimension;
        if (this.canv == null) {
            return;
        }
        this.offscreenImage = this.canv.createImage(this.mSize.width, this.mSize.height);
        if (this.offscreenImage == null) {
            QTRuntimeException.handleOrThrow(new QTRuntimeException("must have a valid offscreen image"), this.canv, "createImage");
            return;
        }
        if (this.singleFrameFlag == 6) {
            this.offscreenGraphics = this.offscreenImage.getGraphics();
        }
        try {
            ImageDescription imageDescription = ImageDescription.getJavaDefaultPixelDescription(this.mSize.width, this.mSize.height);
            this.iData = new IntEncodedImage(this.mSize.width * this.mSize.height);
            imageDescription.setDataSize(this.iData.getSize());
            this.image.setImageData(this.iData, imageDescription);
            this.painter.newSizeNotified(this, this.mSize);
            if (this.painter instanceof JImagePainter) {
                ((JImagePainter)this.painter).prepareImage(this.canv);
            }
            this.prepaint();
            if (!this.interruptedGrab && this.isSingleFrame()) {
                this.doSingleFrame();
            }
        }
        catch (QTException qTException) {
            QTRuntimeException.handleOrThrow(new QTRuntimeException(qTException), this, "addedTo");
        }
    }

    private void doSingleFrame() throws QTException {
        this.rei = new RawEncodedImage(this.iData.getInts());
        this.image.setImageData(this.rei);
        this.iData = null;
        this.offscreenImage.flush();
        this.offscreenImage = null;
    }

    public Dimension getSize() {
        return new Dimension(this.mSize.width, this.mSize.height);
    }

    public final Region getClip() throws QTException {
        return this.image.getClip();
    }

    public final void setClip(Region region) throws StdQTException {
        this.image.setClip(region);
    }

    public ImagePresenter toImagePresenter() throws QTException {
        if (this.iData == null) {
            if (this.rei == null) {
                return null;
            }
            if (this.isSingleFrame()) {
                return ImagePresenter.fromQTImage(this.rei, (ImageDescription)this.image.getDescription().clone());
            }
            return ImagePresenter.fromQTImage((EncodedImage)this.rei.clone(), (ImageDescription)this.image.getDescription().clone());
        }
        return ImagePresenter.fromQTImage(new RawEncodedImage(this.iData.getInts()), (ImageDescription)this.image.getDescription().clone());
    }

    public ImageDescription getDescription() throws QTException {
        return this.image.getDescription();
    }

    public synchronized EncodedImage getImage() throws QTException {
        if (this.iData == null) {
            return this.rei;
        }
        return this.iData;
    }

    public final Matrix getMatrix() throws StdQTException {
        return this.image.getMatrix();
    }

    public final void setMatrix(Matrix matrix) throws QTException {
        this.image.setMatrix(matrix);
    }

    public Dimension getInitialSize() throws QTException {
        return this.image.getInitialSize();
    }

    public QDDimension getOriginalSize() throws QTException {
        return this.image.getOriginalSize();
    }

    public final QDGraphics getGWorld() {
        return this.image.getGWorld();
    }

    public void setGWorld(QDGraphics qDGraphics) throws QTException {
        this.image.setGWorld(qDGraphics);
    }

    public synchronized void setDisplayBounds(QDRect qDRect) throws StdQTException {
        this.image.setDisplayBounds(qDRect);
    }

    public void setLocation(int n, int n2) throws QTException {
        QDRect qDRect = this.getDisplayBounds();
        qDRect.setX(n);
        qDRect.setY(n2);
        this.setDisplayBounds(qDRect);
    }

    public QDRect getDisplayBounds() {
        return this.image.getDisplayBounds();
    }

    public synchronized void redraw(Region region) throws QTException {
        Region region2;
        if (this.iData == null && this.rei == null) {
            return;
        }
        if (this.interruptedGrab) {
            Region region3 = this.prepaint();
            if (region3 != null && region != null) {
                region = region3.union(region);
            }
            if (!this.interruptedGrab && this.isSingleFrame()) {
                this.doSingleFrame();
            }
        } else if (!this.isSingleFrame() && this.isRedrawing() && (region2 = this.prepaint()) != null && region != null) {
            region = region2.union(region);
        }
        this.image.redraw(region);
    }

    public void setRedrawing(boolean bl) {
        this.mRedrawFlag = bl;
    }

    public boolean isSingleFrame() {
        return this.singleFrameFlag == 1;
    }

    public boolean isRedrawing() {
        return this.mRedrawFlag;
    }

    public Region prepaint() throws QTException {
        Region region;
        block9: {
            if (this.offscreenImage == null) {
                return null;
            }
            region = null;
            try {
                Rectangle[] rectangleArray;
                if (this.offscreenGraphics == null) {
                    this.offscreenGraphics = this.offscreenImage.getGraphics();
                }
                if ((rectangleArray = this.painter.paint(this.offscreenGraphics)) == null) break block9;
                int n = 0;
                while (n < rectangleArray.length) {
                    if (rectangleArray[n] != null) {
                        int n2 = rectangleArray[n].x;
                        int n3 = rectangleArray[n].y;
                        int n4 = rectangleArray[n].width > this.mSize.width ? this.mSize.width : rectangleArray[n].width;
                        int n5 = rectangleArray[n].height > this.mSize.height ? this.mSize.height : rectangleArray[n].height;
                        PixelGrabber pixelGrabber = new PixelGrabber(this.offscreenImage, n2, n3, n4, n5, this.iData.getInts(), n3 * this.mSize.width + n2, this.mSize.width);
                        pixelGrabber.grabPixels();
                        region = region == null ? new Region(new QDRect(rectangleArray[n].x, rectangleArray[n].y, rectangleArray[n].width, rectangleArray[n].height)) : region.union(new QDRect(rectangleArray[n].x, rectangleArray[n].y, rectangleArray[n].width, rectangleArray[n].height));
                        ++n;
                        continue;
                    }
                    break;
                }
            }
            catch (InterruptedException interruptedException) {
                this.interruptedGrab = true;
                if (this.singleFrameFlag == 2) {
                    this.offscreenGraphics = null;
                }
                return null;
            }
        }
        this.interruptedGrab = false;
        if (this.sprite != null && !this.isSingleFrame() && this.sprite.isValid()) {
            this.sprite.invalidate();
        }
        if (this.singleFrameFlag == 2) {
            this.offscreenGraphics = null;
        }
        return region;
    }

    public void setGraphicsMode(GraphicsMode graphicsMode) throws QTException {
        this.image.setGraphicsMode(graphicsMode);
    }

    public GraphicsMode getGraphicsMode() {
        return this.image.getGraphicsMode();
    }

    public Invalidator addedToCompositor(SWCompositor sWCompositor, TwoDSprite twoDSprite) {
        this.sprite = twoDSprite;
        return this.isSingleFrame() ? null : new RedrawInvalidator(twoDSprite);
    }

    public void removedFromCompositor(SWCompositor sWCompositor) {
        this.sprite = null;
    }

    public synchronized void addedTo(Object object) {
        if (object instanceof Component) {
            if (this.canv != null) {
                this.removedFrom(this.canv);
            }
            this.canv = (Component)object;
            this.setSize(this.mSize);
            if (this.nl != null) {
                this.nl.notifyComplete();
            }
        }
    }

    public void removedFrom(Object object) {
        if (object instanceof Component) {
            this.canv = null;
            this.offscreenImage = null;
        }
    }

    public boolean addNotifyListener(NotifyListener notifyListener) {
        this.nl = notifyListener;
        if (!notifyListener.setNotifier(this)) {
            notifyListener = null;
            return false;
        }
        if (this.canv != null) {
            notifyListener.notifyComplete();
        }
        return true;
    }

    static {
        if (QTSession.isCurrentOS(4) && QTSession.getJavaVersion() >= 65540) {
            throw new QTRuntimeException("Unsupported on Mac OS X and Java 1.4 and higher.");
        }
        isWin = QTSession.isCurrentOS(2);
    }

    class RedrawInvalidator
    extends Invalidator {
        RedrawInvalidator(TwoDSprite twoDSprite) {
            super(twoDSprite);
        }

        public boolean tickle(float f, int n) throws QTException {
            if (QTImageDrawer.this.iData != null) {
                if (QTImageDrawer.this.isRedrawing()) {
                    QTImageDrawer.this.redraw(null);
                } else {
                    this.s.setImage(QTImageDrawer.this.iData);
                }
            }
            return true;
        }
    }
}

