/*
 * Decompiled with CFR 0.152.
 */
package quicktime.app.image;

import java.awt.Dimension;
import quicktime.QTException;
import quicktime.QTRuntimeException;
import quicktime.QTSession;
import quicktime.app.image.ImageSpec;
import quicktime.app.image.QTEffectPresenter;
import quicktime.app.image.QTFilter;
import quicktime.qd.QDDimension;
import quicktime.std.movies.Atom;
import quicktime.std.movies.AtomContainer;
import quicktime.std.movies.AtomData;
import quicktime.util.EndianOrder;
import quicktime.util.QTUtils;
import quicktime.util.RawEncodedImage;

public class QTTransition
extends QTFilter {
    QTFilter.ImageContainer drawDestListener;
    private int srcB = QTUtils.toOSType("srcB");
    private int mEffectDuration = 2000;
    private boolean mDoTime = true;
    private int fps;
    private boolean doProfile = false;
    private long profileTime = 0L;
    private int framesRendered;
    QTEffectPresenter thePresenter;

    public QTTransition() throws QTException {
        this(new QDDimension(0, 0));
    }

    public QTTransition(Dimension dimension) throws QTException {
        this(new QDDimension(dimension.width, dimension.height));
    }

    public QTTransition(QDDimension qDDimension) throws QTException {
        super(2, qDDimension);
        this.setFramesPerSecond(20);
        this.currentFrame = 0;
    }

    public void setEffect(AtomContainer atomContainer) throws QTException {
        Atom atom;
        if (atomContainer == null) {
            this.effectSamplePtr = null;
            if (this.effectSample != null) {
                this.effectSample.unlock();
            }
            this.effectSample = null;
            return;
        }
        this.effectSample = atomContainer;
        Atom atom2 = Atom.kParentIsContainer;
        int n = this.effectSample.countChildrenOfType(atom2, 1936876320);
        int n2 = 0;
        while (n2 < n) {
            atom = this.effectSample.findChildByIndex_Atom(atom2, 1936876320, 1);
            this.effectSample.removeAtom(atom);
            ++n2;
        }
        this.effectSample.insertChild(atom2, 1936876320, 1, 0, EndianOrder.flipNativeToBigEndian32(this.srcA));
        this.effectSample.insertChild(atom2, 1936876320, 2, 0, EndianOrder.flipNativeToBigEndian32(this.srcB));
        atom = this.effectSample.findChildByID_Atom(atom2, 2003329396, 1);
        this.effectSample.lock();
        AtomData atomData = this.effectSample.getAtomData(atom);
        this.effectDesc.setCType(EndianOrder.flipBigEndianToNative32(atomData.getInt(0)));
        this.effectSamplePtr = RawEncodedImage.fromQTPointer(this.effectSample.toQTPointer());
        this.setUpSequence();
    }

    public void setDestinationImage(ImageSpec imageSpec) throws QTException {
        if (imageSpec != null) {
            if (this.drawDestListener != null) {
                this.drawDestListener.dispose();
            }
            this.drawDestListener = new QTFilter.ImageContainer(imageSpec);
        } else {
            this.drawDestListener.dispose();
            this.drawDestListener = null;
        }
        this.setUpSequence();
    }

    public ImageSpec getDestinationImage() {
        return this.drawDestListener.image;
    }

    protected synchronized boolean setUpSequence() throws QTException {
        if (super.setUpSequence() && this.drawDestListener != null) {
            this.drawDestListener.prepareSequence(this.srcB);
            return true;
        }
        return false;
    }

    public synchronized void doTransition() throws QTException {
        if (this.effectSequence == null) {
            return;
        }
        this._doEffect();
        this.swapImages();
    }

    public void swapImages() throws QTException {
        QTFilter.ImageContainer imageContainer = this.drawSourceListener;
        this.drawSourceListener = this.drawDestListener;
        this.drawDestListener = imageContainer;
        this.drawSourceListener.prepareSequence(this.srcA);
        this.drawDestListener.prepareSequence(this.srcB);
        this.redraw(null);
    }

    public synchronized void setFrames(int n) throws QTException {
        this.mNumberOfFrames = n < 1 ? 1 : n;
        this.mEffectDuration = (int)((double)((float)this.mNumberOfFrames / (float)this.getFramesPerSecond() * 1000.0f) + 0.5);
        if (this.mEffectDuration < 1) {
            this.mEffectDuration = 1;
        }
        this.ft.setScale(this.mNumberOfFrames);
        this.ft.setDuration(this.mNumberOfFrames);
        this.ft.setVirtualDuration(this.mNumberOfFrames);
        if (this.currentFrame > this.mNumberOfFrames) {
            this.currentFrame = this.mNumberOfFrames;
        }
    }

    public void setFramesPerSecond(int n) throws QTException {
        this.mNumberOfFrames = (int)((float)this.mEffectDuration / 1000.0f * (float)n + 0.5f);
        this.ft.setScale(this.mNumberOfFrames);
        this.ft.setDuration(this.mNumberOfFrames);
        this.ft.setVirtualDuration(this.mNumberOfFrames);
        if (this.currentFrame > this.mNumberOfFrames) {
            this.currentFrame = this.mNumberOfFrames;
        }
        this.ft.setFrameNumber(this.currentFrame);
        this.fps = n;
    }

    public int getFramesPerSecond() {
        return this.fps;
    }

    public void setCurrentFrame(int n) {
        this.currentFrame = n;
        if (this.currentFrame > this.mNumberOfFrames) {
            this.currentFrame = this.mNumberOfFrames;
        }
    }

    public synchronized void setTime(int n) throws QTException {
        this.mEffectDuration = n < 1 ? 1 : n;
        this.mNumberOfFrames = (int)((double)this.mEffectDuration / 1000.0 * (double)this.getFramesPerSecond() + 0.5);
        if (this.mNumberOfFrames < 1) {
            this.mNumberOfFrames = 1;
        }
        this.ft.setScale(this.mNumberOfFrames);
        this.ft.setDuration(this.mNumberOfFrames);
        this.ft.setVirtualDuration(this.mNumberOfFrames);
        if (this.currentFrame > this.mNumberOfFrames) {
            this.currentFrame = this.mNumberOfFrames;
        }
    }

    public int getTime() {
        return this.mEffectDuration;
    }

    public synchronized void doTime(boolean bl) {
        this.mDoTime = bl;
    }

    public boolean isTime() {
        return this.mDoTime;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void _doEffect() throws QTException {
        if (this.effectSequence == null) {
            return;
        }
        int n = this.currentFrame;
        this.currentFrame = 1;
        Thread thread = Thread.currentThread();
        int n2 = thread.getPriority();
        thread.setPriority(10);
        long l = System.currentTimeMillis();
        if (this.doProfile) {
            this.framesRendered = 0;
        }
        try {
            this.inEffect = true;
            if (this.isTime()) {
                float f = (float)this.mEffectDuration / 1000.0f * (float)this.getFramesPerSecond();
                float f2 = 0.0f;
                float f3 = 0.0f;
                this.drawAdvanceCurrentFrame();
                if (this.mNumberOfFrames > 1) {
                    while (true) {
                        long l2 = System.currentTimeMillis();
                        int n3 = this.currentFrame;
                        this.drawAdvanceCurrentFrame();
                        if (this.currentFrame >= this.mNumberOfFrames) {
                            if (n3 == this.mNumberOfFrames) break;
                            this.drawAdvanceCurrentFrame();
                            break;
                        }
                        long l3 = System.currentTimeMillis();
                        f2 = l3 - l2;
                        long l4 = (long)this.mEffectDuration - (l3 - l);
                        if (l4 <= 0L) {
                            this.currentFrame = this.mNumberOfFrames;
                            this.drawAdvanceCurrentFrame();
                            break;
                        }
                        f3 = l4 / (long)(this.mNumberOfFrames - this.currentFrame);
                        float f4 = f3 - f2;
                        if (f4 < 0.0f) {
                            this.currentFrame += (int)(f2 / f3 + 0.5f);
                            if (this.currentFrame < this.mNumberOfFrames) continue;
                            this.currentFrame = this.mNumberOfFrames;
                            this.drawAdvanceCurrentFrame();
                            break;
                        }
                        try {
                            Thread.sleep((long)f4);
                        }
                        catch (InterruptedException interruptedException) {}
                    }
                }
                if (this.doProfile) {
                    this.profileTime = System.currentTimeMillis() - l;
                }
            } else {
                this.currentFrame = 1;
                while (true) {
                    this.drawAdvanceCurrentFrame();
                    if (this.currentFrame == 1) break;
                    Thread.yield();
                }
            }
            this.inEffect = false;
            Object var19_14 = null;
            thread.setPriority(n2);
            this.currentFrame = n;
            this.inEffect = false;
        }
        catch (Throwable throwable) {
            Object var19_15 = null;
            thread.setPriority(n2);
            this.currentFrame = n;
            this.inEffect = false;
            throw throwable;
        }
        if (this.doProfile) {
            this.profileTime = System.currentTimeMillis() - l;
        }
    }

    public void setProfiled(boolean bl) {
        this.doProfile = bl;
    }

    public boolean isProfiled() {
        return this.doProfile;
    }

    public int profileFramesRendered() {
        if (!this.doProfile) {
            return 0;
        }
        return this.framesRendered;
    }

    public int profileDuration() {
        if (!this.doProfile) {
            return 0;
        }
        return (int)this.profileTime;
    }

    private void drawAdvanceCurrentFrame() throws QTException {
        this.tb.setValue(this.currentFrame, this.mNumberOfFrames);
        this.ft.setValue(this.currentFrame);
        this.effectSequence.decompressFrameWhen(this.effectSamplePtr, 0, this.ft);
        ++this.currentFrame;
        ++this.framesRendered;
        if (this.currentFrame > this.mNumberOfFrames) {
            this.currentFrame = 1;
        }
        if (this.thePresenter != null) {
            this.thePresenter.sprite.invalidate();
        }
    }

    static {
        if (QTSession.isCurrentOS(4) && QTSession.getJavaVersion() >= 65540) {
            throw new QTRuntimeException("Unsupported on Mac OS X and Java 1.4 and higher.");
        }
    }
}

