/*
 * Decompiled with CFR 0.152.
 */
package quicktime.app.players;

import java.util.Vector;
import quicktime.QTException;
import quicktime.QTRuntimeException;
import quicktime.QTSession;
import quicktime.app.actions.Invalidator;
import quicktime.app.anim.SWCompositor;
import quicktime.app.anim.TwoDSprite;
import quicktime.app.audio.AudioSpec;
import quicktime.app.display.DrawingListener;
import quicktime.app.display.DrawingNotifier;
import quicktime.app.image.DynamicImage;
import quicktime.app.image.ImagePresenter;
import quicktime.app.players.Playable;
import quicktime.app.time.TaskAllMovies;
import quicktime.qd.PixMap;
import quicktime.qd.QDGraphics;
import quicktime.qd.QDRect;
import quicktime.qd.Region;
import quicktime.std.StdQTException;
import quicktime.std.clocks.TimeBase;
import quicktime.std.image.ImageDescription;
import quicktime.std.movies.Movie;
import quicktime.std.movies.MovieDrawingComplete;
import quicktime.std.movies.MoviePrePreroll;

public class MoviePresenter
extends ImagePresenter
implements AudioSpec,
Playable,
DynamicImage,
MovieDrawingComplete,
DrawingNotifier {
    private QDGraphics g;
    private Movie m;
    private boolean gModeOpaque;
    protected TwoDSprite spritePresenter;
    private boolean mChanged = false;
    private boolean isPres = false;
    private float lastRate = 0.0f;
    private Vector listenerList;
    private boolean drawCompleteListening = false;

    private static QDRect moveToZero(QDRect qDRect) {
        qDRect.move(0, 0);
        return qDRect;
    }

    public MoviePresenter(Movie movie) throws QTException {
        this(movie, new QDGraphics(32, movie.getBounds(), 4096));
    }

    public MoviePresenter(Movie movie, QDGraphics qDGraphics) throws QTException {
        super(MoviePresenter.moveToZero(movie.getBounds()));
        this.m = movie;
        this.g = qDGraphics;
        movie.setGWorld(qDGraphics, null);
        PixMap pixMap = qDGraphics.getPixMap();
        this.setImageData(pixMap.getPixelData(), new ImageDescription(pixMap));
        this.gModeOpaque = true;
        movie.task(0);
    }

    public void setGWorld(QDGraphics qDGraphics) throws QTException {
        if (this.getGWorld().equals(qDGraphics)) {
            return;
        }
        super.setGWorld(qDGraphics);
        if (QDGraphics.scratch.equals(qDGraphics)) {
            TaskAllMovies.removeMovie();
            this.isPres = false;
            this.m.removeDrawingCompleteProc();
            this.m.setActive(false);
        } else {
            this.isPres = !QDGraphics.validScratch.equals(qDGraphics);
            this.m.setDrawingCompleteProc(0, this);
            TaskAllMovies.addMovieAndStart();
            this.m.setActive(true);
        }
    }

    public boolean isPresenting() {
        return this.isPres;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int execute(Movie movie) {
        block7: {
            try {
                if (this.isPres) {
                    this.doDraw();
                }
                this.mChanged = true;
                if (this.listenerList == null) break block7;
                MoviePresenter moviePresenter = this;
                synchronized (moviePresenter) {
                    int n = 0;
                    while (n < this.listenerList.size()) {
                        ((DrawingListener)this.listenerList.elementAt(n)).drawingComplete(this);
                        ++n;
                    }
                }
            }
            catch (QTException qTException) {
                return qTException.errorCode();
            }
        }
        return 0;
    }

    public Movie getMovie() {
        return this.m;
    }

    public QDGraphics getOffscreenBuffer() {
        return this.g;
    }

    public void redraw(Region region) throws QTException {
        if (region != null) {
            this.m.invalidateRegion(region);
        } else {
            this.m.invalidateRegion(new Region(this.m.getBounds()));
        }
        this.m.task(0);
        if (this.spritePresenter != null && this.spritePresenter.isValid()) {
            this.spritePresenter.invalidate();
        }
        super.redraw(region);
    }

    public TimeBase getTimeBase() throws QTException {
        return this.m.getTimeBase();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setRate(float f) throws QTException {
        MoviePresenter moviePresenter = this;
        synchronized (moviePresenter) {
            this.lastRate = f;
        }
        if (f == 0.0f) {
            this.m.stop();
        } else {
            this.m.prePreroll(this.m.getTime(), f, new PrerollCallback(f));
        }
    }

    public float getRate() throws QTException {
        return this.m.getRate();
    }

    public void setTime(int n) throws QTException {
        this.m.setTimeValue(n);
    }

    public int getTime() throws QTException {
        return this.m.getTime();
    }

    public int getDuration() throws QTException {
        return this.m.getDuration();
    }

    public int getScale() throws QTException {
        return this.m.getTimeScale();
    }

    public float getVolume() throws QTException {
        float f = this.m.getVolume();
        return Math.abs(f);
    }

    public void setVolume(float f) throws QTException {
        float f2 = Math.abs(f);
        if (this.isMuted()) {
            this.m.setVolume(f2 * -1.0f);
        } else {
            this.m.setVolume(f2);
        }
    }

    public boolean isMuted() throws QTException {
        return this.m.getVolume() < 0.0f;
    }

    public void setMuted(boolean bl) throws QTException {
        float f = Math.abs(this.m.getVolume());
        if (bl) {
            this.m.setVolume(f * -1.0f);
        } else {
            this.m.setVolume(f);
        }
    }

    public void movieChanged() {
        this.mChanged = true;
    }

    public Invalidator addedToCompositor(SWCompositor sWCompositor, TwoDSprite twoDSprite) throws QTException {
        this.spritePresenter = twoDSprite;
        this.m.setActive(true);
        if (!this.drawCompleteListening) {
            this.m.setDrawingCompleteProc(0, this);
            this.drawCompleteListening = true;
        }
        return new MPInvalidator(this.spritePresenter);
    }

    public void removedFromCompositor(SWCompositor sWCompositor) throws QTException {
        if (this.listenerList == null) {
            this.m.removeDrawingCompleteProc();
            this.drawCompleteListening = false;
        }
        this.spritePresenter = null;
        if (QDGraphics.scratch.equals(this.getGWorld())) {
            this.m.setActive(false);
        }
    }

    public synchronized void addDrawingListener(DrawingListener drawingListener) {
        block4: {
            if (this.listenerList == null) {
                this.listenerList = new Vector();
            }
            if (this.listenerList.contains(drawingListener)) {
                return;
            }
            this.listenerList.addElement(drawingListener);
            if (this.drawCompleteListening) break block4;
            try {
                this.m.setDrawingCompleteProc(0, this);
                this.drawCompleteListening = true;
            }
            catch (StdQTException stdQTException) {}
        }
    }

    public synchronized void removeDrawingListener(DrawingListener drawingListener) {
        this.listenerList.removeElement(drawingListener);
        if (this.listenerList.isEmpty()) {
            if (this.spritePresenter == null) {
                try {
                    this.m.removeDrawingCompleteProc();
                    this.drawCompleteListening = false;
                }
                catch (StdQTException stdQTException) {
                    // empty catch block
                }
            }
            this.listenerList = null;
        }
    }

    static {
        if (QTSession.isCurrentOS(4) && QTSession.getJavaVersion() >= 65540) {
            throw new QTRuntimeException("Unsupported on Mac OS X and Java 1.4 and higher.");
        }
    }

    class PrerollCallback
    implements MoviePrePreroll {
        private float r;

        PrerollCallback(float f) {
            this.r = f;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void execute(Movie movie, int n) {
            MoviePresenter moviePresenter = MoviePresenter.this;
            synchronized (moviePresenter) {
                if (MoviePresenter.this.lastRate == 0.0f) {
                    return;
                }
                if (n == 0) {
                    try {
                        movie.preroll(movie.getTime(), this.r);
                        movie.setRate(this.r);
                    }
                    catch (QTException qTException) {
                        QTRuntimeException.handleOrThrow(new QTRuntimeException(qTException), movie, "preroll");
                    }
                } else {
                    QTRuntimeException.handleOrThrow(new QTRuntimeException(n), movie, "prePreroll");
                }
            }
        }
    }

    class MPInvalidator
    extends Invalidator {
        MPInvalidator(TwoDSprite twoDSprite) {
            super(twoDSprite);
        }

        public boolean tickle(float f, int n) throws QTException {
            MoviePresenter.this.m.task(0);
            if (MoviePresenter.this.mChanged) {
                MoviePresenter.this.spritePresenter.invalidate();
                MoviePresenter.this.mChanged = false;
            }
            return true;
        }
    }
}

