/*
 * Decompiled with CFR 0.152.
 */
package quicktime.app.time;

import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Enumeration;
import java.util.Vector;
import quicktime.QTException;
import quicktime.QTRuntimeException;
import quicktime.QTSession;
import quicktime.app.time.TaskThread;
import quicktime.app.time.Taskable;

public class TaskThread
implements Runnable {
    private static final int PRIORITY_NOT_SET = -1;
    private Vector taskVector = new Vector(12, 0);
    private Thread theThread = null;
    private int sleepTime;
    private String tName;
    private int threadPriority = 5;
    private boolean threadIsRunning = false;
    private static Vector threads = new Vector();

    public static final void killAllThreads() {
        Enumeration enumeration = threads.elements();
        while (enumeration.hasMoreElements()) {
            TaskThread taskThread = (TaskThread)enumeration.nextElement();
            taskThread.stop();
            taskThread.removeAll();
        }
        while (!threads.isEmpty()) {
            Thread.yield();
        }
    }

    public TaskThread(String string) {
        this(string, 100);
    }

    public TaskThread(String string, int n) {
        this.sleepTime = n;
        this.tName = string;
    }

    public int getSleepTime() {
        return this.sleepTime;
    }

    public void setSleepTime(int n) {
        this.sleepTime = n;
    }

    public boolean addMember(Object object) {
        if (!this.isAppropriate(object)) {
            return false;
        }
        if (this.taskVector.contains(object)) {
            return true;
        }
        Taskable taskable = (Taskable)object;
        if (taskable.getTasker() != null) {
            taskable.getTasker().removeMember(object);
        }
        this.taskVector.addElement(object);
        taskable.addedToTasker(this);
        return true;
    }

    public boolean isAppropriate(Object object) {
        return object instanceof Taskable;
    }

    public Enumeration members() {
        return this.taskVector.elements();
    }

    public void addAndStart(Taskable taskable) {
        this.addMember(taskable);
        this.start();
    }

    public void removeMember(Object object) {
        if (object != null) {
            this.taskVector.removeElement(object);
        }
        ((Taskable)object).removedFromTasker();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeAll() {
        this.stop();
        TaskThread taskThread = this;
        synchronized (taskThread) {
            Enumeration enumeration = this.taskVector.elements();
            while (enumeration.hasMoreElements()) {
                Taskable taskable = (Taskable)enumeration.nextElement();
                taskable.removedFromTasker();
            }
            this.taskVector.removeAllElements();
        }
    }

    public int size() {
        return this.taskVector.size();
    }

    public boolean hasMember(Object object) {
        return this.taskVector.contains(object);
    }

    public boolean isEmpty() {
        return this.taskVector.isEmpty();
    }

    public void start() {
        if (this.theThread == null) {
            class QTJPrivelegedAction {
                private final /* synthetic */ TaskThread this$0;

                QTJPrivelegedAction(TaskThread taskThread) {
                    this.this$0 = taskThread;
                }

                Object doPrivelegedAction() {
                    return AccessController.doPrivileged(new PrivilegedAction(this){
                        private final /* synthetic */ QTJPrivelegedAction this$1;
                        {
                            this.this$1 = qTJPrivelegedAction;
                        }

                        public Object run() {
                            return new Thread((Runnable)QTJPrivelegedAction.access$000(this.this$1), TaskThread.access$100(QTJPrivelegedAction.access$000(this.this$1)));
                        }
                    });
                }

                static /* synthetic */ TaskThread access$000(QTJPrivelegedAction qTJPrivelegedAction) {
                    return qTJPrivelegedAction.this$0;
                }
            }
            this.theThread = QTSession.getJavaVersion() == 65537 ? new Thread((Runnable)this, this.tName) : (Thread)new QTJPrivelegedAction(this).doPrivelegedAction();
            if (this.threadPriority != -1) {
                this.setPriority(this.threadPriority);
            }
            this.threadIsRunning = true;
            this.theThread.start();
            threads.addElement(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        if (this.theThread != null) {
            Thread thread = this.theThread;
            synchronized (thread) {
                this.threadIsRunning = false;
                this.theThread.resume();
                this.theThread.interrupt();
            }
            this.theThread = null;
        }
    }

    public void suspend() {
        if (this.theThread != null) {
            this.theThread.suspend();
        }
    }

    public void resume() {
        if (this.theThread != null) {
            this.theThread.resume();
        }
    }

    public boolean isAlive() {
        return this.theThread != null && this.theThread.isAlive();
    }

    public int getPriority() {
        return this.theThread != null ? this.theThread.getPriority() : this.threadPriority;
    }

    public void setPriority(int n) {
        if (this.theThread != null) {
            this.theThread.setPriority(n);
        }
        this.threadPriority = n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void run() {
        while (this.threadIsRunning && this.taskVector.size() > 0) {
            Thread thread = this.theThread;
            synchronized (thread) {
                if (!this.threadIsRunning) {
                    break;
                }
                int n = 0;
                while (n < this.taskVector.size()) {
                    block18: {
                        try {
                            Object var7_8;
                            boolean bl;
                            block17: {
                                block16: {
                                    Taskable taskable = (Taskable)this.taskVector.elementAt(n);
                                    bl = true;
                                    try {
                                        try {
                                            if (!this.threadIsRunning) {
                                                var7_8 = null;
                                                if (!bl) break;
                                                threads.removeElement(this);
                                                break block16;
                                            }
                                            taskable.task();
                                            bl = false;
                                            break block17;
                                        }
                                        catch (QTException qTException) {
                                            QTRuntimeException.handleOrThrow(new QTRuntimeException(qTException), taskable, "task");
                                            bl = false;
                                            var7_8 = null;
                                            if (!bl) break block18;
                                            threads.removeElement(this);
                                            this.theThread = null;
                                            break block18;
                                        }
                                    }
                                    catch (Throwable throwable) {
                                        var7_8 = null;
                                        if (bl) {
                                            threads.removeElement(this);
                                            this.theThread = null;
                                        }
                                        throw throwable;
                                    }
                                }
                                this.theThread = null;
                                break;
                            }
                            var7_8 = null;
                            if (!bl) break block18;
                            threads.removeElement(this);
                            this.theThread = null;
                        }
                        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                            break;
                        }
                    }
                    ++n;
                }
                if (!this.threadIsRunning) break;
            }
            try {
                if (this.sleepTime < 1) {
                    Thread.yield();
                    continue;
                }
                Thread.sleep(this.sleepTime);
            }
            catch (InterruptedException interruptedException) {
                if (this.threadIsRunning) continue;
            }
        }
        threads.removeElement(this);
        this.theThread = null;
    }

    protected void finalize() throws Throwable {
        this.removeAll();
        super.finalize();
    }

    public String toString() {
        return this.getClass().getName() + "[name=" + this.tName + ",size=" + this.size() + ",priority=" + this.getPriority() + ",sleepTime=" + this.sleepTime + "]";
    }

    static /* synthetic */ String access$100(TaskThread taskThread) {
        return taskThread.tName;
    }
}

