/*
 * Decompiled with CFR 0.152.
 */
package quicktime.app.view;

import java.awt.Container;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.ComponentEvent;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import quicktime.QTException;
import quicktime.QTRuntimeException;
import quicktime.QTSession;
import quicktime.app.time.TaskAllMovies;
import quicktime.app.time.TaskThread;
import quicktime.app.time.Tasking;
import quicktime.app.view.QTJavaAWTCanvas;
import quicktime.qd.QDException;
import quicktime.qd.QDGraphics;
import quicktime.qd.QDPoint;
import quicktime.qd.QDRect;
import quicktime.qd.Region;
import quicktime.std.StdQTException;
import quicktime.std.image.GraphicsImporter;
import quicktime.std.movies.Movie;
import quicktime.std.movies.MovieController;
import quicktime.std.sg.SequenceGrabber;
import quicktime.util.QTUtils;

class AWTCanvasHelper
extends Tasking
implements MouseListener,
KeyListener {
    private static final boolean debug = false;
    private TaskThread tt;
    private boolean deferTasking = false;
    private static TaskThread sgTasker = new TaskThread("Default SG Tasker", 20);
    private QTJavaAWTCanvas canvas;
    private Window parentWindow;
    private WindowAdapter wa;

    AWTCanvasHelper(QTJavaAWTCanvas qTJavaAWTCanvas) {
        this.canvas = qTJavaAWTCanvas;
    }

    public final void task() throws QTException {
        if (this.canvas.movieController != null) {
            this.canvas.movieController.idle();
        } else if (this.canvas.movie != null) {
            this.canvas.movie.task(0);
        } else if (this.canvas.grabber != null && !this.canvas.grabber.idleMore()) {
            this.stopTasking();
            this.canvas.grabber.stop();
        }
    }

    void setRate(float f) throws StdQTException {
        if (this.canvas.movieController != null) {
            if (f != 0.0f) {
                this.canvas.movieController.prerollAndPlay(f);
            } else {
                this.canvas.movieController.play(f);
            }
        }
    }

    protected void addedTo() {
        Container container;
        this.canvas.addMouseListener(this);
        this.canvas.addKeyListener(this);
        Container container2 = container = this.canvas.getParent();
        while (container2 != null) {
            container = container2;
            if (container instanceof Window) break;
            container2 = container.getParent();
        }
        if (container instanceof Window) {
            this.parentWindow = (Window)container;
            this.wa = new WindowAdapter(){

                public void windowActivated(WindowEvent windowEvent) {
                    block2: {
                        if (!QTSession.isInitialized() || ((AWTCanvasHelper)AWTCanvasHelper.this).canvas.movieController == null) break block2;
                        try {
                            ((AWTCanvasHelper)AWTCanvasHelper.this).canvas.movieController.activate(AWTCanvasHelper.this.getGWorld(), true);
                            ((AWTCanvasHelper)AWTCanvasHelper.this).canvas.movieController.activate();
                            AWTCanvasHelper.this.redraw(null);
                        }
                        catch (QTException qTException) {}
                    }
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void windowDeactivated(WindowEvent windowEvent) {
                    Object object = QTSession.terminationLock();
                    synchronized (object) {
                        if (QTSession.isInitialized() && ((AWTCanvasHelper)AWTCanvasHelper.this).canvas.movieController != null) {
                            try {
                                ((AWTCanvasHelper)AWTCanvasHelper.this).canvas.movieController.deactivate();
                                ((AWTCanvasHelper)AWTCanvasHelper.this).canvas.movieController.activate(AWTCanvasHelper.this.getGWorld(), false);
                                AWTCanvasHelper.this.redraw(null);
                            }
                            catch (QTException qTException) {}
                        } else {
                            AWTCanvasHelper.this.removedFrom();
                        }
                    }
                }
            };
            this.parentWindow.addWindowListener(this.wa);
        }
    }

    protected void removedFrom() {
        this.canvas.removeMouseListener(this);
        this.canvas.removeKeyListener(this);
        if (this.parentWindow != null) {
            this.parentWindow.removeWindowListener(this.wa);
            this.parentWindow = null;
            this.wa = null;
        }
    }

    public void keyPressed(KeyEvent keyEvent) {
        try {
            if (this.canvas.movieController != null) {
                this.canvas.movieController.key(keyEvent.getKeyCode(), keyEvent.getModifiers());
            }
        }
        catch (QTException qTException) {
            QTRuntimeException.handleOrThrow(new QTRuntimeException(qTException), this, "keyPressed");
        }
    }

    public void keyReleased(KeyEvent keyEvent) {
    }

    public void keyTyped(KeyEvent keyEvent) {
    }

    public void mousePressed(MouseEvent mouseEvent) {
        try {
            if (this.canvas.movieController != null) {
                this.canvas.movieController.click(new QDPoint(mouseEvent.getX(), mouseEvent.getY()), mouseEvent.getModifiers());
            }
        }
        catch (QTException qTException) {
            QTRuntimeException.handleOrThrow(new QTRuntimeException(qTException), this, "mousePressed");
        }
    }

    public void mouseClicked(MouseEvent mouseEvent) {
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    public void mouseReleased(MouseEvent mouseEvent) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void doRemoveClient() {
        try {
            if (this.canvas.movieController != null || this.canvas.movie != null || this.canvas.graphicsImporter != null) {
                if (QTSession.isInitialized()) {
                    this.doSetGWorld(false);
                }
                this.removedFrom();
            }
        }
        catch (QTException qTException) {
        }
        finally {
            this.canvas.movieController = null;
            this.canvas.graphicsImporter = null;
            this.canvas.movie = null;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    void doSetSequenceGrabber(SequenceGrabber sequenceGrabber, QDRect qDRect, Dimension dimension, Dimension dimension2, boolean bl) throws QTException {
        this.setDefaultTasker(sgTasker);
        this.canvas.grabber.setGWorld(QDGraphics.scratch, null);
        this.canvas.setInitialWidthAndHeight(qDRect, this.canvas.getMinimumSize(), this.canvas.getMaximumSize());
        int n = this.canvas.currentWidth;
        int n2 = this.canvas.currentHeight;
        this.doSetBounds();
        if (sequenceGrabber != null) {
            try {
                this.doSetGWorld(this.canvas.isVisible());
                if (this.canvas.getPeer() != null) {
                    this.addedTo();
                    this.canvas.repaint();
                }
                if (!this.canvas.isVisible()) return;
                if (!this.canvas.isWin || !bl || n == this.canvas.currentWidth && n2 == this.canvas.currentHeight) {
                    this.canvas.deferRedraw = true;
                    return;
                }
                this.canvas.repaint();
                return;
            }
            catch (QTException qTException) {
                this.removedFrom();
                throw qTException;
            }
        } else {
            this.canvas.repaint();
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    void doSetGraphicsImporter(GraphicsImporter graphicsImporter, QDRect qDRect, Dimension dimension, Dimension dimension2, boolean bl) throws QTException {
        if (this.canvas.graphicsImporter != null) {
            this.doRemoveClient();
        }
        if (graphicsImporter != null) {
            int n = this.canvas.currentWidth;
            int n2 = this.canvas.currentHeight;
            this.canvas.graphicsImporter = graphicsImporter;
            this.canvas.setInitialWidthAndHeight(qDRect, this.canvas.getMinimumSize(), this.canvas.getMaximumSize());
            this.doSetBounds();
            try {
                this.doSetGWorld(this.canvas.isVisible());
                if (this.canvas.getPeer() != null) {
                    this.addedTo();
                    this.canvas.repaint();
                }
                if (!this.canvas.isVisible()) return;
                if (!this.canvas.isWin || !bl || n == this.canvas.currentWidth && n2 == this.canvas.currentHeight) {
                    this.canvas.deferRedraw = true;
                    return;
                }
                this.canvas.repaint();
                return;
            }
            catch (QTException qTException) {
                this.removedFrom();
                throw qTException;
            }
        } else {
            this.canvas.repaint();
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    void doSetMovieController(MovieController movieController, QDRect qDRect, Dimension dimension, Dimension dimension2, boolean bl) throws QTException {
        if (movieController == this.canvas.movieController) {
            return;
        }
        if (this.canvas.movieController != null) {
            this.doRemoveClient();
        }
        if (movieController != null) {
            int n = this.canvas.currentWidth;
            int n2 = this.canvas.currentHeight;
            this.canvas.movieController = movieController;
            this.canvas.movie = movieController.getMovie();
            if (!bl) {
                this.canvas.setInitialWidthAndHeight(qDRect, this.canvas.getMinimumSize(), this.canvas.getMaximumSize());
                this.doSetBounds();
            }
            try {
                this.doSetGWorld(this.canvas.isVisible());
                if (this.canvas.getPeer() != null) {
                    this.addedTo();
                    this.canvas.repaint();
                }
                if (!this.canvas.isVisible()) return;
                if (!this.canvas.isWin || !bl || n == this.canvas.currentWidth && n2 == this.canvas.currentHeight) {
                    this.canvas.deferRedraw = true;
                    return;
                }
                this.canvas.repaint();
                return;
            }
            catch (QTException qTException) {
                this.removedFrom();
                throw qTException;
            }
        } else {
            this.canvas.repaint();
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    void doSetMovie(Movie movie, QDRect qDRect, Dimension dimension, Dimension dimension2, boolean bl) throws QTException {
        if (movie == this.canvas.movie) {
            return;
        }
        if (this.canvas.movie != null) {
            this.doRemoveClient();
        }
        if (movie != null) {
            this.canvas.movie = movie;
            int n = this.canvas.currentWidth;
            int n2 = this.canvas.currentHeight;
            if (bl) {
                qDRect = this.canvas.movieController != null ? this.canvas.movieController.getBounds() : new QDRect(0, 0, this.canvas.getSize().width, this.canvas.getSize().height);
                this.canvas.setInitialWidthAndHeight(qDRect, dimension, dimension2);
                this.canvas.currentX = qDRect.getX();
                this.canvas.currentY = qDRect.getY();
                this.canvas.currentWidth = this.canvas.initialWidth;
                this.canvas.currentHeight = this.canvas.initialHeight;
                this.canvas.doParentLayout();
                this.canvas.deferResize = true;
            } else {
                this.canvas.setInitialWidthAndHeight(qDRect, this.canvas.getMinimumSize(), this.canvas.getMaximumSize());
                this.doSetBounds();
            }
            try {
                this.doSetGWorld(this.canvas.isVisible());
                if (this.canvas.getPeer() != null) {
                    this.addedTo();
                    this.canvas.repaint();
                }
                if (!this.canvas.isVisible()) return;
                if (!this.canvas.isWin || !bl || n == this.canvas.currentWidth && n2 == this.canvas.currentHeight) {
                    this.canvas.deferRedraw = true;
                    return;
                }
                this.canvas.repaint();
                return;
            }
            catch (QTException qTException) {
                this.removedFrom();
                throw qTException;
            }
        } else {
            this.canvas.repaint();
        }
    }

    synchronized void setControllerGWorld(MovieController movieController, QDGraphics qDGraphics) throws QDException, StdQTException {
        if (this.getGWorld().equals(qDGraphics)) {
            return;
        }
        this.canvas.movieController.getMovie().setGWorld(QDGraphics.scratch, null);
        if (this.canvas.movieController.getVisible()) {
            this.canvas.movieController.setPort(qDGraphics);
        } else {
            this.canvas.movieController.getMovie().setGWorld(qDGraphics, null);
        }
        if (!QDGraphics.scratch.equals(qDGraphics)) {
            this.startTasking();
            movieController.getMovie().setActive(true);
        } else {
            this.setRate(0.0f);
            this.stopTasking();
            movieController.getMovie().setActive(false);
        }
    }

    synchronized void setMovieGWorld(QDGraphics qDGraphics) throws QDException, StdQTException {
        if (this.getGWorld().equals(qDGraphics)) {
            return;
        }
        this.canvas.movie.setGWorld(qDGraphics, null);
        if (QDGraphics.scratch.equals(qDGraphics)) {
            TaskAllMovies.removeMovie();
            this.setRate(0.0f);
            this.canvas.movie.setActive(false);
        } else {
            TaskAllMovies.addMovieAndStart();
            this.canvas.movie.setActive(true);
        }
    }

    void doSetGWorld(boolean bl) throws QTException {
        QDGraphics qDGraphics = bl && this.canvas.getPeer() != null ? this.canvas.getPort() : QDGraphics.scratch;
        if (this.canvas.movieController != null) {
            MovieController movieController = this.canvas.movieController;
            QDGraphics qDGraphics2 = movieController.getPort();
            if (!qDGraphics.equals(qDGraphics2)) {
                this.setControllerGWorld(movieController, qDGraphics);
            }
        } else if (this.canvas.movie != null) {
            this.setMovieGWorld(qDGraphics);
        } else if (this.canvas.graphicsImporter != null) {
            this.canvas.graphicsImporter.setGWorld(qDGraphics, null);
        } else if (this.canvas.grabber != null) {
            this.canvas.grabber.setGWorld(qDGraphics, null);
        }
        if (bl) {
            QTUtils.checkFreeMemory();
            if (this.canvas.clientListener != null) {
                this.canvas.clientListener.componentShown(new ComponentEvent(this.canvas, 102));
            }
        } else if (this.canvas.clientListener != null) {
            this.canvas.clientListener.componentHidden(new ComponentEvent(this.canvas, 103));
        }
    }

    boolean shouldRedrawQTPlayer(Rectangle rectangle) {
        return !this.canvas.isWin && this.canvas.isShowing() && !rectangle.equals(this.canvas.getBounds());
    }

    final void redraw(Region region) throws QTException {
        if (this.canvas.movieController != null) {
            if (region != null) {
                try {
                    this.canvas.movieController.invalidate(this.getGWorld(), region);
                }
                catch (StdQTException stdQTException) {
                    this.canvas.movieController.draw();
                }
            } else {
                this.canvas.movieController.draw();
                this.canvas.movieController.idle();
            }
        } else if (this.canvas.movie != null) {
            if (region != null) {
                this.canvas.movie.invalidateRegion(region);
            } else {
                this.canvas.movie.invalidateRegion(new Region(this.canvas.movie.getBounds()));
            }
            this.canvas.movie.task(0);
        } else if (this.canvas.graphicsImporter != null) {
            if (region != null) {
                Region region2 = this.canvas.graphicsImporter.getClip();
                this.canvas.graphicsImporter.setClip(region);
                this.canvas.graphicsImporter.draw();
                this.canvas.graphicsImporter.setClip(region2);
            } else {
                this.canvas.graphicsImporter.draw();
            }
        } else if (this.canvas.grabber != null) {
            if (region != null) {
                Region region3 = this.canvas.videoChannel.getClip();
                this.canvas.videoChannel.setClip(region);
                this.canvas.grabber.update(region);
                this.canvas.videoChannel.setClip(region3);
            } else {
                this.canvas.grabber.update(null);
            }
        }
    }

    public QDGraphics getGWorld() throws StdQTException {
        if (this.canvas.movieController != null) {
            return this.canvas.movieController.getPort();
        }
        if (this.canvas.movie != null) {
            return this.canvas.movie.getGWorld();
        }
        if (this.canvas.graphicsImporter != null) {
            return this.canvas.graphicsImporter.getGWorld();
        }
        if (this.canvas.grabber != null) {
            return this.canvas.grabber.getGWorld();
        }
        return QDGraphics.scratch;
    }

    void doSetBounds() throws QTException {
        Point point = this.canvas.getNGLocation();
        if (this.canvas.movie != null) {
            if (this.canvas.movieController != null) {
                if (this.canvas.movieController.getVisible() && this.canvas.isVisible()) {
                    this.canvas.movieController.setBounds(new QDRect(point.x, point.y, this.canvas.currentWidth, this.canvas.currentHeight));
                }
            } else {
                this.canvas.movie.setBounds(new QDRect(point.x, point.y, this.canvas.currentWidth, this.canvas.currentHeight));
            }
        } else if (this.canvas.graphicsImporter != null) {
            this.canvas.graphicsImporter.setBoundsRect(new QDRect(point.x, point.y, this.canvas.currentWidth, this.canvas.currentHeight));
        } else if (this.canvas.videoChannel != null) {
            this.canvas.videoChannel.setBounds(new QDRect(point.x, point.y, this.canvas.currentWidth, this.canvas.currentHeight));
            if (!QDGraphics.scratch.equals(this.getGWorld())) {
                this.deferTasking = false;
                this.startTasking();
            }
        }
    }
}

