/*
 * Decompiled with CFR 0.152.
 */
package quicktime.app.view;

import java.awt.AWTEventMulticaster;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.event.ComponentListener;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.DirectColorModel;
import java.awt.image.ImageProducer;
import java.awt.image.MacDirectColorModel;
import java.awt.image.MemoryImageSource;
import javax.swing.JComponent;
import quicktime.QTException;
import quicktime.QTObject;
import quicktime.QTSession;
import quicktime.app.view.DrawingListener;
import quicktime.app.view.DrawingNotifier;
import quicktime.app.view.GraphicsImporterDrawer;
import quicktime.app.view.MoviePlayer;
import quicktime.app.view.Presentable;
import quicktime.app.view.QTImageProducer;
import quicktime.app.view.QTJComponent;
import quicktime.qd.QDGraphics;
import quicktime.qd.QDRect;
import quicktime.util.RawEncodedImage;

class JQTCanvas
extends JComponent
implements DrawingListener,
QTJComponent {
    public static boolean flashScaling = false;
    public static boolean useMacOSXAcceleration = false;
    transient Presentable client;
    private int initialWidth = 1;
    private int initialHeight = 1;
    private int minWidth = 1;
    private int minHeight = 1;
    private int maxWidth;
    private int maxHeight;
    private int currentWidth;
    private int currentHeight;
    private int currentX;
    private int currentY;
    private transient int prefWidth;
    private transient int prefHeight;
    private transient boolean inited = false;
    private int resizeFlag;
    private boolean debug = false;
    private boolean paintlock = false;
    DirectColorModel colorModel = new DirectColorModel(32, 0xFF0000, 65280, 255, 0);
    public QTImageProducer ip;
    Image image;
    QDGraphics gw = null;
    QDRect gwBounds;
    int[] pixels;
    private ComponentListener clientListener;

    JQTCanvas(Presentable presentable) throws QTException {
        this.maxWidth = Integer.MAX_VALUE;
        this.maxHeight = Integer.MAX_VALUE;
        this.doSetClient(presentable, presentable != null ? presentable.getDisplayBounds() : null, this.getMinimumSize(), this.getMaximumSize(), true);
    }

    public MoviePlayer getMoviePlayer() {
        return this.client instanceof MoviePlayer ? (MoviePlayer)this.client : null;
    }

    public GraphicsImporterDrawer getGraphicsImporterDrawer() {
        return this.client instanceof GraphicsImporterDrawer ? (GraphicsImporterDrawer)this.client : null;
    }

    public void setGraphicsImporterDrawer(GraphicsImporterDrawer graphicsImporterDrawer) throws QTException {
        this.doSetClient(graphicsImporterDrawer, graphicsImporterDrawer != null ? graphicsImporterDrawer.getDisplayBounds() : null, this.getMinimumSize(), this.getMaximumSize(), false);
    }

    public void setMoviePlayer(MoviePlayer moviePlayer) throws QTException {
        this.doSetClient(moviePlayer, moviePlayer != null ? moviePlayer.getDisplayBounds() : null, this.getMinimumSize(), this.getMaximumSize(), false);
    }

    public void paint(Graphics graphics) {
        if (!this.inited && this.client != null) {
            this.client.addedTo(this);
            this.inited = true;
            super.paint(graphics);
        }
        if (this.image != null) {
            Dimension dimension = this.getSize();
            graphics.drawImage(this.image, 0, 0, dimension.width, dimension.height, this);
        }
    }

    public void setFlashScaling(boolean bl) {
        flashScaling = bl;
    }

    public boolean isFlashScaling() {
        return flashScaling;
    }

    Image imageFromEncodedImage(RawEncodedImage rawEncodedImage, QDRect qDRect) {
        rawEncodedImage.copyToArray(0, this.pixels, 0, this.pixels.length);
        MemoryImageSource memoryImageSource = new MemoryImageSource(qDRect.getWidth(), qDRect.getHeight(), (ColorModel)this.colorModel, this.pixels, 0, rawEncodedImage.getRowBytes() / 4);
        return this.getToolkit().createImage(memoryImageSource);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void removeClient() {
        if (this.client instanceof DrawingNotifier) {
            ((DrawingNotifier)((Object)this.client)).removeDrawingListener(this);
        }
        try {
            try {
                this.client.setGWorld(QDGraphics.scratch);
            }
            catch (QTException qTException) {
                Object var3_2 = null;
                this.client.removedFrom(this);
                this.client = null;
            }
            Object var3_1 = null;
            this.client.removedFrom(this);
            this.client = null;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            this.client.removedFrom(this);
            this.client = null;
            throw throwable;
        }
        if (QTSession.isCurrentOS(4)) {
            this.gw = null;
        }
        if (this.image != null) {
            this.image = null;
        }
        this.repaint();
    }

    public Dimension getBestSize() {
        return new Dimension(this.initialWidth, this.initialHeight);
    }

    public Dimension getMinimumSize() {
        Dimension dimension = null;
        dimension = new Dimension(this.minWidth, this.minHeight);
        return dimension;
    }

    public Dimension getMaximumSize() {
        Dimension dimension = null;
        dimension = new Dimension(Short.MAX_VALUE, Short.MAX_VALUE);
        return dimension;
    }

    public Dimension getPreferredSize() {
        Dimension dimension = null;
        dimension = new Dimension(this.prefWidth, this.prefHeight);
        return dimension;
    }

    void setInitialWidthAndHeight(QDRect qDRect, Dimension dimension, Dimension dimension2) {
        this.initialWidth = qDRect.getWidth();
        this.initialHeight = qDRect.getHeight();
        this.minWidth = dimension.width < 0 ? 0 : dimension.width;
        this.minHeight = dimension.height < 0 ? 0 : dimension.height;
        this.maxWidth = dimension2.width < this.minWidth ? this.minWidth : dimension2.width;
        this.maxHeight = dimension2.height < this.minHeight ? this.minHeight : dimension2.height;
        if (this.initialWidth < this.minWidth) {
            this.initialWidth = this.minWidth;
        } else if (this.initialWidth > this.maxWidth) {
            this.initialWidth = this.maxWidth;
        }
        if (this.initialHeight < this.minHeight) {
            this.initialHeight = this.minHeight;
        } else if (this.initialHeight > this.maxHeight) {
            this.initialHeight = this.maxHeight;
        }
        this.prefWidth = this.initialWidth;
        this.prefHeight = this.initialHeight;
        if (this.debug) {
            System.err.println("setInitialWidthAndHeight " + this.initialWidth + " " + this.initialHeight + " " + this.prefWidth + " " + this.prefHeight);
        }
    }

    private void doSetClient(Presentable presentable, QDRect qDRect, Dimension dimension, Dimension dimension2, boolean bl) throws QTException {
        if (presentable == this.client) {
            return;
        }
        if (this.client != null) {
            this.removeClient();
        }
        if (presentable != null) {
            this.client = presentable;
            if (bl) {
                this.setPreferredSize(new Dimension(qDRect.getWidth(), qDRect.getHeight()));
                this.setInitialWidthAndHeight(qDRect, dimension, dimension2);
                this.currentX = qDRect.getX();
                this.currentY = qDRect.getY();
                this.currentWidth = this.initialWidth;
                this.currentHeight = this.initialHeight;
                this.doParentLayout();
            }
            this.setPreferredSize(new Dimension(qDRect.getWidth(), qDRect.getHeight()));
            this.setInitialWidthAndHeight(qDRect, dimension, dimension2);
            this.currentX = qDRect.getX();
            this.currentY = qDRect.getY();
            this.currentWidth = this.initialWidth;
            this.currentHeight = this.initialHeight;
            this.doParentLayout();
            this.client.redraw(null);
            this.ip = new QTImageProducer(this.client, new Dimension(qDRect.getWidth(), qDRect.getHeight()));
            this.image = this.createImage(this.ip);
            this.prepareImage(this.image, this);
            if (this.client instanceof DrawingNotifier) {
                ((DrawingNotifier)((Object)this.client)).addDrawingListener(this);
            }
        }
        this.repaint();
    }

    public Image createImage(ImageProducer imageProducer) {
        if (QTSession.isCurrentOS(4) && useMacOSXAcceleration) {
            QDGraphics qDGraphics;
            boolean bl = false;
            QTImageProducer qTImageProducer = (QTImageProducer)imageProducer;
            Dimension dimension = qTImageProducer.getSize();
            this.gw = qDGraphics = qTImageProducer.getGWorld();
            BufferedImage bufferedImage = MacDirectColorModel.GetWrappedGWorldImage((int)QTObject.ID(qDGraphics), (int)32, (int)dimension.width, (int)dimension.height, (boolean)bl);
            return bufferedImage;
        }
        return super.createImage(imageProducer);
    }

    public void setBounds(int n, int n2, int n3, int n4) {
        if (this.debug) {
            System.out.println("setBounds( " + n + ", " + n2 + ", " + n3 + ", " + n4 + ")");
        }
        Dimension dimension = this.setCurrentWidthHeight(n3, n4);
        if (flashScaling) {
            this.setPreferredSize(dimension);
            this.initialWidth = n3;
            this.initialHeight = n4;
            try {
                this.client.redraw(null);
                this.ip = new QTImageProducer(this.client, dimension);
                this.image = this.createImage(this.ip);
                this.prepareImage(this.image, this);
            }
            catch (QTException qTException) {
                qTException.printStackTrace();
            }
            this.repaint();
        }
        this.currentX = n;
        this.currentY = n2;
        super.reshape(this.currentX, this.currentY, dimension.width, dimension.height);
    }

    public final void reshape(int n, int n2, int n3, int n4) {
        if (this.debug) {
            System.out.println("reshape( " + n + ", " + n2 + ", " + n3 + ", " + n4 + ")");
        }
        this.setBounds(n, n2, n3, n4);
    }

    private final void doParentLayout() {
        Container container;
        if (this.debug) {
            System.out.println("doParentLayout()");
        }
        if ((container = this.getParent()) != null) {
            this.invalidate();
            container.validate();
            return;
        }
        super.reshape(this.currentX, this.currentY, this.currentWidth, this.currentHeight);
    }

    private Dimension setCurrentWidthHeight(int n, int n2) {
        if (this.debug) {
            System.out.println("setCurrentWidthHeight( " + n + ", " + n2 + ", " + this.minWidth + ", " + this.minHeight);
        }
        if (this.currentWidth < this.minWidth) {
            this.currentWidth = this.minWidth;
        } else if (this.currentWidth > this.maxWidth) {
            this.currentWidth = this.maxWidth;
        }
        if (this.currentHeight < this.minHeight) {
            this.currentHeight = this.minHeight;
        } else if (this.currentHeight > this.maxHeight) {
            this.currentHeight = this.maxHeight;
        }
        this.currentWidth = n;
        this.currentHeight = n2;
        return new Dimension(this.currentWidth, this.currentHeight);
    }

    public void drawingComplete(Presentable presentable) {
        if (QTSession.isCurrentOS(4) && useMacOSXAcceleration) {
            this.repaint();
            return;
        }
        try {
            this.ip.updateConsumers(null);
        }
        catch (QTException qTException) {
            qTException.printStackTrace();
        }
    }

    public JComponent asJComponent() {
        return this;
    }

    public void addQTClientListener(ComponentListener componentListener) {
        this.clientListener = AWTEventMulticaster.add(this.clientListener, componentListener);
    }

    public void removeQTClientListener(ComponentListener componentListener) {
        this.clientListener = AWTEventMulticaster.remove(this.clientListener, componentListener);
    }
}

