/*
 * Decompiled with CFR 0.152.
 */
package quicktime.app.view;

import java.awt.Dimension;
import java.util.Vector;
import quicktime.QTException;
import quicktime.QTRuntimeException;
import quicktime.app.time.TaskAllMovies;
import quicktime.app.time.Timeable;
import quicktime.app.view.DrawingListener;
import quicktime.app.view.DrawingNotifier;
import quicktime.app.view.Presentable;
import quicktime.qd.QDDimension;
import quicktime.qd.QDGraphics;
import quicktime.qd.QDRect;
import quicktime.qd.Region;
import quicktime.std.StdQTException;
import quicktime.std.clocks.TimeBase;
import quicktime.std.image.Matrix;
import quicktime.std.movies.Movie;
import quicktime.std.movies.MovieDrawingComplete;
import quicktime.std.movies.MoviePrePreroll;

public class MoviePlayer
implements Presentable,
Timeable,
DrawingNotifier {
    private Movie mMovie;
    private Vector listenerList;
    private MovieComplete mComplete;
    private float lastRate = 0.0f;

    public MoviePlayer(Movie movie) throws StdQTException {
        this.mMovie = movie;
        movie.setPlayHints(256, 256);
    }

    public Movie getMovie() {
        return this.mMovie;
    }

    public void addedTo(Object object) {
    }

    public void removedFrom(Object object) {
    }

    public QDGraphics getGWorld() throws StdQTException {
        return this.mMovie.getGWorld();
    }

    public synchronized void setGWorld(QDGraphics qDGraphics) throws StdQTException {
        if (this.getGWorld().equals(qDGraphics)) {
            return;
        }
        this.mMovie.setGWorld(qDGraphics, null);
        if (QDGraphics.scratch.equals(qDGraphics)) {
            TaskAllMovies.removeMovie();
            this.setRate(0.0f);
            this.mMovie.setActive(false);
        } else {
            TaskAllMovies.addMovieAndStart();
            this.mMovie.setActive(true);
        }
    }

    public Dimension getInitialSize() throws QTException {
        QDRect qDRect = this.mMovie.getNaturalBoundsRect();
        return new Dimension(qDRect.getWidth(), qDRect.getHeight());
    }

    public QDDimension getOriginalSize() throws QTException {
        QDRect qDRect = this.mMovie.getNaturalBoundsRect();
        return new QDDimension(qDRect.getWidth(), qDRect.getHeight());
    }

    public Matrix getMatrix() throws StdQTException {
        return this.mMovie.getMatrix();
    }

    public void setMatrix(Matrix matrix) throws QTException {
        this.mMovie.setMatrix(matrix);
        this.mMovie.task(0);
    }

    public final void redraw(Region region) throws QTException {
        if (region != null) {
            this.mMovie.invalidateRegion(region);
        } else {
            this.mMovie.invalidateRegion(new Region(this.mMovie.getBounds()));
        }
        this.mMovie.task(0);
    }

    public synchronized void setDisplayBounds(QDRect qDRect) throws StdQTException {
        this.mMovie.setBounds(qDRect);
    }

    public void setLocation(int n, int n2) throws QTException {
        QDRect qDRect = this.getDisplayBounds();
        qDRect.setX(n);
        qDRect.setY(n2);
        this.setDisplayBounds(qDRect);
    }

    public QDRect getDisplayBounds() throws StdQTException {
        return this.mMovie.getBounds();
    }

    public void setClip(Region region) throws QTException {
        this.mMovie.setDisplayClipRgn(region);
    }

    public Region getClip() throws QTException {
        return this.mMovie.getDisplayClipRgn();
    }

    public void setTime(int n) throws StdQTException {
        this.mMovie.setTimeValue(n);
    }

    public int getTime() throws StdQTException {
        return this.mMovie.getTime();
    }

    public int getDuration() throws StdQTException {
        return this.mMovie.getDuration();
    }

    public TimeBase getTimeBase() throws QTException {
        return this.mMovie.getTimeBase();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setRate(float f) throws StdQTException {
        MoviePlayer moviePlayer = this;
        synchronized (moviePlayer) {
            this.lastRate = f;
        }
        if (f == 0.0f) {
            this.mMovie.stop();
        } else {
            this.mMovie.prePreroll(this.mMovie.getTime(), f, new PrerollCallback(f));
        }
    }

    public synchronized void addDrawingListener(DrawingListener drawingListener) {
        block4: {
            if (this.listenerList == null) {
                this.listenerList = new Vector();
            }
            if (this.listenerList.contains(drawingListener)) {
                return;
            }
            this.listenerList.addElement(drawingListener);
            if (this.mComplete != null) break block4;
            try {
                this.mComplete = new MovieComplete();
                this.mMovie.setDrawingCompleteProc(0, this.mComplete);
            }
            catch (StdQTException stdQTException) {
                this.mComplete = null;
            }
        }
    }

    public synchronized void removeDrawingListener(DrawingListener drawingListener) {
        if (this.listenerList != null) {
            this.listenerList.removeElement(drawingListener);
            if (this.listenerList.isEmpty()) {
                try {
                    this.mMovie.removeDrawingCompleteProc();
                }
                catch (StdQTException stdQTException) {
                    // empty catch block
                }
                this.mComplete = null;
                this.listenerList = null;
            }
        }
    }

    public float getRate() throws StdQTException {
        return this.mMovie.getRate();
    }

    public int getScale() throws QTException {
        return this.mMovie.getTimeScale();
    }

    public float getVolume() throws QTException {
        float f = this.mMovie.getVolume();
        return Math.abs(f);
    }

    public void setVolume(float f) throws QTException {
        float f2 = Math.abs(f);
        if (this.isMuted()) {
            this.mMovie.setVolume(f2 * -1.0f);
        } else {
            this.mMovie.setVolume(f2);
        }
    }

    public boolean isMuted() throws QTException {
        return this.mMovie.getVolume() < 0.0f;
    }

    public boolean isSingleFrame() {
        return false;
    }

    public void setMuted(boolean bl) throws QTException {
        float f = Math.abs(this.mMovie.getVolume());
        if (bl) {
            this.mMovie.setVolume(f * -1.0f);
        } else {
            this.mMovie.setVolume(f);
        }
    }

    class MovieComplete
    implements MovieDrawingComplete {
        MovieComplete() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public int execute(Movie movie) {
            MoviePlayer moviePlayer = MoviePlayer.this;
            synchronized (moviePlayer) {
                int n = 0;
                while (n < MoviePlayer.this.listenerList.size()) {
                    ((DrawingListener)MoviePlayer.this.listenerList.elementAt(n)).drawingComplete(MoviePlayer.this);
                    ++n;
                }
            }
            return 0;
        }
    }

    class PrerollCallback
    implements MoviePrePreroll {
        private float r;

        PrerollCallback(float f) {
            this.r = f;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void execute(Movie movie, int n) {
            MoviePlayer moviePlayer = MoviePlayer.this;
            synchronized (moviePlayer) {
                if (MoviePlayer.this.lastRate == 0.0f) {
                    return;
                }
                if (n == 0) {
                    try {
                        movie.preroll(movie.getTime(), this.r);
                        movie.setRate(this.r);
                    }
                    catch (QTException qTException) {
                        QTRuntimeException.handleOrThrow(new QTRuntimeException(qTException), movie, "preroll");
                    }
                } else {
                    QTRuntimeException.handleOrThrow(new QTRuntimeException(n), movie, "prePreroll");
                }
            }
        }
    }
}

