/*
 * Decompiled with CFR 0.152.
 */
package quicktime.app.view;

import java.awt.AWTEventMulticaster;
import java.awt.Canvas;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.ComponentListener;
import java.util.Vector;
import quicktime.QTException;
import quicktime.QTRuntimeException;
import quicktime.QTSession;
import quicktime.QTUnknownOSException;
import quicktime.app.view.AWTCanvasHelper;
import quicktime.app.view.QTComponent;
import quicktime.qd.NativeGraphics;
import quicktime.qd.NativeGraphicsException;
import quicktime.qd.QDGraphics;
import quicktime.qd.QDPoint;
import quicktime.qd.QDRect;
import quicktime.qd.Region;
import quicktime.std.image.GraphicsImporter;
import quicktime.std.movies.Movie;
import quicktime.std.movies.MovieController;
import quicktime.std.sg.SGVideoChannel;
import quicktime.std.sg.SequenceGrabber;
import quicktime.util.QTUtils;

class QTJavaAWTCanvas
extends Canvas
implements QTComponent {
    private static boolean MRJWorkaroundFlag;
    private static final boolean debug = false;
    private static int canvasCount;
    transient int numCanvas;
    private transient Vector mControllers;
    private AWTCanvasHelper qtcHelper;
    private boolean doRedrawForQTPlayer = false;
    transient int initialWidth = 1;
    transient int initialHeight = 1;
    int currentX;
    int currentY;
    private int minWidth = 1;
    private int minHeight = 1;
    private int maxWidth;
    private int maxHeight;
    private transient int prefWidth;
    private transient int prefHeight;
    int currentWidth;
    int currentHeight;
    transient NativeGraphics ng = null;
    private transient long msecs = 0L;
    transient boolean deferResize = false;
    private transient boolean appHasSetPreferredSize = false;
    boolean isWin = QTSession.isCurrentOS(2);
    private boolean addDone = false;
    boolean deferRedraw = false;
    Movie movie;
    MovieController movieController;
    GraphicsImporter graphicsImporter;
    SequenceGrabber grabber;
    SGVideoChannel videoChannel;
    private boolean moved;
    private int countRegionErr = 0;
    ComponentListener clientListener;

    QTJavaAWTCanvas(Movie movie) throws QTException {
        this();
        this.setMovie(movie);
    }

    QTJavaAWTCanvas(GraphicsImporter graphicsImporter) throws QTException {
        this();
        this.setImage(graphicsImporter);
    }

    QTJavaAWTCanvas(MovieController movieController) throws QTException {
        this();
        this.setMovieController(movieController);
    }

    private QTJavaAWTCanvas() {
        this.maxWidth = Integer.MAX_VALUE;
        this.maxHeight = Integer.MAX_VALUE;
        this.numCanvas = canvasCount++;
        this.qtcHelper = new AWTCanvasHelper(this);
    }

    public void displayChanged(int n, int n2) {
        Rectangle rectangle = new Rectangle(this.getLocation(), new Dimension(this.initialWidth, this.initialHeight));
        this.initialWidth = n < 0 ? 0 : n;
        this.initialHeight = n2 < 0 ? 0 : n2;
        if (!this.appHasSetPreferredSize) {
            this.prefWidth = this.initialWidth;
            this.prefHeight = this.initialHeight;
        }
    }

    public final QDGraphics getPort() throws QTUnknownOSException, NativeGraphicsException {
        QDGraphics qDGraphics = null;
        if (this.isVisible()) {
            qDGraphics = this.ng != null ? this.ng.getGWorld() : null;
        }
        return qDGraphics == null ? QDGraphics.scratch : qDGraphics;
    }

    public final Point getNGLocation() throws QTUnknownOSException, NativeGraphicsException {
        if (this.qtcHelper != null) {
            return this.ng != null ? this.ng.getLocation() : new Point(0, 0);
        }
        return this.getLocation();
    }

    public final NativeGraphics getNativeGraphics() {
        return this.ng;
    }

    public final QDPoint translatePoint(int n, int n2) throws QTUnknownOSException, NativeGraphicsException {
        Point point = this.getNGLocation();
        return new QDPoint(n + point.x, n2 + point.y);
    }

    public Movie getMovie() {
        return this.movie;
    }

    public MovieController getMovieController() {
        return this.movieController;
    }

    public GraphicsImporter getImage() {
        return this.graphicsImporter;
    }

    public synchronized void setMovieController(MovieController movieController) throws QTException {
        movieController.getMovie().setGWorld(QDGraphics.scratch, null);
        this.qtcHelper.doSetMovieController(movieController, movieController != null ? movieController.getBounds() : null, this.getMinimumSize(), this.getMaximumSize(), false);
    }

    public synchronized void setMovie(Movie movie) throws QTException {
        this.qtcHelper.doSetMovie(movie, movie != null ? movie.getBounds() : null, this.getMinimumSize(), this.getMaximumSize(), false);
    }

    public synchronized void setImage(GraphicsImporter graphicsImporter) throws QTException {
        this.qtcHelper.doSetGraphicsImporter(graphicsImporter, graphicsImporter != null ? graphicsImporter.getBoundsRect() : null, this.getMinimumSize(), this.getMaximumSize(), false);
    }

    public synchronized void setSequenceGrabber(SequenceGrabber sequenceGrabber) throws QTException {
        this.qtcHelper.doSetSequenceGrabber(sequenceGrabber, sequenceGrabber != null ? this.videoChannel.getBounds() : null, this.getMinimumSize(), this.getMaximumSize(), false);
    }

    void setInitialWidthAndHeight(QDRect qDRect, Dimension dimension, Dimension dimension2) {
        this.initialWidth = qDRect.getWidth();
        this.initialHeight = qDRect.getHeight();
        this.minWidth = dimension.width < 0 ? 0 : dimension.width;
        this.minHeight = dimension.height < 0 ? 0 : dimension.height;
        this.maxWidth = dimension2.width < this.minWidth ? this.minWidth : dimension2.width;
        this.maxHeight = dimension2.height < this.minHeight ? this.minHeight : dimension2.height;
        if (this.initialWidth < this.minWidth) {
            this.initialWidth = this.minWidth;
        } else if (this.initialWidth > this.maxWidth) {
            this.initialWidth = this.maxWidth;
        }
        if (this.initialHeight < this.minHeight) {
            this.initialHeight = this.minHeight;
        } else if (this.initialHeight > this.maxHeight) {
            this.initialHeight = this.maxHeight;
        }
        if (!this.appHasSetPreferredSize) {
            this.prefWidth = this.initialWidth;
            this.prefHeight = this.initialHeight;
        }
    }

    final void doParentLayout() {
        Container container = this.getParent();
        if (container != null) {
            this.invalidate();
            container.validate();
            return;
        }
        super.reshape(this.currentX, this.currentY, this.currentWidth, this.currentHeight);
    }

    public void setMinimumSize(Dimension dimension) {
        if (dimension == null) {
            this.setMinimumSize(0, 0);
        } else {
            this.setMinimumSize(dimension.width, dimension.height);
        }
    }

    public void setMinimumSize(int n, int n2) {
        this.minWidth = n < 0 ? 0 : n;
        this.minHeight = n2 < 0 ? 0 : n2;
        if (this.currentWidth < this.minWidth || this.currentHeight < this.minHeight) {
            this.doParentLayout();
        }
    }

    public Dimension getMinimumSize() {
        return new Dimension(this.minWidth, this.minHeight);
    }

    public Dimension getBestSize() {
        return new Dimension(this.initialWidth, this.initialHeight);
    }

    public Dimension getPreferredSize() {
        return new Dimension(this.prefWidth, this.prefHeight);
    }

    public void setPreferredSize(Dimension dimension) {
        if (dimension == null) {
            this.setPreferredSize(this.initialWidth, this.initialHeight);
        } else {
            this.setPreferredSize(dimension.width, dimension.height);
        }
    }

    public void setPreferredSize(int n, int n2) {
        if (n < 0) {
            this.prefWidth = this.initialWidth;
            this.appHasSetPreferredSize = false;
        } else {
            this.prefWidth = n;
            this.appHasSetPreferredSize = true;
        }
        if (n2 < 0) {
            this.prefHeight = this.initialHeight;
            this.appHasSetPreferredSize = false;
        } else {
            this.prefHeight = n2;
            this.appHasSetPreferredSize = true;
        }
        if (this.currentWidth != this.prefWidth || this.currentHeight != this.prefHeight) {
            this.doParentLayout();
        }
    }

    public boolean isFocusTraversable() {
        return true;
    }

    public void setMaximumSize(Dimension dimension) {
        if (dimension == null) {
            Dimension dimension2 = Toolkit.getDefaultToolkit().getScreenSize();
            this.setMaximumSize(dimension2.width, dimension2.height);
        } else {
            this.setMaximumSize(dimension.width, dimension.height);
        }
    }

    public void setMaximumSize(int n, int n2) {
        this.maxWidth = n < 0 ? 0 : n;
        this.maxHeight = n2 < 0 ? 0 : n2;
        if (this.currentWidth > this.maxWidth || this.currentHeight > this.maxHeight) {
            this.doParentLayout();
        }
    }

    public Dimension getMaximumSize() {
        return new Dimension(this.maxWidth, this.maxHeight);
    }

    private void setCurrentWidthHeight(int n, int n2) {
        if (n < this.minWidth) {
            n = this.minWidth;
        } else if (n > this.maxWidth) {
            n = this.maxWidth;
        }
        if (n2 < this.minHeight) {
            n2 = this.minHeight;
        } else if (n2 > this.maxHeight) {
            n2 = this.maxHeight;
        }
        this.currentWidth = n;
        this.currentHeight = n2;
    }

    private final void setCurrentXY(int n, int n2) {
        this.currentX = n;
        this.currentY = n2;
    }

    public void setSize(Dimension dimension) {
        this.setSize(dimension.width, dimension.height);
    }

    public void setSize(int n, int n2) {
        this.setBounds(this.currentX, this.currentY, n, n2);
    }

    public final void reshape(int n, int n2, int n3, int n4) {
        this.setBounds(n, n2, n3, n4);
    }

    public final synchronized void setBounds(int n, int n2, int n3, int n4) {
        boolean bl = this.isValid();
        int n5 = this.currentWidth;
        int n6 = this.currentHeight;
        this.setCurrentWidthHeight(n3, n4);
        boolean bl2 = n5 != this.currentWidth || n6 != this.currentHeight;
        int n7 = this.currentX;
        int n8 = this.currentY;
        this.setCurrentXY(n, n2);
        super.reshape(this.currentX, this.currentY, this.currentWidth, this.currentHeight);
        if (this.movie != null) {
            boolean bl3 = this.deferResize = this.deferResize || bl2;
            if (this.deferResize) {
                this.doRedrawForQTPlayer = !this.isWin && !bl && this.isShowing();
            }
            this.moved = n7 != this.currentX || n8 != this.currentY || this.moved;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void paint(Graphics graphics) {
        if (this.isValid() && this.qtcHelper != null) {
            QDGraphics qDGraphics = null;
            Region region = null;
            try {
                if (QTSession.isCurrentOS(1) || QTSession.isCurrentOS(4)) {
                    qDGraphics = this.getPort();
                    region = qDGraphics.getClip();
                    qDGraphics.clipRect();
                }
                if (this.movie == null && this.graphicsImporter == null && this.grabber == null) return;
                this.qtcHelper.doSetBounds();
                if (!this.qtcHelper.getGWorld().equals(QDGraphics.scratch)) {
                    QTUtils.checkFreeMemory();
                    this.qtcHelper.redraw(null);
                    return;
                }
                if (!this.isShowing()) return;
                QTUtils.checkFreeMemory();
                this.qtcHelper.redraw(null);
                return;
            }
            catch (QTException qTException) {
                return;
            }
            finally {
                if (qDGraphics != null && region != null) {
                    qDGraphics.setClip(region);
                }
            }
        } else {
            this.doParentLayout();
            this.repaint();
        }
    }

    public void update(Graphics graphics) {
        if (this.movie == null) {
            super.update(graphics);
        } else if (QTSession.isCurrentOS(4)) {
            this.paint(graphics);
        } else if (this.deferRedraw) {
            this.paint(graphics);
        }
    }

    public synchronized void setVisible(boolean bl) {
        super.setVisible(bl);
        try {
            if (bl) {
                this.qtcHelper.doSetGWorld(true);
                this.doParentLayout();
            } else {
                this.qtcHelper.doSetGWorld(false);
                Container container = this.getParent();
                if (container != null) {
                    container.repaint();
                }
            }
        }
        catch (QTException qTException) {
            QTRuntimeException.handleOrThrow(new QTRuntimeException(qTException), this.qtcHelper, "setGWorld");
        }
    }

    public void addQTClientListener(ComponentListener componentListener) {
        this.clientListener = AWTEventMulticaster.add(this.clientListener, componentListener);
    }

    public void removeQTClientListener(ComponentListener componentListener) {
        this.clientListener = AWTEventMulticaster.remove(this.clientListener, componentListener);
    }

    public synchronized void addNotify() {
        super.addNotify();
        if (!this.addDone) {
            try {
                this.ng = NativeGraphics.getContext(this);
                if (this.movie != null || this.graphicsImporter != null || this.grabber != null) {
                    this.qtcHelper.addedTo();
                    this.qtcHelper.doSetGWorld(this.isVisible());
                    if (this.isVisible()) {
                        if (!this.isWin) {
                            this.deferRedraw = true;
                        } else {
                            this.repaint();
                        }
                    }
                }
                QTSession.addActiveCanvas(this);
            }
            catch (QTException qTException) {
                this.qtcHelper.doRemoveClient();
                throw new QTRuntimeException(qTException);
            }
            this.addDone = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void removeNotify() {
        Object object = QTSession.terminationLock();
        synchronized (object) {
            if (this.addDone && QTSession.isInitialized()) {
                try {
                    if (this.movie != null) {
                        this.qtcHelper.doSetGWorld(false);
                        this.qtcHelper.removedFrom();
                    }
                    QTSession.removeActiveCanvas(this);
                    this.addDone = false;
                }
                catch (QTException qTException) {
                    this.qtcHelper.doRemoveClient();
                    throw new QTRuntimeException(qTException);
                }
                finally {
                    if (QTSession.isCurrentOS(2) && this.ng != null) {
                        QTJavaAWTCanvas.RemoveContext(this.ng);
                    }
                    this.ng = null;
                    super.removeNotify();
                }
            } else {
                super.removeNotify();
            }
        }
    }

    public Component asComponent() {
        return this;
    }

    public String toString() {
        return this.getClass().getName() + "_" + this.numCanvas + "_" + "[Location=" + this.getLocation() + ",Size=" + this.getSize() + "]";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void finalize() throws Throwable {
        try {
            this.removeNotify();
            Object var2_1 = null;
            this.movie = null;
        }
        catch (Throwable throwable) {
            Object var2_2 = null;
            this.movie = null;
            throw throwable;
        }
        super.finalize();
    }

    private static native void RemoveContext(Object var0);

    static {
        if (QTSession.isCurrentOS(2)) {
            MRJWorkaroundFlag = false;
        } else if (QTSession.isCurrentOS(1) || QTSession.isCurrentOS(4)) {
            String string = System.getProperty("java.version");
            int n = Character.getNumericValue(string.charAt(0));
            int n2 = 0;
            int n3 = 0;
            boolean bl = false;
            int n4 = 1;
            while (n4 < string.length()) {
                char c = string.charAt(n4);
                if (Character.isDigit(c)) {
                    if (!bl) {
                        n2 = Character.getNumericValue(c);
                        bl = true;
                    } else {
                        n3 = Character.getNumericValue(c);
                    }
                }
                ++n4;
            }
            MRJWorkaroundFlag = n == 1 && n2 == 1 && n3 < 8;
        }
        canvasCount = 0;
    }
}

