/*
 * Decompiled with CFR 0.152.
 */
package quicktime.app.view;

import com.apple.eawt.CocoaComponent;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import quicktime.QTException;
import quicktime.QTObject;
import quicktime.QTRuntimeException;
import quicktime.QTSession;
import quicktime.app.view.QTComponent;
import quicktime.jdirect.QTNative;
import quicktime.qd.QDGraphics;
import quicktime.qd.QDRect;
import quicktime.std.StdQTException;
import quicktime.std.image.GraphicsImporter;
import quicktime.std.image.ImageDescription;
import quicktime.std.movies.Movie;
import quicktime.std.movies.MovieController;
import quicktime.std.sg.SGVideoChannel;
import quicktime.std.sg.SequenceGrabber;
import quicktime.util.ByteEncodedImage;
import quicktime.util.EncodedImage;
import quicktime.util.IntEncodedImage;
import quicktime.util.QTPointer;
import quicktime.util.RawEncodedImage;

class QTJavaCocoaCanvas
extends CocoaComponent
implements QTComponent {
    private static final int kSetMovieUrl = 0;
    private static final int kSetMovie = 1;
    private static final int kGetMovieController = 2;
    private static final int kSetImage = 3;
    private static final int kSetBounds = 4;
    private static final int kRemoveDrawable = 5;
    private static final int kSetMovieController = 6;
    private static final int kSeqDraw = 7;
    private static final int kSetGWorld = 8;
    private int qtjavaView = 0;
    private boolean addDone = false;
    private boolean viewShown = false;
    private Movie movie;
    private MovieController controller;
    private GraphicsImporter image;
    private SGVideoChannel videoChannel;
    private SequenceGrabber grabber;
    private ImageDescription imageDesc;
    private EncodedImage imageData;
    private int currentX;
    private int currentY;
    private int currentWidth;
    private int currentHeight;
    private int minWidth = 1;
    private int minHeight = 1;
    private int maxWidth = Integer.MAX_VALUE;
    private int maxHeight = Integer.MAX_VALUE;
    private QDRect oldbounds = null;
    transient int initialWidth = 1;
    transient int initialHeight = 1;
    private transient int prefWidth;
    private transient int prefHeight;
    private boolean performanceResize = false;
    private boolean debug = false;
    private boolean QTMOVIEVIEW = false;
    ByteBuffer byteBuf;
    IntBuffer intBuf;
    Buffer buf;
    int[] intArrPtr;
    byte[] byteArrPtr;
    QTPointer dataPtr;

    private static native void initGlobalLock(Object var0);

    private static native void initGlobalOffScreen(Object var0);

    private native void setFullScreen(byte var1);

    private native void setMovie(int var1, Object var2);

    private native void setGraphicsImporter(int var1, Object var2);

    private native void setMovieController(int var1, Object var2);

    private native int createNSViewNative(int var1, int var2, Object var3, Object var4);

    private native int createImageNSViewNative(int var1, int var2, Object var3);

    private native int createSequenceGrabberNSView(int var1, int var2, Object var3);

    private native int createImageDescNSView(int var1, int var2, Object var3, Object var4, Object var5, Object var6);

    private native Object getMovieController(int var1);

    private native void removeMovie(int var1);

    private native void removeImage(int var1);

    public int createNSView() {
        QDRect qDRect = null;
        QTPointer qTPointer = null;
        if (this.debug) {
            System.err.println("***createNSView");
        }
        if (this.movie != null) {
            try {
                if (this.controller != null) {
                    try {
                        qDRect = this.controller.getBounds();
                        if (this.debug) {
                            System.err.println("createNSView controller " + this.controller + "bounds " + qDRect);
                        }
                        this.setInitialWidthAndHeight(qDRect, this.getMinimumSize(), this.getMaximumSize());
                    }
                    catch (QTException qTException) {}
                } else {
                    qDRect = this.movie.getBounds();
                    this.setInitialWidthAndHeight(qDRect, this.getMinimumSize(), this.getMaximumSize());
                }
            }
            catch (StdQTException stdQTException) {
                // empty catch block
            }
            this.qtjavaView = this.createNSViewNative(qDRect.getWidth(), qDRect.getHeight(), new Integer(QTObject.ID(this.movie)), this.controller != null ? new Integer(QTObject.ID(this.controller)) : null);
            return this.qtjavaView;
        }
        if (this.image != null) {
            try {
                qDRect = this.image.getBoundsRect();
                this.setInitialWidthAndHeight(qDRect, this.getMinimumSize(), this.getMaximumSize());
            }
            catch (StdQTException stdQTException) {
                // empty catch block
            }
            this.qtjavaView = this.createImageNSViewNative(qDRect.getWidth(), qDRect.getHeight(), new Integer(QTObject.ID(this.image)));
            return this.qtjavaView;
        }
        if (this.imageDesc != null) {
            try {
                qDRect = this.imageDesc.getBounds();
                this.setInitialWidthAndHeight(qDRect, this.getMinimumSize(), this.getMaximumSize());
                qTPointer = QTPointer.fromEncodedImage(this.imageData);
                this.createDataBuffer(qDRect.getWidth(), qDRect.getHeight());
            }
            catch (QTException qTException) {
                qTException.printStackTrace();
            }
        } else if (this.videoChannel != null) {
            try {
                this.grabber = this.videoChannel.getSequenceGrabber();
                qDRect = this.videoChannel.getBounds();
                this.setInitialWidthAndHeight(qDRect, this.getMinimumSize(), this.getMaximumSize());
            }
            catch (StdQTException stdQTException) {
                // empty catch block
            }
            this.qtjavaView = this.createSequenceGrabberNSView(qDRect.getWidth(), qDRect.getHeight(), new Integer(QTObject.ID(this.grabber)));
            return this.qtjavaView;
        }
        return 0;
    }

    QTJavaCocoaCanvas(MovieController movieController) throws QTException {
        this();
        this.movie = movieController.getMovie();
        this.controller = movieController;
        if (this.debug) {
            System.err.println("QTJavaCocoaCanvas " + this.movie + ", " + this.controller);
        }
    }

    QTJavaCocoaCanvas(Movie movie) {
        this();
        this.movie = movie;
        this.controller = null;
        this.performanceResize = false;
        if (this.debug) {
            System.err.println("QTJavaCocoaCanvas " + this.movie);
        }
    }

    QTJavaCocoaCanvas(GraphicsImporter graphicsImporter) {
        this();
        this.image = graphicsImporter;
        if (this.debug) {
            System.err.println("QTJavaCocoaCanvas " + graphicsImporter);
        }
    }

    private QTJavaCocoaCanvas() {
    }

    public void addNotify() {
        super.addNotify();
        Object var1_1 = null;
        Object var2_2 = null;
        if (!this.addDone) {
            if (this.debug) {
                System.err.println("addNotify qtjavaView " + this.qtjavaView);
            }
            QTSession.addActiveCanvas(this);
            this.addDone = true;
        }
        this.repaint();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void removeNotify() {
        block6: {
            if (this.debug) {
                System.err.println("removeNotify:");
            }
            if (this.addDone && QTSession.isInitialized()) {
                try {
                    if (this.movie != null) {
                        this.doRemoveDrawable();
                    }
                    QTSession.removeActiveCanvas(this);
                    if (this.debug) {
                        System.err.println("removeNotify:");
                    }
                    this.addDone = false;
                    Object var2_1 = null;
                }
                catch (Throwable throwable) {
                    Object var2_2 = null;
                    super.removeNotify();
                    throw throwable;
                }
                super.removeNotify();
                {
                    break block6;
                }
            }
            super.removeNotify();
        }
    }

    private final void doParentLayout() {
        Container container;
        if (this.debug) {
            System.err.println("doParentLayout:" + this.getParent());
        }
        if ((container = this.getParent()) != null) {
            this.invalidate();
            container.validate();
            return;
        }
        super.reshape(this.currentX, this.currentY, this.currentWidth, this.currentHeight);
    }

    public void setBounds(int n, int n2, int n3, int n4) {
        if (this.debug) {
            System.err.println("setBounds " + n + ", " + n2 + ", " + n3 + ", " + n4);
        }
        this.setCurrentWidthHeight(n3, n4);
        this.setCurrentXY(n, n2, n3, n4);
        super.reshape(this.currentX, this.currentY, this.currentWidth, this.currentHeight);
        QDRect qDRect = new QDRect(this.currentX, this.currentY, this.currentWidth, this.currentHeight);
        if (!qDRect.equals(this.oldbounds)) {
            if (this.debug) {
                System.err.println("setBounds sendMessage " + qDRect);
            }
            this.oldbounds = qDRect;
        }
    }

    private final void setCurrentXY(int n, int n2, int n3, int n4) {
        int n5;
        int n6 = n3 - this.currentWidth;
        if (n6 < 0) {
            n6 = 0;
        }
        if ((n5 = n4 - this.currentHeight) < 0) {
            n5 = 0;
        }
        if (this.performanceResize) {
            this.currentX = n + (int)(0.5f * (float)n6);
            this.currentY = n2 + (int)(0.5f * (float)n5);
        } else {
            this.currentX = n;
            this.currentY = n2;
        }
        if (this.debug) {
            System.err.println("setCurrentXY " + this.currentX + " " + this.currentY);
        }
    }

    public float getAlignmentX() {
        return this.performanceResize ? 0.5f : 0.0f;
    }

    public float getAlignmentY() {
        return this.performanceResize ? 0.5f : 0.0f;
    }

    private void setCurrentWidthHeight(int n, int n2) {
        if (n < this.minWidth) {
            n = this.minWidth;
        } else if (n > this.maxWidth) {
            n = this.maxWidth;
        }
        if (n2 < this.minHeight) {
            n2 = this.minHeight;
        } else if (n2 > this.maxHeight) {
            n2 = this.maxHeight;
        }
        if (this.performanceResize) {
            this.setPerformanceResize(n, n2);
        } else {
            this.currentWidth = n;
            this.currentHeight = n2;
        }
        if (this.debug) {
            System.out.println("setCurrentWidthHeight( " + this.currentWidth + ", " + this.currentHeight + ", " + this.minWidth + ", " + this.minHeight);
        }
    }

    private void setInitialWidthAndHeight(QDRect qDRect, Dimension dimension, Dimension dimension2) {
        this.initialWidth = qDRect.getWidth();
        this.initialHeight = qDRect.getHeight();
        this.minWidth = dimension.width < 0 ? 0 : dimension.width;
        this.minHeight = dimension.height < 0 ? 0 : dimension.height;
        this.maxWidth = dimension2.width < this.minWidth ? this.minWidth : dimension2.width;
        this.maxHeight = dimension2.height < this.minHeight ? this.minHeight : dimension2.height;
        if (this.initialWidth < this.minWidth) {
            this.initialWidth = this.minWidth;
        } else if (this.initialWidth > this.maxWidth) {
            this.initialWidth = this.maxWidth;
        }
        if (this.initialHeight < this.minHeight) {
            this.initialHeight = this.minHeight;
        } else if (this.initialHeight > this.maxHeight) {
            this.initialHeight = this.maxHeight;
        }
        this.prefWidth = this.initialWidth;
        this.prefHeight = this.initialHeight;
        if (this.debug) {
            System.err.println("setInitialWidthAndHeight " + this.initialWidth + " " + this.initialHeight + " " + this.prefWidth + " " + this.prefHeight);
        }
    }

    private void setPerformanceResize(int n, int n2) {
        boolean bl = false;
        int n3 = 2;
        while (!bl) {
            boolean bl2;
            int n4;
            int n5;
            if (n < this.initialWidth || n2 < this.initialHeight) {
                n5 = this.initialWidth / n3;
                n4 = this.initialHeight / n3;
                if (n5 <= n && n4 <= n2) {
                    bl = true;
                    bl2 = false;
                    this.currentWidth = n5;
                    this.currentHeight = n4;
                    while (bl2) {
                        if (this.currentWidth >= this.minWidth && this.currentHeight >= this.minHeight) {
                            bl2 = true;
                        }
                        this.currentWidth *= 2;
                        this.currentHeight *= 2;
                    }
                }
            } else {
                n5 = this.initialWidth * n3;
                n4 = this.initialHeight * n3;
                if (n5 >= n || n4 >= n2) {
                    bl = true;
                    if (n5 > n || n4 > n2) {
                        n5 /= 2;
                        n4 /= 2;
                    }
                    bl2 = false;
                    this.currentWidth = n5;
                    this.currentHeight = n4;
                    while (bl2) {
                        if (this.currentWidth <= this.maxWidth && this.currentHeight <= this.maxHeight) {
                            bl2 = true;
                        }
                        this.currentWidth /= 2;
                        this.currentHeight /= 2;
                    }
                }
            }
            n3 *= 2;
        }
    }

    public Dimension getPreferredSize() {
        Dimension dimension = null;
        dimension = new Dimension(this.prefWidth, this.prefHeight);
        if (this.debug) {
            System.err.println("getPreferredSize " + dimension);
        }
        return dimension;
    }

    public Dimension getBestSize() {
        Dimension dimension = null;
        dimension = new Dimension(this.initialWidth, this.initialHeight);
        if (this.debug) {
            System.err.println("getBestSize " + dimension);
        }
        return dimension;
    }

    public Dimension getMinimumSize() {
        Dimension dimension = null;
        dimension = new Dimension(this.minWidth, this.minHeight);
        if (this.debug) {
            System.err.println("getMinimumSize " + dimension);
        }
        return dimension;
    }

    public Dimension getMaximumSize() {
        Dimension dimension = null;
        dimension = new Dimension(Short.MAX_VALUE, Short.MAX_VALUE);
        if (this.debug) {
            System.err.println("getMaximumSize " + dimension);
        }
        return dimension;
    }

    private void setFullScreen() {
        this.setFullScreen((byte)1);
    }

    public void removeMovie() throws QTException {
        this.movie = null;
        this.controller = null;
        this.image = null;
        this.doRemoveDrawable();
        this.repaint();
    }

    public Movie getMovie() {
        return this.movie;
    }

    public MovieController getMovieController() {
        return this.controller;
    }

    public GraphicsImporter getImage() {
        return this.image;
    }

    public void setMovieController(MovieController movieController) throws QTException {
        QDRect qDRect = null;
        if (movieController == this.controller) {
            return;
        }
        if (this.controller != null) {
            this.removeMovie();
        }
        if (movieController != null) {
            this.controller = movieController;
            this.movie = this.controller.getMovie();
            try {
                if (this.controller != null && this.controller.getVisible()) {
                    try {
                        qDRect = this.controller.getBounds();
                        this.setInitialWidthAndHeight(qDRect, this.getMinimumSize(), this.getMaximumSize());
                        if (this.qtjavaView != 0) {
                            this.sendMessage(6, new Integer(QTObject.ID(this.controller)));
                        }
                    }
                    catch (QTException qTException) {}
                } else {
                    qDRect = this.movie.getBounds();
                    this.setInitialWidthAndHeight(qDRect, this.getMinimumSize(), this.getMaximumSize());
                }
                if (this.qtjavaView != 0) {
                    this.sendMessage(1, new Integer(QTObject.ID(this.movie)));
                }
                this.doParentLayout();
            }
            catch (StdQTException stdQTException) {
                // empty catch block
            }
        }
        this.repaint();
    }

    public void setMovie(Movie movie) throws QTException {
        QDRect qDRect = null;
        if (movie == this.movie) {
            return;
        }
        if (this.movie != null) {
            this.removeMovie();
        }
        if (movie != null) {
            this.movie = movie;
            qDRect = this.movie.getBounds();
            this.setInitialWidthAndHeight(qDRect, this.getMinimumSize(), this.getMaximumSize());
            if (this.qtjavaView != 0) {
                this.sendMessage(1, new Integer(QTObject.ID(this.movie)));
            }
            this.doParentLayout();
            this.controller = null;
            if (this.qtjavaView != 0) {
                this.sendMessage(6, null);
            }
        }
        this.repaint();
    }

    public void setImage(GraphicsImporter graphicsImporter) {
        QDRect qDRect = null;
        if (this.image == graphicsImporter) {
            return;
        }
        if (this.image != null) {
            this.doRemoveDrawable();
        }
        if (graphicsImporter != null) {
            this.image = graphicsImporter;
            try {
                qDRect = this.image.getBoundsRect();
                this.setInitialWidthAndHeight(qDRect, this.getMinimumSize(), this.getMaximumSize());
                this.doParentLayout();
            }
            catch (StdQTException stdQTException) {
                // empty catch block
            }
            if (this.qtjavaView != 0) {
                this.sendMessage(3, new Integer(QTObject.ID(this.image)));
            }
        }
        this.repaint();
    }

    public Component asComponent() {
        return this;
    }

    void createDataBuffer(int n, int n2) {
        this.byteBuf = ByteBuffer.allocate(n * n2 * 4);
        this.setDataPtr(this.byteBuf.array());
        this.intBuf = IntBuffer.allocate(n * n2);
        this.setDataPtr(this.intBuf.array());
    }

    void setDataPtr(int[] nArray) {
        if (this.debug) {
            System.err.println("QTJavaCocoaCanvas setDataPtr: " + nArray + ", size:" + nArray.length);
        }
        this.intArrPtr = nArray;
    }

    void setDataPtr(byte[] byArray) {
        if (this.debug) {
            System.err.println("QTJavaCocoaCanvas setDataPtr: " + byArray + ", size:" + byArray.length);
        }
        this.byteArrPtr = byArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void doDraw(EncodedImage encodedImage) {
        Object object = QTNative.globalsLock;
        synchronized (object) {
            if (this.buf != null) {
                this.buf.clear();
                this.buf.rewind();
            }
            if (encodedImage instanceof ByteEncodedImage) {
                if (this.debug) {
                    System.err.println("isByteEncodedImage");
                }
                byte[] byArray = ((ByteEncodedImage)encodedImage).getBytes();
                System.arraycopy(byArray, 0, this.byteArrPtr, 0, this.byteArrPtr.length);
                this.buf = this.byteBuf;
            } else if (encodedImage instanceof IntEncodedImage) {
                int[] nArray = ((IntEncodedImage)encodedImage).getInts();
                System.err.println("isIntEncodedImage ar : " + nArray.length + ", intBuf : " + this.intBuf.limit());
                System.arraycopy(nArray, 0, this.intArrPtr, 0, this.intArrPtr.length);
                this.buf = this.intBuf;
            } else if (encodedImage instanceof RawEncodedImage) {
                if (this.debug) {
                    System.err.println("isRawEncodedImage");
                }
                byte[] byArray = ((RawEncodedImage)encodedImage).getBytes();
                System.arraycopy(byArray, 0, this.byteArrPtr, 0, this.byteArrPtr.length);
                this.buf = this.byteBuf;
            }
        }
        this.sendMessage(7, new Integer(0));
    }

    void paintCall() {
    }

    void setGWorld(QDGraphics qDGraphics) {
        if (qDGraphics != null) {
            this.sendMessage(8, new Integer(QTObject.ID(qDGraphics)));
        } else {
            this.sendMessage(8, new Integer(0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void doRemoveDrawable() {
        QDGraphics qDGraphics = null;
        if (this.debug) {
            System.out.println("doRemoveDrawable:");
        }
        try {
            qDGraphics = QDGraphics.scratch;
            if ((this.controller != null || this.movie != null || this.image != null) && QTSession.isInitialized()) {
                if (this.movie != null) {
                    this.movie.setRate(0.0f);
                    this.movie.stop();
                    this.movie.setActive(false);
                    this.movie.setGWorld(qDGraphics, null);
                    if (this.controller != null && this.controller.getVisible() && this.controller.isAttached()) {
                        this.controller.setPort(qDGraphics);
                        this.controller.setVisible(false);
                    } else if (this.controller != null) {
                        this.controller.setPort(qDGraphics);
                        this.controller.setVisible(false);
                        this.controller.movieChanged();
                        this.controller.disposeQTObject();
                    }
                } else if (this.image != null) {
                    this.image.setGWorld(qDGraphics, null);
                } else if (this.grabber != null) {
                    this.grabber.setGWorld(qDGraphics, null);
                }
            }
        }
        catch (QTException qTException) {
            if (this.debug) {
                qTException.printStackTrace();
            }
        }
        finally {
            if (this.qtjavaView != 0) {
                if (this.movie != null) {
                    this.sendMessage(5, new Integer(QTObject.ID(this.movie)));
                } else if (this.controller != null) {
                    this.sendMessage(5, new Integer(QTObject.ID(this.controller)));
                } else if (this.image != null) {
                    this.sendMessage(5, new Integer(QTObject.ID(this.image)));
                }
            }
            this.controller = null;
            this.image = null;
            this.movie = null;
        }
    }

    static {
        if (!QTSession.isCurrentOS(4)) {
            throw new QTRuntimeException("OS not supported");
        }
        if (QTSession.isCurrentOS(4) && QTSession.getJavaVersion() != 65540) {
            throw new QTRuntimeException("Java version not supported");
        }
        String string = "/System/Library/QuickTimeJava/QuickTimeJava.bundle/Contents/Resources/libCocoaInterface.jnilib";
        System.load(string);
        QTJavaCocoaCanvas.initGlobalLock(QTNative.globalsLock);
    }
}

