/*
 * Decompiled with CFR 0.152.
 */
package quicktime.io;

import java.io.IOException;
import quicktime.QTException;
import quicktime.QTObject;
import quicktime.io.QTFile;
import quicktime.io.QTIOException;
import quicktime.jdirect.QTNative;
import quicktime.jdirect.QuickTimeLib;

public abstract class OpenedFile
extends QTObject
implements QuickTimeLib {
    private static Object linkage = QTNative.linkNativeMethods(class$quicktime$io$OpenedFile == null ? (class$quicktime$io$OpenedFile = OpenedFile.class$("quicktime.io.OpenedFile")) : class$quicktime$io$OpenedFile);
    private static final byte rPerm = 1;
    private static final byte wPerm = 2;
    static final int kMovie = 1;
    static final int kStd = 2;
    private boolean closed = false;
    private QTFile f;
    private int fileType;
    static /* synthetic */ Class class$quicktime$io$OpenedFile;

    OpenedFile(QTFile qTFile, int n, int n2) throws QTException {
        super(OpenedFile.allocate(qTFile, n, n2));
        this.f = qTFile;
        this.fileType = n2;
    }

    private static int allocate(QTFile qTFile, int n, int n2) throws QTIOException {
        short s;
        try {
            QTFile.checkSecurity(qTFile.getCanonicalPath(), n);
        }
        catch (IOException iOException) {
            throw new QTIOException(iOException.getMessage());
        }
        short[] sArray = new short[]{0};
        byte by = 0;
        if ((n & 0x100) != 0) {
            by = 1;
        } else if ((n & 0x200) != 0) {
            by = 2;
        } else {
            throw new SecurityException(qTFile.getPath());
        }
        if (n2 == 1) {
            s = OpenedFile.OpenMovieFile(qTFile.getFSSpec(true, n), sArray, by);
        } else if (n2 == 2) {
            s = OpenedFile.FSpOpenDF(qTFile.getFSSpec(true, n), by, sArray);
        } else {
            throw new QTIOException(-50, qTFile.getPath() + ":Unknown File Type=" + n2);
        }
        QTIOException.checkError(s, qTFile.getPath());
        return sArray[0];
    }

    public final QTFile getFile() {
        return this.f;
    }

    public final void close() throws QTIOException {
        short s;
        if (this.closed) {
            return;
        }
        if (QTObject.ID(this) == 0) {
            return;
        }
        if (this.fileType == 1) {
            s = OpenedFile.CloseMovieFile((short)this._ID());
        } else if (this.fileType == 2) {
            s = OpenedFile.FSClose((short)this._ID());
        } else {
            throw new QTIOException(-50, this.f.getPath() + ":Unknown File Type:" + this.fileType);
        }
        QTIOException.checkError(s, this.f.getPath());
        this.closed = true;
    }

    protected final void _dispose() throws QTIOException {
        this.close();
    }

    private static native short OpenMovieFile(byte[] var0, short[] var1, byte var2);

    private static native short CloseMovieFile(short var0);

    private static native short FSpOpenDF(byte[] var0, byte var1, short[] var2);

    private static native short FSClose(short var0);

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

