/*
 * Decompiled with CFR 0.152.
 */
package quicktime.jdirect;

import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Vector;
import quicktime.QTSession;
import quicktime.jdirect.JDirectLinker;

public class JDirectLinker {
    private static final boolean debug = false;
    private static final String kLibraryInstanceFieldName = "libraryInstance";
    static /* synthetic */ Class class$quicktime$jdirect$SharedLibrary;

    public static Object loadLibrary(String string) {
        return new Library(string);
    }

    public static void linkNativeMethods(Class clazz, String[] stringArray) {
        int[] nArray = JDirectLinker.loadNativeLibraries(stringArray);
        MethodSpec[] methodSpecArray = JDirectLinker.getNativeMethods(clazz);
        int n = methodSpecArray.length;
        int n2 = 0;
        while (n2 < n) {
            MethodSpec methodSpec = methodSpecArray[n2];
            JDirectLinker.linkNativeMethod(clazz, methodSpec.name, methodSpec.signature, methodSpec.frameSize, nArray);
            ++n2;
        }
    }

    public static void linkNativeMethods(Class clazz) {
        int[] nArray = JDirectLinker.gatherLibraries(clazz);
        MethodSpec[] methodSpecArray = JDirectLinker.getNativeMethods(clazz);
        int n = methodSpecArray.length;
        int n2 = 0;
        while (n2 < n) {
            MethodSpec methodSpec = methodSpecArray[n2];
            JDirectLinker.linkNativeMethod(clazz, methodSpec.name, methodSpec.signature, methodSpec.frameSize, nArray);
            ++n2;
        }
    }

    private static int[] gatherLibraries(Class clazz) {
        Vector vector = new Vector();
        while (clazz != null) {
            JDirectLinker.examineInterfaces(vector, clazz.getInterfaces());
            clazz = clazz.getSuperclass();
        }
        int n = vector.size();
        int[] nArray = new int[n];
        int n2 = 0;
        while (n2 < n) {
            Library library = (Library)vector.elementAt(n2);
            nArray[n2] = library.libraryHandle;
            ++n2;
        }
        return nArray;
    }

    private static void examineInterfaces(Vector vector, Class[] classArray) {
        int n = classArray.length;
        int n2 = 0;
        while (n2 < n) {
            Class clazz;
            if ((class$quicktime$jdirect$SharedLibrary == null ? JDirectLinker.class$("quicktime.jdirect.SharedLibrary") : class$quicktime$jdirect$SharedLibrary) != (clazz = classArray[n2]) && (class$quicktime$jdirect$SharedLibrary == null ? JDirectLinker.class$("quicktime.jdirect.SharedLibrary") : class$quicktime$jdirect$SharedLibrary).isAssignableFrom(clazz)) {
                Class[] classArray2;
                try {
                    Library library;
                    classArray2 = clazz.getDeclaredField(kLibraryInstanceFieldName);
                    if (classArray2 != null && (library = (Library)classArray2.get(clazz)) != null) {
                        vector.addElement(library);
                    }
                }
                catch (NoSuchFieldException noSuchFieldException) {
                }
                catch (IllegalAccessException illegalAccessException) {
                    System.err.println("JDirectLinker.examineInterfaces: can't access library field from interface: " + clazz.getName());
                }
                catch (Throwable throwable) {
                    System.err.println("JDirectLinker.examineInterfaces: exception: " + throwable);
                }
                classArray2 = clazz.getInterfaces();
                if (classArray2.length != 0) {
                    JDirectLinker.examineInterfaces(vector, classArray2);
                }
            }
            ++n2;
        }
    }

    private static native int[] loadNativeLibraries(String[] var0) throws UnsatisfiedLinkError;

    private static native void linkNativeMethod(Class var0, String var1, String var2, int var3, int[] var4) throws UnsatisfiedLinkError;

    private static native int loadNativeLibrary(String var0);

    private static native void unloadNativeLibrary(int var0);

    private static MethodSpec[] getNativeMethods(Class clazz) {
        Object object;
        Vector<MethodSpec> vector = new Vector<MethodSpec>();
        Method[] methodArray = clazz.getDeclaredMethods();
        int n = methodArray.length;
        int n2 = 0;
        while (n2 < n) {
            object = methodArray[n2];
            if (Modifier.isNative(((Method)object).getModifiers())) {
                String string = ((Method)object).getName();
                String string2 = JDirectLinker.getSignature((Method)object);
                int n3 = JDirectLinker.getFrameSize((Method)object);
                vector.addElement(new MethodSpec(string, string2, n3));
            }
            ++n2;
        }
        object = new MethodSpec[vector.size()];
        vector.copyInto((Object[])object);
        return object;
    }

    private static int getFrameSize(Method method) {
        int n = 0;
        Class<?>[] classArray = method.getParameterTypes();
        int n2 = classArray.length;
        int n3 = 0;
        while (n3 < n2) {
            n += JDirectLinker.getArgSize(classArray[n3]);
            ++n3;
        }
        return n;
    }

    private static int getArgSize(Class clazz) {
        String string = clazz.getName();
        if (clazz.isPrimitive()) {
            char c = Character.toUpperCase(string.charAt(0));
            switch (c) {
                case 'D': 
                case 'L': {
                    return 8;
                }
            }
            return 4;
        }
        return 4;
    }

    private static String getSignature(Method method) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append('(');
        Class<?>[] classArray = method.getParameterTypes();
        int n = classArray.length;
        int n2 = 0;
        while (n2 < n) {
            stringBuffer.append(JDirectLinker.getSignature(classArray[n2]));
            ++n2;
        }
        stringBuffer.append(')');
        stringBuffer.append(JDirectLinker.getSignature(method.getReturnType()));
        return stringBuffer.toString();
    }

    private static String getSignature(Class clazz) {
        String string = clazz.getName();
        if (clazz.isPrimitive()) {
            char c = Character.toUpperCase(string.charAt(0));
            switch (c) {
                case 'B': {
                    if (clazz == Byte.TYPE) {
                        return "B";
                    }
                    return "Z";
                }
                case 'L': {
                    return "J";
                }
            }
            char[] cArray = new char[]{c};
            return new String(cArray);
        }
        if (clazz.isArray()) {
            return "[" + JDirectLinker.getSignature(clazz.getComponentType());
        }
        return "L" + string.replace('.', '/') + ";";
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        if (QTSession.isCurrentOS(2)) {
            if (QTSession.getJavaVersion() == 65537) {
                System.loadLibrary("QTJava");
            } else {
                class PrivelegedAction {
                    PrivelegedAction() {
                    }

                    void establish() {
                        AccessController.doPrivileged(new PrivilegedAction(this){
                            private final /* synthetic */ PrivelegedAction this$0;
                            {
                                this.this$0 = privelegedAction;
                            }

                            public Object run() {
                                System.loadLibrary("QTJava");
                                return null;
                            }
                        });
                    }
                }
                new PrivelegedAction().establish();
            }
        }
    }

    static class Library {
        String libraryName;
        int libraryHandle;

        Library(String string) {
            this.libraryName = string + ".dll";
            this.libraryHandle = JDirectLinker.loadNativeLibrary(this.libraryName);
        }

        protected void finalize() {
            JDirectLinker.unloadNativeLibrary(this.libraryHandle);
        }
    }

    static class MethodSpec {
        public String name;
        public String signature;
        public int frameSize;

        public MethodSpec() {
        }

        public MethodSpec(String string, String string2, int n) {
            this.name = string;
            this.signature = string2;
            this.frameSize = n;
        }

        public String toString() {
            return this.name + this.signature + "@" + this.frameSize;
        }
    }
}

