/*
 * Decompiled with CFR 0.152.
 */
package quicktime.qd;

import java.awt.Canvas;
import java.awt.Component;
import java.awt.Point;
import java.awt.peer.ComponentPeer;
import quicktime.QTSession;
import quicktime.QTUnknownOSException;
import quicktime.WinJNIDrawingSurface;
import quicktime.qd.MacNativeGraphics;
import quicktime.qd.NativeGraphicsException;
import quicktime.qd.QDGraphics;
import quicktime.qd.WinNativeGraphics;
import sun.awt.DrawingSurface;
import sun.awt.DrawingSurfaceInfo;

public abstract class NativeGraphics {
    DrawingSurfaceInfo dsi;
    WinJNIDrawingSurface jnidrawingsurfaceinfo;

    public static final NativeGraphics getContext(Canvas canvas) throws NativeGraphicsException, QTUnknownOSException {
        return NativeGraphics.getContext((Component)canvas);
    }

    public static final NativeGraphics getContext(Component component) throws NativeGraphicsException, QTUnknownOSException {
        ComponentPeer componentPeer = component.getPeer();
        if (componentPeer == null) {
            throw new NativeGraphicsException("AWT drawing environment is not initialised");
        }
        if (QTSession.isCurrentOS(1) || QTSession.isCurrentOS(4)) {
            DrawingSurfaceInfo drawingSurfaceInfo = ((DrawingSurface)componentPeer).getDrawingSurfaceInfo();
            return new MacNativeGraphics(drawingSurfaceInfo);
        }
        if (QTSession.isCurrentOS(2)) {
            if (QTSession.getJavaVersion() >= 65540) {
                WinJNIDrawingSurface winJNIDrawingSurface = new WinJNIDrawingSurface(component);
                return new WinNativeGraphics(winJNIDrawingSurface);
            }
            DrawingSurfaceInfo drawingSurfaceInfo = ((DrawingSurface)componentPeer).getDrawingSurfaceInfo();
            return new WinNativeGraphics(drawingSurfaceInfo);
        }
        throw new QTUnknownOSException();
    }

    public static final NativeGraphics getContext(Object object) throws NativeGraphicsException, QTUnknownOSException {
        Class<?> clazz = object.getClass();
        String string = clazz.getName();
        while (!clazz.getName().equals("java.lang.Object")) {
            string = clazz.getName();
            clazz = clazz.getSuperclass();
        }
        if (string.equals("java.awt.Component")) {
            ComponentPeer componentPeer = ((Component)object).getPeer();
            if (componentPeer == null) {
                throw new NativeGraphicsException("AWT drawing environment is not initialised");
            }
            if (QTSession.isCurrentOS(1) || QTSession.isCurrentOS(4)) {
                DrawingSurfaceInfo drawingSurfaceInfo = ((DrawingSurface)componentPeer).getDrawingSurfaceInfo();
                return new MacNativeGraphics(drawingSurfaceInfo);
            }
            if (QTSession.isCurrentOS(2)) {
                if (QTSession.getJavaVersion() >= 65540) {
                    WinJNIDrawingSurface winJNIDrawingSurface = new WinJNIDrawingSurface((Component)object);
                    return new WinNativeGraphics(winJNIDrawingSurface);
                }
                DrawingSurfaceInfo drawingSurfaceInfo = ((DrawingSurface)componentPeer).getDrawingSurfaceInfo();
                return new WinNativeGraphics(drawingSurfaceInfo);
            }
            throw new QTUnknownOSException();
        }
        throw new NativeGraphicsException("Unknown Native Context");
    }

    NativeGraphics(Object object) {
        this.dsi = null;
        this.jnidrawingsurfaceinfo = null;
    }

    NativeGraphics(DrawingSurfaceInfo drawingSurfaceInfo) {
        this.dsi = drawingSurfaceInfo;
    }

    NativeGraphics(WinJNIDrawingSurface winJNIDrawingSurface) {
        this.jnidrawingsurfaceinfo = winJNIDrawingSurface;
    }

    public abstract QDGraphics getGWorld() throws NativeGraphicsException;

    abstract int _getWindow() throws NativeGraphicsException;

    public final Point getLocation() {
        if (QTSession.isCurrentOS(2) && QTSession.getJavaVersion() >= 65540) {
            return this.jnidrawingsurfaceinfo.getBounds().getLocation();
        }
        return this.dsi.getBounds().getLocation();
    }

    public void lock() {
        if (QTSession.isCurrentOS(2) && QTSession.getJavaVersion() >= 65540) {
            this.jnidrawingsurfaceinfo.lock();
        } else {
            this.dsi.lock();
        }
    }

    public void unlock() {
        if (QTSession.isCurrentOS(2) && QTSession.getJavaVersion() >= 65540) {
            this.jnidrawingsurfaceinfo.unlock();
        } else {
            this.dsi.unlock();
        }
    }
}

